/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.xml;

import org.opennms.core.spring.FileReloadCallback;
import org.opennms.core.spring.FileReloadContainer;
import org.opennms.core.xml.JaxbUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public abstract class AbstractJaxbConfigDao<K, V>
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJaxbConfigDao.class);
    private Class<K> m_jaxbClass;
    private String m_description;
    private Resource m_configResource;
    private FileReloadContainer<V> m_container;
    private JaxbReloadCallback m_callback = new JaxbReloadCallback();
    private Long m_reloadCheckInterval = null;

    public AbstractJaxbConfigDao(Class<K> entityClass, String description) {
        this.m_jaxbClass = entityClass;
        this.m_description = description;
    }

    protected abstract V translateConfig(K var1);

    protected V loadConfig(Resource resource) {
        long startTime = System.currentTimeMillis();
        LOG.debug("Loading {} configuration from {}", (Object)this.m_description, (Object)resource);
        V config = this.translateConfig(JaxbUtils.unmarshal(this.m_jaxbClass, resource));
        long endTime = System.currentTimeMillis();
        LOG.info("Loaded {} in {} ms", (Object)this.getDescription(), (Object)(endTime - startTime));
        return config;
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_configResource != null ? 1 : 0) != 0, (String)"property configResource must be set and be non-null");
        V config = this.loadConfig(this.m_configResource);
        this.m_container = new FileReloadContainer(config, this.m_configResource, (FileReloadCallback)this.m_callback);
        if (this.m_reloadCheckInterval != null) {
            this.m_container.setReloadCheckInterval(this.m_reloadCheckInterval.longValue());
        }
    }

    public Resource getConfigResource() {
        return this.m_configResource;
    }

    public void setConfigResource(Resource configResource) {
        this.m_configResource = configResource;
    }

    public FileReloadContainer<V> getContainer() {
        return this.m_container;
    }

    public Long getReloadCheckInterval() {
        return this.m_reloadCheckInterval;
    }

    public void setReloadCheckInterval(Long reloadCheckInterval) {
        this.m_reloadCheckInterval = reloadCheckInterval;
        if (this.m_reloadCheckInterval != null && this.m_container != null) {
            this.m_container.setReloadCheckInterval(this.m_reloadCheckInterval.longValue());
        }
    }

    public String getDescription() {
        return this.m_description;
    }

    public class JaxbReloadCallback
    implements FileReloadCallback<V> {
        public V reload(V object, Resource resource) {
            return AbstractJaxbConfigDao.this.loadConfig(resource);
        }
    }
}

