/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.mp;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MutablePDU;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Target;
import org.snmp4j.TransportStateReference;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.asn1.BEROutputStream;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.mp.MutableStateReference;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OctetString;
import org.snmp4j.util.PDUFactory;

public class MPv2c
implements MessageProcessingModel {
    public static final int ID = 1;
    private static final LogAdapter logger = LogFactory.getLogger(MPv2c.class);
    protected PDUFactory incomingPDUFactory = new PDUFactory(){

        @Override
        public PDU createPDU(Target target) {
            return new PDU();
        }

        @Override
        public PDU createPDU(MessageProcessingModel messageProcessingModel) {
            return new PDU();
        }
    };

    public MPv2c() {
    }

    public MPv2c(PDUFactory incomingPDUFactory) {
        if (incomingPDUFactory != null) {
            this.incomingPDUFactory = incomingPDUFactory;
        }
    }

    @Override
    public int getID() {
        return 1;
    }

    @Override
    public int prepareOutgoingMessage(Address transportAddress, int maxMessageSize, int messageProcessingModel, int securityModel, byte[] securityName, int securityLevel, PDU pdu, boolean expectResponse, PduHandle sendPduHandle, Address destTransportAddress, BEROutputStream outgoingMessage, TransportStateReference tmStateReference) throws IOException {
        if (securityLevel != 1 || securityModel != 2) {
            logger.error((Serializable)((Object)"MPv2c used with unsupported security model"));
            return -1402;
        }
        if (pdu instanceof ScopedPDU) {
            String txt = "ScopedPDU must not be used with MPv2c";
            logger.error((Serializable)((Object)txt));
            throw new IllegalArgumentException(txt);
        }
        if (!this.isProtocolVersionSupported(messageProcessingModel)) {
            logger.error((Serializable)((Object)"MPv2c used with unsupported SNMP version"));
            return -1402;
        }
        OctetString community = new OctetString(securityName);
        Integer32 version = new Integer32(messageProcessingModel);
        int length = pdu.getBERLength();
        length += community.getBERLength();
        ByteBuffer buf = ByteBuffer.allocate((length += version.getBERLength()) + BER.getBERLengthOfLength(length) + 1);
        outgoingMessage.setBuffer(buf);
        BER.encodeHeader(outgoingMessage, 48, length);
        version.encodeBER(outgoingMessage);
        community.encodeBER(outgoingMessage);
        pdu.encodeBER(outgoingMessage);
        return 0;
    }

    @Override
    public int prepareResponseMessage(int messageProcessingModel, int maxMessageSize, int securityModel, byte[] securityName, int securityLevel, PDU pdu, int maxSizeResponseScopedPDU, StateReference stateReference, StatusInformation statusInformation, BEROutputStream outgoingMessage) throws IOException {
        return this.prepareOutgoingMessage(stateReference.getAddress(), maxMessageSize, messageProcessingModel, securityModel, securityName, securityLevel, pdu, false, stateReference.getPduHandle(), null, outgoingMessage, null);
    }

    @Override
    public int prepareDataElements(MessageDispatcher messageDispatcher, Address transportAddress, BERInputStream wholeMsg, TransportStateReference tmStateReference, Integer32 messageProcessingModel, Integer32 securityModel, OctetString securityName, Integer32 securityLevel, MutablePDU pdu, PduHandle sendPduHandle, Integer32 maxSizeResponseScopedPDU, StatusInformation statusInformation, MutableStateReference mutableStateReference) throws IOException {
        BER.MutableByte mutableByte = new BER.MutableByte();
        int length = BER.decodeHeader(wholeMsg, mutableByte);
        int startPos = (int)wholeMsg.getPosition();
        if (mutableByte.getValue() != 48) {
            String txt = "SNMPv2c PDU must start with a SEQUENCE";
            logger.error((Serializable)((Object)txt));
            throw new IOException(txt);
        }
        Integer32 version = new Integer32();
        version.decodeBER(wholeMsg);
        securityName.decodeBER(wholeMsg);
        securityLevel.setValue(1);
        securityModel.setValue(2);
        messageProcessingModel.setValue(1);
        PDU v2cPDU = this.incomingPDUFactory.createPDU(this);
        pdu.setPdu(v2cPDU);
        v2cPDU.decodeBER(wholeMsg);
        BER.checkSequenceLength(length, (int)wholeMsg.getPosition() - startPos, v2cPDU);
        sendPduHandle.setTransactionID(v2cPDU.getRequestID().getValue());
        StateReference stateRef = new StateReference(sendPduHandle, transportAddress, null, SecurityModels.getInstance().getSecurityModel(securityModel), securityName.getValue(), 0);
        mutableStateReference.setStateReference(stateRef);
        return 0;
    }

    @Override
    public boolean isProtocolVersionSupported(int snmpProtocolVersion) {
        return snmpProtocolVersion == 1;
    }

    @Override
    public void releaseStateReference(PduHandle pduHandle) {
    }
}

