/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.xml;

import java.io.Serializable;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.cim.CIMArgument;
import org.sblim.wbem.cim.CIMClass;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMDateTime;
import org.sblim.wbem.cim.CIMElement;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMFlavor;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMMethod;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMParameter;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMQualifier;
import org.sblim.wbem.cim.CIMQualifierType;
import org.sblim.wbem.cim.CIMScope;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.cim.Numeric;
import org.sblim.wbem.cim.UnsignedInt16;
import org.sblim.wbem.cim.UnsignedInt32;
import org.sblim.wbem.cim.UnsignedInt64;
import org.sblim.wbem.cim.UnsignedInt8;
import org.sblim.wbem.util.SessionProperties;
import org.sblim.wbem.xml.CIMClientXML_HelperImpl;
import org.sblim.wbem.xml.CIMMessage;
import org.sblim.wbem.xml.CIMRequest;
import org.sblim.wbem.xml.CIMResponse;
import org.sblim.wbem.xml.CIMXMLParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class CIMXMLParserImpl {
    public static CIMMessage parseCIM(Element cimE) throws CIMXMLParseException {
        Attr cim_cimversionA = (Attr)CIMXMLParserImpl.searchAttribute(cimE, "CIMVERSION");
        String cimversion = cim_cimversionA.getNodeValue();
        Attr cim_dtdversionA = (Attr)CIMXMLParserImpl.searchAttribute(cimE, "DTDVERSION");
        String dtdversion = cim_dtdversionA.getNodeValue();
        Element messageE = (Element)CIMXMLParserImpl.searchFirstNode(cimE, "MESSAGE");
        if (messageE != null) {
            CIMMessage message = CIMXMLParserImpl.parseMESSAGE(cimversion, dtdversion, messageE);
            message.setCIMVersion(cimversion);
            message.setDTDVersion(dtdversion);
            return message;
        }
        throw new CIMXMLParseException();
    }

    public static String parseVALUE(Element valueE) throws CIMXMLParseException {
        Text t = (Text)valueE.getFirstChild();
        if (t != null) {
            String valueStr = t.getNodeValue();
            return valueStr;
        }
        return null;
    }

    public static Vector parseVALUEARRAY(Element valuearrayE) throws CIMXMLParseException {
        Vector<String> v = new Vector<String>();
        Vector valueV = CIMXMLParserImpl.searchNodes(valuearrayE, "VALUE");
        if (valueV != null) {
            for (int i = 0; i < valueV.size(); ++i) {
                Element valueE = (Element)valueV.elementAt(i);
                String valueStr = CIMXMLParserImpl.parseVALUE(valueE);
                v.add(valueStr);
            }
        }
        return v;
    }

    public static CIMObjectPath parseVALUEREFERENCE(Element valuereferenceE) throws CIMXMLParseException {
        Element classpathE = (Element)CIMXMLParserImpl.searchFirstNode(valuereferenceE, "CLASSPATH");
        if (classpathE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseCLASSPATH(classpathE);
            return op;
        }
        Element localclasspathE = (Element)CIMXMLParserImpl.searchFirstNode(valuereferenceE, "LOCALCLASSPATH");
        if (localclasspathE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseLOCALCLASSPATH(localclasspathE);
            return op;
        }
        Element classnameE = (Element)CIMXMLParserImpl.searchFirstNode(valuereferenceE, "CLASSNAME");
        if (classnameE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseCLASSNAME(classnameE);
            return op;
        }
        Element instancepathE = (Element)CIMXMLParserImpl.searchFirstNode(valuereferenceE, "INSTANCEPATH");
        if (instancepathE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseINSTANCEPATH(instancepathE);
            return op;
        }
        Element localinstancepathE = (Element)CIMXMLParserImpl.searchFirstNode(valuereferenceE, "LOCALINSTANCEPATH");
        if (localinstancepathE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseLOCALINSTANCEPATH(localinstancepathE);
            return op;
        }
        Element instancenameE = (Element)CIMXMLParserImpl.searchFirstNode(valuereferenceE, "INSTANCENAME");
        if (instancenameE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseINSTANCENAME(instancenameE);
            return op;
        }
        throw new CIMXMLParseException();
    }

    public static Vector parseVALUEREFARRAY(Element valuerefarrayE) throws CIMXMLParseException {
        Vector<CIMValue> v = new Vector<CIMValue>();
        Vector valuereferenceV = CIMXMLParserImpl.searchNodes(valuerefarrayE, "VALUE.REFERENCE");
        for (int i = 0; i < valuereferenceV.size(); ++i) {
            Element valuereferenceE = (Element)valuereferenceV.elementAt(i);
            CIMObjectPath op = CIMXMLParserImpl.parseVALUEREFERENCE(valuereferenceE);
            v.add(new CIMValue(op, CIMDataType.getPredefinedType(30)));
        }
        return v;
    }

    public static CIMElement parseVALUEOBJECT(Element valueobjectE) throws CIMXMLParseException {
        Element classE = (Element)CIMXMLParserImpl.searchFirstNode(valueobjectE, "CLASS");
        if (classE != null) {
            CIMClass obj = CIMXMLParserImpl.parseCLASS(classE);
            return obj;
        }
        Element instanceE = (Element)CIMXMLParserImpl.searchFirstNode(valueobjectE, "INSTANCE");
        if (instanceE != null) {
            CIMInstance obj = CIMXMLParserImpl.parseINSTANCE(instanceE);
            return obj;
        }
        throw new CIMXMLParseException();
    }

    public static CIMElement parseVALUENAMEDINSTANCE(Element valuenamedinstanceE) throws CIMXMLParseException {
        Element instancenameE = (Element)CIMXMLParserImpl.searchFirstNode(valuenamedinstanceE, "INSTANCENAME");
        if (instancenameE == null) {
            throw new CIMXMLParseException();
        }
        CIMObjectPath op = CIMXMLParserImpl.parseINSTANCENAME(instancenameE);
        Element instanceE = (Element)CIMXMLParserImpl.searchFirstNode(valuenamedinstanceE, "INSTANCE");
        if (instanceE == null) {
            throw new CIMXMLParseException();
        }
        CIMInstance inst = CIMXMLParserImpl.parseINSTANCE(instanceE, op);
        return inst;
    }

    public static CIMElement parseVALUENAMEDOBJECT(Element valuenamedobjectE) throws CIMXMLParseException {
        Element classE = (Element)CIMXMLParserImpl.searchFirstNode(valuenamedobjectE, "CLASS");
        if (classE != null) {
            CIMClass obj = CIMXMLParserImpl.parseCLASS(classE);
            return obj;
        }
        Element instancenameE = (Element)CIMXMLParserImpl.searchFirstNode(valuenamedobjectE, "INSTANCENAME");
        if (instancenameE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseINSTANCENAME(instancenameE);
            Element instanceE = (Element)CIMXMLParserImpl.searchFirstNode(valuenamedobjectE, "INSTANCE");
            if (instanceE == null) {
                throw new CIMXMLParseException();
            }
            CIMInstance inst = CIMXMLParserImpl.parseINSTANCE(instanceE, op);
            return inst;
        }
        throw new CIMXMLParseException();
    }

    public static CIMElement parseVALUEOBJECTWITHPATH(Element valueobjectwithpathE) throws CIMXMLParseException {
        Element classpathE = (Element)CIMXMLParserImpl.searchFirstNode(valueobjectwithpathE, "CLASSPATH");
        if (classpathE != null) {
            Element classE = (Element)CIMXMLParserImpl.searchFirstNode(valueobjectwithpathE, "CLASS");
            if (classE == null) {
                throw new CIMXMLParseException();
            }
            CIMClass obj = CIMXMLParserImpl.parseCLASS(classE);
            return obj;
        }
        Element instancepathE = (Element)CIMXMLParserImpl.searchFirstNode(valueobjectwithpathE, "INSTANCEPATH");
        if (instancepathE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseINSTANCEPATH(instancepathE);
            Element instanceE = (Element)CIMXMLParserImpl.searchFirstNode(valueobjectwithpathE, "INSTANCE");
            if (instanceE == null) {
                throw new CIMXMLParseException();
            }
            CIMInstance inst = CIMXMLParserImpl.parseINSTANCE(instanceE, op);
            return inst;
        }
        throw new CIMXMLParseException();
    }

    public static CIMElement parseVALUEOBJECTWITHLOCALPATH(Element valueobjectwithlocalpathE) throws CIMXMLParseException {
        Element localclasspathE = (Element)CIMXMLParserImpl.searchFirstNode(valueobjectwithlocalpathE, "LOCALCLASSPATH");
        if (localclasspathE != null) {
            Element classE = (Element)CIMXMLParserImpl.searchFirstNode(valueobjectwithlocalpathE, "CLASS");
            if (classE == null) {
                throw new CIMXMLParseException();
            }
            CIMClass obj = CIMXMLParserImpl.parseCLASS(classE);
            return obj;
        }
        Element localinstancepathE = (Element)CIMXMLParserImpl.searchFirstNode(valueobjectwithlocalpathE, "LOCALINSTANCEPATH");
        if (localinstancepathE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseLOCALINSTANCEPATH(localinstancepathE);
            Element instanceE = (Element)CIMXMLParserImpl.searchFirstNode(valueobjectwithlocalpathE, "INSTANCE");
            if (instanceE == null) {
                throw new CIMXMLParseException();
            }
            CIMInstance inst = CIMXMLParserImpl.parseINSTANCE(instanceE, op);
            return inst;
        }
        throw new CIMXMLParseException();
    }

    public static CIMNameSpace parseNAMESPACEPATH(Element namespacepathE) throws CIMXMLParseException {
        Element hostE = (Element)CIMXMLParserImpl.searchFirstNode(namespacepathE, "HOST");
        if (hostE == null) {
            throw new CIMXMLParseException();
        }
        String host = CIMXMLParserImpl.parseHOST(hostE);
        Element localnamespacepathE = (Element)CIMXMLParserImpl.searchFirstNode(namespacepathE, "LOCALNAMESPACEPATH");
        if (localnamespacepathE == null) {
            throw new CIMXMLParseException();
        }
        CIMNameSpace ns = CIMXMLParserImpl.parseLOCALNAMESPACEPATH(localnamespacepathE);
        ns.setHost(host);
        return ns;
    }

    public static CIMNameSpace parseLOCALNAMESPACEPATH(Element localnamespaceE) throws CIMXMLParseException {
        Vector namespaceV = CIMXMLParserImpl.searchNodes(localnamespaceE, "NAMESPACE");
        if (namespaceV == null) {
            throw new CIMXMLParseException();
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < namespaceV.size(); ++i) {
            Element namespaceE = (Element)namespaceV.elementAt(i);
            String s = CIMXMLParserImpl.parseNAMESPACE(namespaceE);
            if (i > 0) {
                sb.append("/" + s);
                continue;
            }
            sb.append(s);
        }
        CIMNameSpace ns = null;
        ns = new CIMNameSpace();
        ns.setNameSpace(sb.toString());
        return ns;
    }

    public static String parseHOST(Element hostE) throws CIMXMLParseException {
        Text valueT = (Text)CIMXMLParserImpl.searchFirstChild(hostE);
        String host = valueT.getNodeValue();
        return host;
    }

    public static String parseNAMESPACE(Element namespaceE) throws CIMXMLParseException {
        Attr namespace_nameA = (Attr)CIMXMLParserImpl.searchAttribute(namespaceE, "NAME");
        String n = namespace_nameA.getValue();
        return n;
    }

    public static CIMObjectPath parseCLASSPATH(Element classpathE) throws CIMXMLParseException {
        Element namespacepathE = (Element)CIMXMLParserImpl.searchFirstNode(classpathE, "NAMESPACEPATH");
        if (namespacepathE == null) {
            throw new CIMXMLParseException();
        }
        CIMNameSpace ns = CIMXMLParserImpl.parseNAMESPACEPATH(namespacepathE);
        Element classnameE = (Element)CIMXMLParserImpl.searchFirstNode(classpathE, "CLASSNAME");
        if (classnameE == null) {
            throw new CIMXMLParseException();
        }
        CIMObjectPath op = CIMXMLParserImpl.parseCLASSNAME(classnameE);
        op.setHost(ns.getHost());
        op.setNameSpace(ns.getNameSpace());
        return op;
    }

    public static CIMObjectPath parseLOCALCLASSPATH(Element classpathE) throws CIMXMLParseException {
        Element localnamespacepathE = (Element)CIMXMLParserImpl.searchFirstNode(classpathE, "LOCALNAMESPACEPATH");
        if (localnamespacepathE == null) {
            throw new CIMXMLParseException();
        }
        CIMNameSpace ns = CIMXMLParserImpl.parseLOCALNAMESPACEPATH(localnamespacepathE);
        Element classnameE = (Element)CIMXMLParserImpl.searchFirstNode(classpathE, "CLASSNAME");
        if (classnameE == null) {
            throw new CIMXMLParseException();
        }
        CIMObjectPath op = CIMXMLParserImpl.parseCLASSNAME(classnameE);
        op.setHost(ns.getHost());
        op.setNameSpace(ns.getNameSpace());
        return op;
    }

    public static CIMObjectPath parseCLASSNAME(Element classnameE) throws CIMXMLParseException {
        Attr classname_nameA = (Attr)CIMXMLParserImpl.searchAttribute(classnameE, "NAME");
        String opClassName = classname_nameA.getNodeValue();
        CIMObjectPath op = new CIMObjectPath();
        op.setObjectName(opClassName);
        return op;
    }

    public static CIMObjectPath parseINSTANCEPATH(Element instancepathE) throws CIMXMLParseException {
        Element namespacepathE = (Element)CIMXMLParserImpl.searchFirstNode(instancepathE, "NAMESPACEPATH");
        if (namespacepathE == null) {
            throw new CIMXMLParseException();
        }
        CIMNameSpace ns = CIMXMLParserImpl.parseNAMESPACEPATH(namespacepathE);
        Element instancenameE = (Element)CIMXMLParserImpl.searchFirstNode(instancepathE, "INSTANCENAME");
        if (instancenameE == null) {
            throw new CIMXMLParseException();
        }
        CIMObjectPath op = CIMXMLParserImpl.parseINSTANCENAME(instancenameE);
        op.setHost(ns.getHost());
        op.setNameSpace(ns.getNameSpace());
        return op;
    }

    public static CIMObjectPath parseLOCALINSTANCEPATH(Element localinstancepathE) throws CIMXMLParseException {
        Element localnamespacepathE = (Element)CIMXMLParserImpl.searchFirstNode(localinstancepathE, "LOCALNAMESPACEPATH");
        if (localnamespacepathE == null) {
            throw new CIMXMLParseException();
        }
        CIMNameSpace ns = CIMXMLParserImpl.parseLOCALNAMESPACEPATH(localnamespacepathE);
        Element instancenameE = (Element)CIMXMLParserImpl.searchFirstNode(localinstancepathE, "INSTANCENAME");
        if (instancenameE == null) {
            throw new CIMXMLParseException();
        }
        CIMObjectPath op = CIMXMLParserImpl.parseINSTANCENAME(instancenameE);
        op.setHost(ns.getHost());
        op.setNameSpace(ns.getNameSpace());
        return op;
    }

    public static CIMObjectPath parseINSTANCENAME(Element instancenameE) throws CIMXMLParseException {
        Attr instance_classnameA = (Attr)CIMXMLParserImpl.searchAttribute(instancenameE, "CLASSNAME");
        String opClassName = instance_classnameA.getNodeValue();
        CIMObjectPath op = new CIMObjectPath();
        op.setObjectName(opClassName);
        Vector keybindingV = CIMXMLParserImpl.searchNodes(instancenameE, "KEYBINDING");
        if (keybindingV != null) {
            for (int i = 0; i < keybindingV.size(); ++i) {
                Element keybindingE = (Element)keybindingV.elementAt(i);
                CIMProperty p = CIMXMLParserImpl.parseKEYBINDING(keybindingE);
                op.addKey(p.getName(), p.getValue());
            }
            return op;
        }
        return op;
    }

    public static CIMObjectPath parseOBJECTPATH(Element objectpathE) throws CIMXMLParseException {
        Element instancepathE = (Element)CIMXMLParserImpl.searchFirstNode(objectpathE, "INSTANCEPATH");
        if (instancepathE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseINSTANCEPATH(instancepathE);
            return op;
        }
        Element classpathE = (Element)CIMXMLParserImpl.searchFirstNode(objectpathE, "CLASSPATH");
        if (classpathE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseCLASSPATH(classpathE);
            return op;
        }
        throw new CIMXMLParseException();
    }

    public static CIMProperty parseKEYBINDING(Element keybindingE) throws CIMXMLParseException {
        Attr keybinding_nameA = (Attr)CIMXMLParserImpl.searchAttribute(keybindingE, "NAME");
        String pName = keybinding_nameA.getValue();
        CIMProperty p = new CIMProperty(pName);
        Element keyvalueE = (Element)CIMXMLParserImpl.searchFirstNode(keybindingE, "KEYVALUE");
        if (keyvalueE != null) {
            CIMValue pValue = CIMXMLParserImpl.parseKEYVALUE(keyvalueE);
            p.setValue(pValue);
            return p;
        }
        Element valuereferenceE = (Element)CIMXMLParserImpl.searchFirstNode(keybindingE, "VALUE.REFERENCE");
        if (valuereferenceE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseVALUEREFERENCE(valuereferenceE);
            p.setValue(new CIMValue(op, new CIMDataType(op.getObjectName())));
            return p;
        }
        throw new CIMXMLParseException();
    }

    public static CIMValue parseKEYVALUE(Element keyvalueE) throws CIMXMLParseException {
        Attr keyvalue_valuetypeA = (Attr)CIMXMLParserImpl.searchAttribute(keyvalueE, "VALUETYPE");
        String objectType = "string";
        if (keyvalue_valuetypeA != null) {
            objectType = keyvalue_valuetypeA.getValue();
        }
        Text valueT = (Text)CIMXMLParserImpl.searchFirstChild(keyvalueE);
        Object value = null;
        if (valueT != null) {
            String objectValue = valueT.getNodeValue();
            value = CIMXMLParserImpl.createJavaObject(objectType, objectValue);
        }
        return new CIMValue(value, CIMDataType.getDataType(objectType, false));
    }

    public static CIMClass parseCLASS(Element classE) throws CIMXMLParseException {
        Vector propertyreferenceV;
        Vector propertyarrayV;
        Vector<CIMElement> v;
        Vector qualifierV;
        CIMClass c = new CIMClass();
        Attr class_nameA = (Attr)CIMXMLParserImpl.searchAttribute(classE, "NAME");
        String name = class_nameA.getNodeValue();
        c.setName(name);
        String supername = classE.getAttribute("SUPERCLASS");
        if (supername != null && supername.length() > 0) {
            c.setSuperClass(supername);
        }
        if ((qualifierV = CIMXMLParserImpl.searchNodes(classE, "QUALIFIER")) != null) {
            v = new Vector<CIMElement>();
            for (int i = 0; i < qualifierV.size(); ++i) {
                Element qualifierE = (Element)qualifierV.elementAt(i);
                CIMQualifier q = CIMXMLParserImpl.parseQUALIFIER(qualifierE);
                v.add(q);
            }
            c.setQualifiers(v);
        }
        v = new Vector();
        Vector propertyV = CIMXMLParserImpl.searchNodes(classE, "PROPERTY");
        if (propertyV != null) {
            for (int i = 0; i < propertyV.size(); ++i) {
                Element propertyE = (Element)propertyV.elementAt(i);
                CIMProperty p = CIMXMLParserImpl.parsePROPERTY(propertyE);
                v.add(p);
            }
        }
        if ((propertyarrayV = CIMXMLParserImpl.searchNodes(classE, "PROPERTY.ARRAY")) != null) {
            for (int i = 0; i < propertyarrayV.size(); ++i) {
                Element propertyarrayE = (Element)propertyarrayV.elementAt(i);
                CIMProperty p = CIMXMLParserImpl.parsePROPERTYARRAY(propertyarrayE);
                v.add(p);
            }
        }
        if ((propertyreferenceV = CIMXMLParserImpl.searchNodes(classE, "PROPERTY.REFERENCE")) != null) {
            for (int i = 0; i < propertyreferenceV.size(); ++i) {
                Element propertyreferenceE = (Element)propertyreferenceV.elementAt(i);
                CIMProperty p = CIMXMLParserImpl.parsePROPERTYREFERENCE(propertyreferenceE);
                v.add(p);
            }
        }
        c.setProperties(v);
        Vector methodV = CIMXMLParserImpl.searchNodes(classE, "METHOD");
        if (methodV != null) {
            Vector<CIMMethod> methods = new Vector<CIMMethod>();
            for (int i = 0; i < methodV.size(); ++i) {
                Element methodE = (Element)methodV.elementAt(i);
                CIMMethod p = CIMXMLParserImpl.parseMETHOD(methodE);
                methods.add(p);
            }
            c.setMethods(methods);
        }
        return c;
    }

    public static CIMMethod parseMETHOD(Element methodE) throws CIMXMLParseException {
        Vector parameterrefarrayV;
        Vector parameterarrayV;
        Vector parameterreferenceV;
        Vector<CIMElement> v;
        Vector qualifierV;
        String propagated;
        CIMMethod method = new CIMMethod();
        String name = methodE.getAttribute("NAME");
        method.setName(name);
        String typeStr = methodE.getAttribute("TYPE");
        CIMDataType type = CIMDataType.getDataType(typeStr, false);
        method.setType(type);
        String classorigin = methodE.getAttribute("CLASSORIGIN");
        if (classorigin != null && classorigin.length() > 0) {
            method.setOriginClass(classorigin);
        }
        if ("true".equalsIgnoreCase(propagated = methodE.getAttribute("PROPAGATED"))) {
            method.setPropagated(true);
        }
        if ((qualifierV = CIMXMLParserImpl.searchNodes(methodE, "QUALIFIER")) != null) {
            v = new Vector<CIMElement>();
            for (int i = 0; i < qualifierV.size(); ++i) {
                Element qualifierE = (Element)qualifierV.elementAt(i);
                CIMQualifier q = CIMXMLParserImpl.parseQUALIFIER(qualifierE);
                v.add(q);
            }
            method.setQualifiers(v);
        }
        v = new Vector();
        Vector parameterV = CIMXMLParserImpl.searchNodes(methodE, "PARAMETER");
        if (parameterV != null) {
            for (int i = 0; i < parameterV.size(); ++i) {
                Element parameterE = (Element)parameterV.elementAt(i);
                CIMParameter p = CIMXMLParserImpl.parsePARAMETER(parameterE);
                v.add(p);
            }
        }
        if ((parameterreferenceV = CIMXMLParserImpl.searchNodes(methodE, "PARAMETER.REFERENCE")) != null) {
            for (int i = 0; i < parameterreferenceV.size(); ++i) {
                Element parameterE = (Element)parameterreferenceV.elementAt(i);
                CIMParameter p = CIMXMLParserImpl.parsePARAMETERREFERENCE(parameterE);
                v.add(p);
            }
        }
        if ((parameterarrayV = CIMXMLParserImpl.searchNodes(methodE, "PARAMETER.ARRAY")) != null) {
            for (int i = 0; i < parameterarrayV.size(); ++i) {
                Element parameterE = (Element)parameterarrayV.elementAt(i);
                CIMParameter p = CIMXMLParserImpl.parsePARAMETERARRAY(parameterE);
                v.add(p);
            }
        }
        if ((parameterrefarrayV = CIMXMLParserImpl.searchNodes(methodE, "PARAMETER.REFARRAY")) != null) {
            for (int i = 0; i < parameterrefarrayV.size(); ++i) {
                Element parameterE = (Element)parameterrefarrayV.elementAt(i);
                CIMParameter p = CIMXMLParserImpl.parsePARAMETERREFARRAY(parameterE);
                v.add(p);
            }
        }
        method.setParameters(v);
        return method;
    }

    public static CIMParameter parsePARAMETER(Element parameterE) throws CIMXMLParseException {
        CIMParameter parameter = new CIMParameter();
        String name = parameterE.getAttribute("NAME");
        parameter.setName(name);
        String typeStr = parameterE.getAttribute("TYPE");
        CIMDataType type = CIMDataType.getDataType(typeStr, false);
        parameter.setType(type);
        Vector qualifierV = CIMXMLParserImpl.searchNodes(parameterE, "QUALIFIER");
        if (qualifierV != null) {
            Vector<CIMQualifier> v = new Vector<CIMQualifier>();
            for (int i = 0; i < qualifierV.size(); ++i) {
                Element qualifierE = (Element)qualifierV.elementAt(i);
                CIMQualifier q = CIMXMLParserImpl.parseQUALIFIER(qualifierE);
                v.add(q);
            }
            parameter.setQualifiers(v);
        }
        return parameter;
    }

    public static CIMParameter parsePARAMETERREFERENCE(Element parameterE) throws CIMXMLParseException {
        CIMParameter parameter = new CIMParameter();
        String name = parameterE.getAttribute("NAME");
        parameter.setName(name);
        String referenceClass = parameterE.getAttribute("REFERENCECLASS");
        parameter.setType(new CIMDataType(referenceClass != null ? referenceClass : ""));
        Vector qualifierV = CIMXMLParserImpl.searchNodes(parameterE, "QUALIFIER");
        if (qualifierV != null) {
            Vector<CIMQualifier> v = new Vector<CIMQualifier>();
            for (int i = 0; i < qualifierV.size(); ++i) {
                Element qualifierE = (Element)qualifierV.elementAt(i);
                CIMQualifier q = CIMXMLParserImpl.parseQUALIFIER(qualifierE);
                v.add(q);
            }
            parameter.setQualifiers(v);
        }
        return parameter;
    }

    public static CIMParameter parsePARAMETERARRAY(Element parameterE) throws CIMXMLParseException {
        int arraySize;
        String typeStr;
        CIMParameter parameter;
        block6: {
            parameter = new CIMParameter();
            String name = parameterE.getAttribute("NAME");
            parameter.setName(name);
            typeStr = parameterE.getAttribute("TYPE");
            arraySize = -2;
            String arraySizeStr = parameterE.getAttribute("ARRAYSIZE");
            try {
                if (arraySizeStr.length() > 0) {
                    arraySize = Integer.parseInt(arraySizeStr);
                }
            }
            catch (Exception e) {
                Logger logger = SessionProperties.getGlobalProperties().getLogger();
                if (!logger.isLoggable(Level.WARNING)) break block6;
                logger.log(Level.WARNING, "exception while reading parameter array size from the XML", e);
            }
        }
        CIMDataType type = CIMDataType.getDataType(typeStr, true);
        if (arraySize > -1) {
            type = new CIMDataType(type.getType(), arraySize);
        }
        parameter.setType(type);
        Vector qualifierV = CIMXMLParserImpl.searchNodes(parameterE, "QUALIFIER");
        if (qualifierV != null) {
            Vector<CIMQualifier> v = new Vector<CIMQualifier>();
            for (int i = 0; i < qualifierV.size(); ++i) {
                Element qualifierE = (Element)qualifierV.elementAt(i);
                CIMQualifier q = CIMXMLParserImpl.parseQUALIFIER(qualifierE);
                v.add(q);
            }
            parameter.setQualifiers(v);
        }
        return parameter;
    }

    public static CIMParameter parsePARAMETERREFARRAY(Element parameterE) throws CIMXMLParseException {
        int arraySize;
        String referenceClass;
        CIMParameter parameter;
        block5: {
            parameter = new CIMParameter();
            String name = parameterE.getAttribute("NAME");
            parameter.setName(name);
            referenceClass = parameterE.getAttribute("REFERENCECLASS");
            arraySize = -2;
            String arraySizeStr = parameterE.getAttribute("ARRAYSIZE");
            try {
                if (arraySizeStr.length() > 0) {
                    arraySize = Integer.parseInt(arraySizeStr);
                }
            }
            catch (Exception e) {
                Logger logger = SessionProperties.getGlobalProperties().getLogger();
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.log(Level.WARNING, "exeception while parsing parameter array reference size", e);
            }
        }
        CIMDataType type = new CIMDataType(referenceClass != null ? referenceClass : "", arraySize);
        parameter.setType(type);
        Vector qualifierV = CIMXMLParserImpl.searchNodes(parameterE, "QUALIFIER");
        if (qualifierV != null) {
            Vector<CIMQualifier> v = new Vector<CIMQualifier>();
            for (int i = 0; i < qualifierV.size(); ++i) {
                Element qualifierE = (Element)qualifierV.elementAt(i);
                CIMQualifier q = CIMXMLParserImpl.parseQUALIFIER(qualifierE);
                v.add(q);
            }
            parameter.setQualifiers(v);
        }
        return parameter;
    }

    public static CIMInstance parseINSTANCE(Element instanceE) throws CIMXMLParseException {
        return CIMXMLParserImpl.parseINSTANCE(instanceE, null);
    }

    public static CIMInstance parseINSTANCE(Element instanceE, CIMObjectPath op) throws CIMXMLParseException {
        Vector propertyreferenceV;
        Vector propertyarrayV;
        Vector<CIMElement> v;
        Vector qualifierV;
        CIMInstance inst = new CIMInstance(op);
        String className = instanceE.getAttribute("CLASSNAME");
        if (className != null && className.length() > 0) {
            inst.setName(className);
        }
        if ((qualifierV = CIMXMLParserImpl.searchNodes(instanceE, "QUALIFIER")) != null) {
            v = new Vector<CIMElement>();
            for (int i = 0; i < qualifierV.size(); ++i) {
                Element qualifierE = (Element)qualifierV.elementAt(i);
                CIMQualifier q = CIMXMLParserImpl.parseQUALIFIER(qualifierE);
                v.add(q);
            }
            inst.setQualifiers(v);
        }
        v = new Vector();
        Vector propertyV = CIMXMLParserImpl.searchNodes(instanceE, "PROPERTY");
        if (propertyV != null) {
            for (int i = 0; i < propertyV.size(); ++i) {
                Element propertyE = (Element)propertyV.elementAt(i);
                CIMProperty p = CIMXMLParserImpl.parsePROPERTY(propertyE);
                v.add(p);
            }
        }
        if ((propertyarrayV = CIMXMLParserImpl.searchNodes(instanceE, "PROPERTY.ARRAY")) != null) {
            for (int i = 0; i < propertyarrayV.size(); ++i) {
                Element propertyarrayE = (Element)propertyarrayV.elementAt(i);
                CIMProperty p = CIMXMLParserImpl.parsePROPERTYARRAY(propertyarrayE);
                v.add(p);
            }
        }
        if ((propertyreferenceV = CIMXMLParserImpl.searchNodes(instanceE, "PROPERTY.REFERENCE")) != null) {
            for (int i = 0; i < propertyreferenceV.size(); ++i) {
                Element propertyreferenceE = (Element)propertyreferenceV.elementAt(i);
                CIMProperty p = CIMXMLParserImpl.parsePROPERTYREFERENCE(propertyreferenceE);
                v.add(p);
            }
        }
        inst.setProperties(v);
        return inst;
    }

    public static CIMQualifier parseQUALIFIER(Element qualifierE) throws CIMXMLParseException {
        Element valuearrayE;
        Element valueE;
        String valueOverridableStr;
        CIMQualifier q = new CIMQualifier();
        String name = qualifierE.getAttribute("NAME");
        q.setName(name);
        String valueTypeStr = qualifierE.getAttribute("TYPE");
        String valuePropagatedStr = qualifierE.getAttribute("PROPAGATED");
        if (valuePropagatedStr != null && valuePropagatedStr.equalsIgnoreCase("true")) {
            q.setPropagated(true);
        }
        if ((valueOverridableStr = qualifierE.getAttribute("OVERRIDABLE")) != null && valueOverridableStr.equalsIgnoreCase("true")) {
            q.addFlavor(new CIMFlavor(0));
        } else {
            q.addFlavor(new CIMFlavor(1));
        }
        String valueToSubClassStr = qualifierE.getAttribute("TOSUBCLASS");
        if (valueToSubClassStr != null && valueToSubClassStr.equalsIgnoreCase("true")) {
            q.addFlavor(new CIMFlavor(3));
        } else {
            q.addFlavor(new CIMFlavor(2));
        }
        String valueTranslatableStr = qualifierE.getAttribute("TRANSLATABLE");
        if (valueTranslatableStr != null && valueTranslatableStr.equalsIgnoreCase("true")) {
            q.addFlavor(new CIMFlavor(4));
        }
        if ((valueE = (Element)CIMXMLParserImpl.searchFirstNode(qualifierE, "VALUE")) != null) {
            String valueStr = CIMXMLParserImpl.parseVALUE(valueE);
            Object o = CIMXMLParserImpl.createJavaObject(valueTypeStr, valueStr);
            CIMValue value = new CIMValue(o, CIMDataType.getDataType(valueTypeStr, false));
            q.setValue(value);
        }
        if ((valuearrayE = (Element)CIMXMLParserImpl.searchFirstNode(qualifierE, "VALUE.ARRAY")) != null) {
            Vector v = CIMXMLParserImpl.parseVALUEARRAY(valuearrayE);
            Vector<Object> v2 = new Vector<Object>();
            for (int i = 0; i < v.size(); ++i) {
                String valueStr = (String)v.elementAt(i);
                Object o = CIMXMLParserImpl.createJavaObject(valueTypeStr, valueStr);
                v2.add(o);
            }
            CIMValue value = new CIMValue(v2, CIMDataType.getDataType(valueTypeStr, true));
            q.setValue(value);
        }
        return q;
    }

    public static CIMQualifierType parseQUALIFIERDECLARATION(Element qualifiertypeE) throws CIMXMLParseException {
        Element valuearrayE;
        Element valueE;
        String valueOverridableStr;
        int arraySize;
        boolean isArray;
        String valueTypeStr;
        CIMQualifierType qualifiertype;
        block19: {
            qualifiertype = new CIMQualifierType();
            String name = qualifiertypeE.getAttribute("NAME");
            qualifiertype.setName(name);
            valueTypeStr = qualifiertypeE.getAttribute("TYPE");
            if (valueTypeStr == null || valueTypeStr.length() == 0) {
                throw new CIMXMLParseException();
            }
            String isarrayStr = qualifiertypeE.getAttribute("ISARRAY");
            isArray = isarrayStr != null && isarrayStr.equalsIgnoreCase("true");
            arraySize = -2;
            String arraySizeStr = qualifiertypeE.getAttribute("ARRAYSIZE");
            try {
                if (arraySizeStr != null && arraySizeStr.length() > 0) {
                    isArray = true;
                    arraySize = Integer.parseInt(arraySizeStr);
                }
            }
            catch (Exception e) {
                Logger logger = SessionProperties.getGlobalProperties().getLogger();
                if (!logger.isLoggable(Level.WARNING)) break block19;
                logger.log(Level.WARNING, "exception while parsing array size", e);
            }
        }
        CIMDataType valueType = CIMDataType.getDataType(valueTypeStr, isArray);
        if (isArray) {
            valueType = new CIMDataType(valueType.getType(), arraySize);
        }
        qualifiertype.setType(valueType);
        Vector scopeV = CIMXMLParserImpl.searchNodes(qualifiertypeE, "SCOPE");
        if (scopeV != null) {
            for (int i = 0; i < scopeV.size(); ++i) {
                Element scopeE = (Element)scopeV.elementAt(i);
                Vector scopeList = CIMXMLParserImpl.parseSCOPE(scopeE);
                Iterator iter = scopeList.iterator();
                while (iter.hasNext()) {
                    CIMScope scope = (CIMScope)iter.next();
                    qualifiertype.addScope(scope);
                }
            }
        }
        if ((valueOverridableStr = qualifiertypeE.getAttribute("OVERRIDABLE")) != null && valueOverridableStr.equalsIgnoreCase("true")) {
            qualifiertype.addFlavor(new CIMFlavor(0));
        } else {
            qualifiertype.addFlavor(new CIMFlavor(1));
        }
        String valueToSubClassStr = qualifiertypeE.getAttribute("TOSUBCLASS");
        if (valueToSubClassStr != null && valueToSubClassStr.equalsIgnoreCase("true")) {
            qualifiertype.addFlavor(new CIMFlavor(3));
        } else {
            qualifiertype.addFlavor(new CIMFlavor(2));
        }
        String valueTranslatableStr = qualifiertypeE.getAttribute("TRANSLATABLE");
        if (valueTranslatableStr != null && valueTranslatableStr.equalsIgnoreCase("true")) {
            qualifiertype.addFlavor(new CIMFlavor(4));
        }
        if ((valueE = (Element)CIMXMLParserImpl.searchFirstNode(qualifiertypeE, "VALUE")) != null) {
            CIMValue value;
            String valueStr = CIMXMLParserImpl.parseVALUE(valueE);
            if (!valueStr.equals("NULL")) {
                Object o = CIMXMLParserImpl.createJavaObject(valueTypeStr, valueStr);
                value = new CIMValue(o, valueType);
            } else {
                value = new CIMValue(null, valueType);
            }
            qualifiertype.setDefaultValue(value);
        }
        if ((valuearrayE = (Element)CIMXMLParserImpl.searchFirstNode(qualifiertypeE, "VALUE.ARRAY")) != null) {
            Vector v = CIMXMLParserImpl.parseVALUEARRAY(valuearrayE);
            Vector<Object> v2 = new Vector<Object>();
            for (int i = 0; i < v.size(); ++i) {
                String valueStr = (String)v.elementAt(i);
                Object o = null;
                if (!valueStr.equals("NULL")) {
                    o = CIMXMLParserImpl.createJavaObject(valueTypeStr, valueStr);
                }
                v2.add(o);
            }
            CIMValue value = new CIMValue(v2, valueType);
            qualifiertype.setDefaultValue(value);
        }
        return qualifiertype;
    }

    public static Vector parseSCOPE(Element scopeE) throws CIMXMLParseException {
        String indication;
        String param;
        String method;
        String prop;
        String ref;
        String assoc;
        Vector<CIMScope> scopeV = new Vector<CIMScope>();
        String clazz = scopeE.getAttribute("CLASS");
        if (clazz != null && clazz.equalsIgnoreCase("true")) {
            scopeV.add(CIMScope.getScope(1));
        }
        if ((assoc = scopeE.getAttribute("ASSOCIATION")) != null && assoc.equalsIgnoreCase("true")) {
            scopeV.add(CIMScope.getScope(2));
        }
        if ((ref = scopeE.getAttribute("REFERENCE")) != null && ref.equalsIgnoreCase("true")) {
            scopeV.add(CIMScope.getScope(5));
        }
        if ((prop = scopeE.getAttribute("PROPERTY")) != null && prop.equalsIgnoreCase("true")) {
            scopeV.add(CIMScope.getScope(4));
        }
        if ((method = scopeE.getAttribute("METHOD")) != null && method.equalsIgnoreCase("true")) {
            scopeV.add(CIMScope.getScope(6));
        }
        if ((param = scopeE.getAttribute("PARAMETER")) != null && param.equalsIgnoreCase("true")) {
            scopeV.add(CIMScope.getScope(7));
        }
        if ((indication = scopeE.getAttribute("INDICATION")) != null && indication.equalsIgnoreCase("true")) {
            scopeV.add(CIMScope.getScope(3));
        }
        return scopeV;
    }

    public static CIMProperty parsePROPERTY(Element propertyE) throws CIMXMLParseException {
        Element valueE;
        Vector qualifierV;
        CIMProperty p = new CIMProperty();
        Attr property_nameA = (Attr)CIMXMLParserImpl.searchAttribute(propertyE, "NAME");
        String name = property_nameA.getNodeValue();
        p.setName(name);
        Attr property_typeA = (Attr)CIMXMLParserImpl.searchAttribute(propertyE, "TYPE");
        String valueTypeStr = property_typeA.getNodeValue();
        p.setType(CIMDataType.getDataType(valueTypeStr, false));
        String classoriginStr = propertyE.getAttribute("CLASSORIGIN");
        if (classoriginStr != null && classoriginStr.length() > 0) {
            p.setOriginClass(classoriginStr);
        }
        String propagatedStr = propertyE.getAttribute("PROPAGATED");
        try {
            p.setPropagated(Boolean.getBoolean(propagatedStr));
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean embedded = false;
        String embeddedobjectStr = propertyE.getAttribute("EMBEDDEDOBJECT");
        if (embeddedobjectStr != null && embeddedobjectStr.equalsIgnoreCase("object")) {
            embedded = true;
        }
        if ((qualifierV = CIMXMLParserImpl.searchNodes(propertyE, "QUALIFIER")) != null) {
            for (int i = 0; i < qualifierV.size(); ++i) {
                Element qualifierE = (Element)qualifierV.elementAt(i);
                CIMQualifier q = CIMXMLParserImpl.parseQUALIFIER(qualifierE);
                if (q.getName().equalsIgnoreCase("EmbeddedObject")) {
                    embedded = true;
                }
                p.addQualifier(q);
            }
        }
        if ((valueE = (Element)CIMXMLParserImpl.searchFirstNode(propertyE, "VALUE")) != null) {
            String valueStr = CIMXMLParserImpl.parseVALUE(valueE);
            CIMValue value = null;
            if (embedded) {
                p.setType(new CIMDataType(31));
                try {
                    CIMClientXML_HelperImpl builder = new CIMClientXML_HelperImpl();
                    Document doc = builder.parse(new InputSource(new StringReader(valueStr)));
                    value = new CIMValue(CIMXMLParserImpl.parseObject(doc.getDocumentElement()), new CIMDataType(31));
                }
                catch (Exception e) {
                    value = new CIMValue(CIMXMLParserImpl.createJavaObject(valueTypeStr, valueStr), CIMDataType.getDataType(valueTypeStr, false));
                    Logger logger = SessionProperties.getGlobalProperties().getLogger();
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "parsePROPERTY exception while parsing embedded object from property", e);
                    }
                }
            } else {
                Object o = CIMXMLParserImpl.createJavaObject(valueTypeStr, valueStr);
                value = new CIMValue(o, CIMDataType.getDataType(valueTypeStr, false));
            }
            p.setValue(value);
            return p;
        }
        return p;
    }

    public static CIMProperty parsePROPERTYARRAY(Element propertyarrayE) throws CIMXMLParseException {
        Element valuearrayE;
        Vector qualifierV;
        String valuePropagatedStr;
        CIMProperty p = new CIMProperty();
        String name = propertyarrayE.getAttribute("NAME");
        p.setName(name);
        String valueTypeStr = propertyarrayE.getAttribute("TYPE");
        CIMDataType propertyType = CIMDataType.getDataType(valueTypeStr, true);
        p.setType(propertyType);
        String valueClassoriginStr = propertyarrayE.getAttribute("CLASSORIGIN");
        if (valueClassoriginStr != null && valueClassoriginStr.length() > 0) {
            p.setOriginClass(valueClassoriginStr);
        }
        if ((valuePropagatedStr = propertyarrayE.getAttribute("PROPAGATED")) != null && valuePropagatedStr.equalsIgnoreCase("true")) {
            p.setPropagated(true);
        }
        if ((qualifierV = CIMXMLParserImpl.searchNodes(propertyarrayE, "QUALIFIER")) != null) {
            for (int i = 0; i < qualifierV.size(); ++i) {
                Element qualifierE = (Element)qualifierV.elementAt(i);
                CIMQualifier q = CIMXMLParserImpl.parseQUALIFIER(qualifierE);
                p.addQualifier(q);
            }
        }
        if ((valuearrayE = (Element)CIMXMLParserImpl.searchFirstNode(propertyarrayE, "VALUE.ARRAY")) != null) {
            Vector v = CIMXMLParserImpl.parseVALUEARRAY(valuearrayE);
            Vector<Object> v2 = new Vector<Object>();
            for (int i = 0; i < v.size(); ++i) {
                String valueStr = (String)v.elementAt(i);
                Object o = CIMXMLParserImpl.createJavaObject(valueTypeStr, valueStr);
                v2.add(o);
            }
            CIMValue value = new CIMValue(v2, propertyType);
            p.setValue(value);
            return p;
        }
        return p;
    }

    public static CIMProperty parsePROPERTYREFERENCE(Element propertyreferenceE) throws CIMXMLParseException {
        Element valuereferenceE;
        Vector qualifierV;
        String valuePropagatedStr;
        String valueReferenceClassStr;
        CIMProperty p = new CIMProperty();
        String name = propertyreferenceE.getAttribute("NAME");
        p.setName(name);
        String valueClassoriginStr = propertyreferenceE.getAttribute("CLASSORIGIN");
        if (valueClassoriginStr != null) {
            p.setOriginClass(valueClassoriginStr);
        }
        if ((valueReferenceClassStr = propertyreferenceE.getAttribute("REFERENCECLASS")) != null) {
            p.setType(new CIMDataType(valueReferenceClassStr));
        }
        if ((valuePropagatedStr = propertyreferenceE.getAttribute("PROPAGATED")) != null && valuePropagatedStr.equalsIgnoreCase("true")) {
            p.setPropagated(true);
        }
        if ((qualifierV = CIMXMLParserImpl.searchNodes(propertyreferenceE, "QUALIFIER")) != null) {
            for (int i = 0; i < qualifierV.size(); ++i) {
                Element qualifierE = (Element)qualifierV.elementAt(i);
                CIMQualifier q = CIMXMLParserImpl.parseQUALIFIER(qualifierE);
                p.addQualifier(q);
            }
        }
        if ((valuereferenceE = (Element)CIMXMLParserImpl.searchFirstNode(propertyreferenceE, "VALUE.REFERENCE")) != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseVALUEREFERENCE(valuereferenceE);
            p.setValue(new CIMValue(op, CIMDataType.getPredefinedType(14)));
            return p;
        }
        return p;
    }

    public static CIMMessage parseMESSAGE(String cimversion, String dtdversion, Element messageE) throws CIMXMLParseException {
        if (cimversion.equals("2.0") && dtdversion.equals("2.0")) {
            Element simplerspE = (Element)CIMXMLParserImpl.searchFirstNode(messageE, "SIMPLERSP");
            if (simplerspE != null) {
                CIMResponse response = CIMXMLParserImpl.parseSIMPLERSP(simplerspE);
                response.setMethod("SIMPLERSP");
                return response;
            }
            Element multirspE = (Element)CIMXMLParserImpl.searchFirstNode(messageE, "MULTIRSP");
            if (multirspE != null) {
                CIMResponse response = CIMXMLParserImpl.parseMULTIRSP(multirspE);
                response.setMethod("MULTIRSP");
                return response;
            }
            Element simpleexpreqE = (Element)CIMXMLParserImpl.searchFirstNode(messageE, "SIMPLEEXPREQ");
            if (simpleexpreqE != null) {
                CIMRequest request = CIMXMLParserImpl.parseSIMPLEEXPREQ(simpleexpreqE);
                request.setMethod("SIMPLEEXPREQ");
                return request;
            }
            Element multiexpreqE = (Element)CIMXMLParserImpl.searchFirstNode(messageE, "MULTIEXPREQ");
            if (multiexpreqE != null) {
                CIMRequest request = CIMXMLParserImpl.parseMULTIEXPREQ(multiexpreqE);
                request.setMethod("MULTIEXPREQ");
                return request;
            }
            Element simplereqE = (Element)CIMXMLParserImpl.searchFirstNode(messageE, "SIMPLEREQ");
            if (simplereqE != null) {
                CIMRequest request = CIMXMLParserImpl.parseSIMPLEREQ(simplereqE);
                request.setMethod("SIMPLEREQ");
                return request;
            }
            Element multireqE = (Element)CIMXMLParserImpl.searchFirstNode(messageE, "MULTIREQ");
            if (multireqE != null) {
                CIMRequest request = CIMXMLParserImpl.parseMULTIREQ(multireqE);
                request.setMethod("MULTIREQ");
                return request;
            }
            throw new CIMXMLParseException();
        }
        throw new CIMXMLParseException("DTD not supported");
    }

    public static CIMArgument parsePARAMVALUE(Element paramvalueE) throws CIMXMLParseException {
        Element valueE;
        Attr paramvalue_nameA = (Attr)CIMXMLParserImpl.searchAttribute(paramvalueE, "NAME");
        String name = null;
        if (paramvalue_nameA != null) {
            name = paramvalue_nameA.getNodeValue();
        }
        Attr paramvalue_paramtypeA = (Attr)CIMXMLParserImpl.searchAttribute(paramvalueE, "PARAMTYPE");
        String valueTypeStr = null;
        if (paramvalue_paramtypeA != null) {
            valueTypeStr = paramvalue_paramtypeA.getNodeValue();
        }
        if ((valueE = (Element)CIMXMLParserImpl.searchFirstNode(paramvalueE, "VALUE")) != null) {
            Attr value_typeA;
            String valueStr = CIMXMLParserImpl.parseVALUE(valueE);
            if (valueTypeStr == null && (value_typeA = (Attr)CIMXMLParserImpl.searchAttribute(valueE, "TYPE")) != null) {
                valueTypeStr = value_typeA.getNodeValue();
            }
            Object o = CIMXMLParserImpl.createJavaObject(valueTypeStr, valueStr);
            CIMArgument arg = new CIMArgument(name);
            arg.setValue(new CIMValue(o, CIMDataType.getDataType(valueTypeStr, false)));
            return arg;
        }
        Element valuearrayE = (Element)CIMXMLParserImpl.searchFirstNode(paramvalueE, "VALUE.ARRAY");
        if (valuearrayE != null) {
            Vector v = CIMXMLParserImpl.parseVALUEARRAY(valuearrayE);
            Vector<Object> v2 = new Vector<Object>();
            for (int i = 0; i < v.size(); ++i) {
                String valueStr = (String)v.elementAt(i);
                Object o = CIMXMLParserImpl.createJavaObject(valueTypeStr, valueStr);
                v2.add(o);
            }
            CIMArgument arg = new CIMArgument(name);
            arg.setValue(new CIMValue(v2, CIMDataType.getDataType(valueTypeStr, true)));
            return arg;
        }
        Element valuereferenceE = (Element)CIMXMLParserImpl.searchFirstNode(paramvalueE, "VALUE.REFERENCE");
        if (valuereferenceE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseVALUEREFERENCE(valuereferenceE);
            CIMArgument arg = new CIMArgument(name);
            arg.setValue(new CIMValue(op, CIMDataType.getPredefinedType(14)));
            return arg;
        }
        return null;
    }

    public static CIMArgument parseIPARAMVALUE(Element iparamvalueE) throws CIMXMLParseException {
        Element valueE;
        Attr paramvalue_nameA = (Attr)CIMXMLParserImpl.searchAttribute(iparamvalueE, "NAME");
        String name = null;
        if (paramvalue_nameA != null) {
            name = paramvalue_nameA.getNodeValue();
        }
        Attr paramvalue_paramtypeA = (Attr)CIMXMLParserImpl.searchAttribute(iparamvalueE, "PARAMTYPE");
        String valueTypeStr = null;
        if (paramvalue_paramtypeA != null) {
            valueTypeStr = paramvalue_paramtypeA.getNodeValue();
        }
        if ((valueE = (Element)CIMXMLParserImpl.searchFirstNode(iparamvalueE, "VALUE")) != null) {
            Attr value_typeA;
            String valueStr = CIMXMLParserImpl.parseVALUE(valueE);
            if (valueTypeStr == null && (value_typeA = (Attr)CIMXMLParserImpl.searchAttribute(valueE, "TYPE")) != null) {
                valueTypeStr = value_typeA.getNodeValue();
            }
            Object o = CIMXMLParserImpl.createJavaObject(valueTypeStr, valueStr);
            CIMArgument arg = new CIMArgument(name);
            arg.setValue(new CIMValue(o, CIMDataType.getDataType(valueTypeStr, false)));
            return arg;
        }
        Element valuearrayE = (Element)CIMXMLParserImpl.searchFirstNode(iparamvalueE, "VALUE.ARRAY");
        if (valuearrayE != null) {
            Vector v = CIMXMLParserImpl.parseVALUEARRAY(valuearrayE);
            Vector<Object> v2 = new Vector<Object>();
            for (int i = 0; i < v.size(); ++i) {
                String valueStr = (String)v.elementAt(i);
                Object o = CIMXMLParserImpl.createJavaObject(valueTypeStr, valueStr);
                v2.add(o);
            }
            CIMArgument arg = new CIMArgument(name);
            arg.setValue(new CIMValue(v2, CIMDataType.getDataType(valueTypeStr, true)));
            return arg;
        }
        Element valuereferenceE = (Element)CIMXMLParserImpl.searchFirstNode(iparamvalueE, "VALUE.REFERENCE");
        if (valuereferenceE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseVALUEREFERENCE(valuereferenceE);
            CIMArgument arg = new CIMArgument(name);
            arg.setValue(new CIMValue(op, CIMDataType.getPredefinedType(14)));
            return arg;
        }
        Element classnameE = (Element)CIMXMLParserImpl.searchFirstNode(iparamvalueE, "CLASSNAME");
        if (classnameE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseCLASSNAME(classnameE);
            CIMArgument arg = new CIMArgument(name);
            arg.setValue(new CIMValue(op, CIMDataType.getPredefinedType(14)));
            return arg;
        }
        Element instancenameE = (Element)CIMXMLParserImpl.searchFirstNode(iparamvalueE, "INSTANCENAME");
        if (instancenameE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseINSTANCENAME(instancenameE);
            CIMArgument arg = new CIMArgument(name);
            arg.setValue(new CIMValue(op, CIMDataType.getPredefinedType(14)));
            return arg;
        }
        Element qualifierdeclarationE = (Element)CIMXMLParserImpl.searchFirstNode(iparamvalueE, "QUALIFIER.DECLARATION");
        if (qualifierdeclarationE != null) {
            CIMQualifierType o = CIMXMLParserImpl.parseQUALIFIERDECLARATION(qualifierdeclarationE);
            CIMArgument arg = new CIMArgument(name);
            arg.setValue(new CIMValue(o, CIMDataType.getPredefinedType(14)));
            return arg;
        }
        Element classE = (Element)CIMXMLParserImpl.searchFirstNode(iparamvalueE, "CLASS");
        if (classE != null) {
            CIMClass op = CIMXMLParserImpl.parseCLASS(classE);
            CIMArgument arg = new CIMArgument(name);
            arg.setValue(new CIMValue(op, CIMDataType.getPredefinedType(14)));
            return arg;
        }
        Element instanceE = (Element)CIMXMLParserImpl.searchFirstNode(iparamvalueE, "INSTANCE");
        if (instanceE != null) {
            CIMInstance op = CIMXMLParserImpl.parseINSTANCE(instanceE);
            CIMArgument arg = new CIMArgument(name);
            arg.setValue(new CIMValue(op, CIMDataType.getPredefinedType(14)));
            return arg;
        }
        Element valuenamedisntanceE = (Element)CIMXMLParserImpl.searchFirstNode(iparamvalueE, "VALUE.NAMEDINSTANCE");
        if (valuenamedisntanceE != null) {
            CIMElement o = CIMXMLParserImpl.parseVALUENAMEDINSTANCE(valuenamedisntanceE);
            CIMArgument arg = new CIMArgument(name);
            arg.setValue(new CIMValue(o, CIMDataType.getPredefinedType(14)));
            return arg;
        }
        return null;
    }

    public static CIMResponse parseSIMPLERSP(Element simplerspE) throws CIMXMLParseException {
        Element methodresponseE = (Element)CIMXMLParserImpl.searchFirstNode(simplerspE, "METHODRESPONSE");
        if (methodresponseE != null) {
            return CIMXMLParserImpl.parseMETHODRESPONSE(methodresponseE);
        }
        Element imethodresponseE = (Element)CIMXMLParserImpl.searchFirstNode(simplerspE, "IMETHODRESPONSE");
        if (imethodresponseE != null) {
            return CIMXMLParserImpl.parseIMETHODRESPONSE(imethodresponseE);
        }
        throw new CIMXMLParseException();
    }

    public static CIMResponse parseMULTIRSP(Element simplerspE) throws CIMXMLParseException {
        Vector multiresponseV = CIMXMLParserImpl.searchNodes(simplerspE, "SIMPLERSP");
        if (multiresponseV != null) {
            CIMResponse multiRsp = new CIMResponse();
            for (int i = 0; i < multiresponseV.size(); ++i) {
                Element methodresponseE = (Element)multiresponseV.elementAt(i);
                CIMResponse rsp = CIMXMLParserImpl.parseSIMPLERSP(methodresponseE);
                rsp.setMethod("SIMPLERSP");
                multiRsp.addResponse(rsp);
            }
            return multiRsp;
        }
        throw new CIMXMLParseException();
    }

    public static CIMRequest parseSIMPLEREQ(Element simplereqE) throws CIMXMLParseException {
        Element methodcallE = (Element)CIMXMLParserImpl.searchFirstNode(simplereqE, "METHODCALL");
        if (methodcallE != null) {
            return CIMXMLParserImpl.parseMETHODCALL(methodcallE);
        }
        Element imethodcallE = (Element)CIMXMLParserImpl.searchFirstNode(simplereqE, "IMETHODCALL");
        if (imethodcallE != null) {
            return CIMXMLParserImpl.parseIMETHODCALL(imethodcallE);
        }
        throw new CIMXMLParseException();
    }

    public static CIMRequest parseMULTIREQ(Element multireqE) throws CIMXMLParseException {
        Vector methodrequestV = CIMXMLParserImpl.searchNodes(multireqE, "MULTIREQ");
        if (methodrequestV != null) {
            CIMRequest multiReq = new CIMRequest();
            for (int i = 0; i < methodrequestV.size(); ++i) {
                Element methodrequestE = (Element)methodrequestV.elementAt(i);
                CIMRequest req = CIMXMLParserImpl.parseSIMPLEREQ(methodrequestE);
                req.setMethod("MULTIPREQ");
                multiReq.addRequest(req);
            }
            return multiReq;
        }
        throw new CIMXMLParseException();
    }

    public static CIMRequest parseMETHODCALL(Element methodcallE) throws CIMXMLParseException {
        Element localinstancepathE;
        CIMRequest request = new CIMRequest();
        String methodname = methodcallE.getAttribute("CIMName");
        request.setMethodName(methodname);
        boolean localclasspathFound = false;
        Element localclasspathE = (Element)CIMXMLParserImpl.searchFirstNode(methodcallE, "LOCALCLASSPATH");
        if (localclasspathE != null) {
            CIMObjectPath path = CIMXMLParserImpl.parseLOCALCLASSPATH(localclasspathE);
            request.setObjectPath(path);
            localclasspathFound = true;
        }
        if ((localinstancepathE = (Element)CIMXMLParserImpl.searchFirstNode(methodcallE, "LOCALINSTANCEATH")) != null) {
            CIMObjectPath path = CIMXMLParserImpl.parseLOCALINSTANCEPATH(localinstancepathE);
            request.setObjectPath(path);
        } else if (!localclasspathFound) {
            throw new CIMXMLParseException();
        }
        Vector paramvalueV = CIMXMLParserImpl.searchNodes(methodcallE, "PARAMVALUE");
        if (paramvalueV != null) {
            Vector<CIMArgument> v = new Vector<CIMArgument>();
            for (int i = 0; i < paramvalueV.size(); ++i) {
                Element paramvalueE = (Element)paramvalueV.elementAt(i);
                CIMArgument arg = CIMXMLParserImpl.parsePARAMVALUE(paramvalueE);
                v.add(arg);
            }
            request.addParamValue(v);
        }
        return request;
    }

    public static CIMRequest parseIMETHODCALL(Element imethodcallE) throws CIMXMLParseException {
        Vector iparamvalueV;
        CIMRequest request = new CIMRequest();
        String methodname = imethodcallE.getAttribute("NAME");
        request.setMethodName(methodname);
        Element localnamespacepathE = (Element)CIMXMLParserImpl.searchFirstNode(imethodcallE, "LOCALNAMESPACEPATH");
        if (localnamespacepathE != null) {
            CIMNameSpace namespace = CIMXMLParserImpl.parseLOCALNAMESPACEPATH(localnamespacepathE);
            request.setNameSpace(namespace);
        }
        if ((iparamvalueV = CIMXMLParserImpl.searchNodes(imethodcallE, "IPARAMVALUE")) != null) {
            Vector<CIMArgument> v = new Vector<CIMArgument>();
            for (int i = 0; i < iparamvalueV.size(); ++i) {
                CIMObjectPath op;
                Element paramvalueE = (Element)iparamvalueV.elementAt(i);
                CIMArgument arg = CIMXMLParserImpl.parseIPARAMVALUE(paramvalueE);
                Object value = arg.getValue().getValue();
                if (value instanceof CIMObjectPath && ((op = (CIMObjectPath)value).getNameSpace() == null || op.getNameSpace().length() == 0)) {
                    op.setNameSpace(request.getNameSpace());
                }
                v.add(arg);
            }
            request.addParamValue(v);
            return request;
        }
        throw new CIMXMLParseException();
    }

    public static CIMRequest parseSIMPLEEXPREQ(Element simpleexpreqE) throws CIMXMLParseException {
        Element expmethodcallE = (Element)CIMXMLParserImpl.searchFirstNode(simpleexpreqE, "EXPMETHODCALL");
        if (expmethodcallE != null) {
            return CIMXMLParserImpl.parseEXPMETHODCALL(expmethodcallE);
        }
        throw new CIMXMLParseException();
    }

    public static CIMRequest parseMULTIEXPREQ(Element multiexpreqE) throws CIMXMLParseException {
        Vector methodrequestV = CIMXMLParserImpl.searchNodes(multiexpreqE, "SIMPLEEXREQ");
        if (methodrequestV != null) {
            CIMRequest multiReq = new CIMRequest();
            for (int i = 0; i < methodrequestV.size(); ++i) {
                Element methodrequestE = (Element)methodrequestV.elementAt(i);
                CIMRequest req = CIMXMLParserImpl.parseSIMPLEEXPREQ(methodrequestE);
                req.setMethod("SIMPLEEXPREQ");
                multiReq.addRequest(req);
            }
            return multiReq;
        }
        throw new CIMXMLParseException();
    }

    public static CIMRequest parseEXPMETHODCALL(Element expmethodcallE) throws CIMXMLParseException {
        CIMRequest request = new CIMRequest();
        Vector expparamvalueV = CIMXMLParserImpl.searchNodes(expmethodcallE, "EXPPARAMVALUE");
        Vector<CIMInstance> v = new Vector<CIMInstance>();
        if (expparamvalueV != null) {
            for (int i = 0; i < expparamvalueV.size(); ++i) {
                Element expparamvalueE = (Element)expparamvalueV.elementAt(i);
                CIMInstance inst = CIMXMLParserImpl.parseEXPPARAMVALUE(expparamvalueE);
                v.add(inst);
            }
        }
        request.addParamValue(v);
        return request;
    }

    public static CIMInstance parseEXPPARAMVALUE(Element expparamvalueE) throws CIMXMLParseException {
        Element instanceE = (Element)CIMXMLParserImpl.searchFirstNode(expparamvalueE, "INSTANCE");
        if (instanceE != null) {
            CIMInstance inst = CIMXMLParserImpl.parseINSTANCE(instanceE);
            return inst;
        }
        throw new CIMXMLParseException();
    }

    public static CIMResponse parseMETHODRESPONSE(Element methodresponseE) throws CIMXMLParseException {
        Vector paramvalueV;
        CIMResponse response = new CIMResponse();
        Element errorE = (Element)CIMXMLParserImpl.searchFirstNode(methodresponseE, "ERROR");
        if (errorE != null) {
            CIMException exception = CIMXMLParserImpl.parseERROR(errorE);
            response.setError(exception);
            return response;
        }
        Vector returnvalueV = CIMXMLParserImpl.searchNodes(methodresponseE, "RETURNVALUE");
        if (returnvalueV != null) {
            Vector<CIMValue> v = new Vector<CIMValue>();
            for (int i = 0; i < returnvalueV.size(); ++i) {
                Element returnvalueE = (Element)returnvalueV.elementAt(i);
                CIMValue value = CIMXMLParserImpl.parseRETURNVALUE(returnvalueE);
                v.add(value);
            }
            response.setReturnValue(v);
        }
        if ((paramvalueV = CIMXMLParserImpl.searchNodes(methodresponseE, "PARAMVALUE")) != null) {
            Vector<CIMArgument> v = new Vector<CIMArgument>();
            for (int i = 0; i < paramvalueV.size(); ++i) {
                Element paramvalueE = (Element)paramvalueV.elementAt(i);
                CIMArgument arg = CIMXMLParserImpl.parsePARAMVALUE(paramvalueE);
                v.add(arg);
            }
            response.addParamValue(v);
        }
        if (returnvalueV != null) {
            Iterator iter = returnvalueV.iterator();
            while (iter.hasNext()) {
                Element returnvalueE = (Element)iter.next();
                paramvalueV = CIMXMLParserImpl.searchNodes(returnvalueE, "PARAMVALUE");
                if (paramvalueV == null) continue;
                Vector<CIMArgument> v = new Vector<CIMArgument>();
                for (int i = 0; i < paramvalueV.size(); ++i) {
                    Element paramvalueE = (Element)paramvalueV.elementAt(i);
                    CIMArgument arg = CIMXMLParserImpl.parsePARAMVALUE(paramvalueE);
                    v.add(arg);
                }
                response.addParamValue(v);
            }
        }
        return response;
    }

    public static CIMResponse parseIMETHODRESPONSE(Element imethodresponseE) throws CIMXMLParseException {
        CIMResponse response = new CIMResponse();
        Element errorE = (Element)CIMXMLParserImpl.searchFirstNode(imethodresponseE, "ERROR");
        if (errorE != null) {
            CIMException exception = CIMXMLParserImpl.parseERROR(errorE);
            response.setError(exception);
            return response;
        }
        Vector ireturnvalueV = CIMXMLParserImpl.searchNodes(imethodresponseE, "IRETURNVALUE");
        if (ireturnvalueV != null) {
            for (int i = 0; i < ireturnvalueV.size(); ++i) {
                Element ireturnvalueE = (Element)ireturnvalueV.elementAt(i);
                Vector rtnV = CIMXMLParserImpl.parseIRETURNVALUE(ireturnvalueE);
                response.setReturnValue(rtnV);
            }
        }
        return response;
    }

    public static CIMException parseERROR(Element errorE) throws CIMXMLParseException {
        int errorCode;
        block4: {
            Attr error_codeA = (Attr)CIMXMLParserImpl.searchAttribute(errorE, "CODE");
            String code = error_codeA.getNodeValue();
            errorCode = 0;
            try {
                if (code.length() > 0) {
                    errorCode = Integer.parseInt(code);
                }
            }
            catch (Exception e) {
                Logger logger = SessionProperties.getGlobalProperties().getLogger();
                if (!logger.isLoggable(Level.WARNING)) break block4;
                logger.log(Level.WARNING, "exception while parsing error code from XML", e);
            }
        }
        Attr error_descriptionA = (Attr)CIMXMLParserImpl.searchAttribute(errorE, "DESCRIPTION");
        String description = "";
        if (error_descriptionA != null) {
            description = error_descriptionA.getNodeValue();
        }
        return new CIMException(CIMException.getStatusFromCode(errorCode), description);
    }

    public static CIMValue parseRETURNVALUE(Element returnvalueE) throws CIMXMLParseException {
        Element valueE;
        Attr returnvalue_paramtypeA = (Attr)CIMXMLParserImpl.searchAttribute(returnvalueE, "PARAMTYPE");
        String valueTypeStr = null;
        if (returnvalue_paramtypeA != null) {
            valueTypeStr = returnvalue_paramtypeA.getNodeValue();
        }
        if ((valueE = (Element)CIMXMLParserImpl.searchFirstNode(returnvalueE, "VALUE")) != null) {
            Attr value_typeA;
            String valueStr = CIMXMLParserImpl.parseVALUE(valueE);
            if (valueTypeStr == null && (value_typeA = (Attr)CIMXMLParserImpl.searchAttribute(valueE, "TYPE")) != null) {
                valueTypeStr = value_typeA.getNodeValue();
            }
            Object o = CIMXMLParserImpl.createJavaObject(valueTypeStr, valueStr);
            return new CIMValue(o, CIMDataType.getPredefinedType(14));
        }
        Element valuereferenceE = (Element)CIMXMLParserImpl.searchFirstNode(returnvalueE, "VALUE.REFERENCE");
        if (valuereferenceE != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseVALUEREFERENCE(valuereferenceE);
            return new CIMValue(op, CIMDataType.getPredefinedType(14));
        }
        throw new CIMXMLParseException();
    }

    public static Vector parseIRETURNVALUE(Element ireturnvalueE) throws CIMXMLParseException {
        Vector qualifierdeclarationV;
        Vector valueobjectwithlocalpathV;
        Vector valueobjectwithpathV;
        Vector valuenamedinstanceV;
        Vector valueobjectV;
        Vector valuereferenceV;
        Vector objectpathV;
        Vector instancenameV;
        Vector classnameV;
        Vector instanceV;
        Vector<Serializable> rtnV = new Vector<Serializable>();
        Vector classV = CIMXMLParserImpl.searchNodes(ireturnvalueE, "CLASS");
        if (classV != null) {
            for (int i = 0; i < classV.size(); ++i) {
                Element classE = (Element)classV.elementAt(i);
                CIMClass c = CIMXMLParserImpl.parseCLASS(classE);
                rtnV.add(c);
            }
        }
        if ((instanceV = CIMXMLParserImpl.searchNodes(ireturnvalueE, "INSTANCE")) != null) {
            for (int i = 0; i < instanceV.size(); ++i) {
                Element instanceE = (Element)instanceV.elementAt(i);
                CIMInstance inst = CIMXMLParserImpl.parseINSTANCE(instanceE);
                rtnV.add(inst);
            }
        }
        if ((classnameV = CIMXMLParserImpl.searchNodes(ireturnvalueE, "CLASSNAME")) != null) {
            for (int i = 0; i < classnameV.size(); ++i) {
                Element classnameE = (Element)classnameV.elementAt(i);
                CIMObjectPath op = CIMXMLParserImpl.parseCLASSNAME(classnameE);
                rtnV.add(op);
            }
        }
        if ((instancenameV = CIMXMLParserImpl.searchNodes(ireturnvalueE, "INSTANCENAME")) != null) {
            for (int i = 0; i < instancenameV.size(); ++i) {
                Element instancenameE = (Element)instancenameV.elementAt(i);
                CIMObjectPath op = CIMXMLParserImpl.parseINSTANCENAME(instancenameE);
                rtnV.add(op);
            }
        }
        if ((objectpathV = CIMXMLParserImpl.searchNodes(ireturnvalueE, "OBJECTPATH")) != null) {
            for (int i = 0; i < objectpathV.size(); ++i) {
                Element objectpathE = (Element)objectpathV.elementAt(i);
                CIMObjectPath op = CIMXMLParserImpl.parseOBJECTPATH(objectpathE);
                rtnV.add(op);
            }
        }
        if ((valuereferenceV = CIMXMLParserImpl.searchNodes(ireturnvalueE, "VALUE.REFERENCE")) != null) {
            for (int i = 0; i < valuereferenceV.size(); ++i) {
                Element valuereferenceE = (Element)valuereferenceV.elementAt(i);
                CIMObjectPath op = CIMXMLParserImpl.parseVALUEREFERENCE(valuereferenceE);
                rtnV.add(op);
            }
        }
        if ((valueobjectV = CIMXMLParserImpl.searchNodes(ireturnvalueE, "VALUE.OBJECT")) != null) {
            for (int i = 0; i < valueobjectV.size(); ++i) {
                Element valueobjectE = (Element)valueobjectV.elementAt(i);
                CIMElement o = CIMXMLParserImpl.parseVALUEOBJECT(valueobjectE);
                rtnV.add(o);
            }
        }
        if ((valuenamedinstanceV = CIMXMLParserImpl.searchNodes(ireturnvalueE, "VALUE.NAMEDINSTANCE")) != null) {
            for (int i = 0; i < valuenamedinstanceV.size(); ++i) {
                Element valuenamedisntanceE = (Element)valuenamedinstanceV.elementAt(i);
                CIMElement o = CIMXMLParserImpl.parseVALUENAMEDINSTANCE(valuenamedisntanceE);
                rtnV.add(o);
            }
        }
        if ((valueobjectwithpathV = CIMXMLParserImpl.searchNodes(ireturnvalueE, "VALUE.OBJECTWITHPATH")) != null) {
            for (int i = 0; i < valueobjectwithpathV.size(); ++i) {
                Element valueobjectwithpathE = (Element)valueobjectwithpathV.elementAt(i);
                CIMElement o = CIMXMLParserImpl.parseVALUEOBJECTWITHPATH(valueobjectwithpathE);
                rtnV.add(o);
            }
        }
        if ((valueobjectwithlocalpathV = CIMXMLParserImpl.searchNodes(ireturnvalueE, "VALUE.OBJECTWITHLOCALPATH")) != null) {
            for (int i = 0; i < valueobjectwithlocalpathV.size(); ++i) {
                Element valueobjectwithlocalpathE = (Element)valueobjectwithlocalpathV.elementAt(i);
                CIMElement o = CIMXMLParserImpl.parseVALUEOBJECTWITHLOCALPATH(valueobjectwithlocalpathE);
                rtnV.add(o);
            }
        }
        if ((qualifierdeclarationV = CIMXMLParserImpl.searchNodes(ireturnvalueE, "QUALIFIER.DECLARATION")) != null) {
            for (int i = 0; i < qualifierdeclarationV.size(); ++i) {
                Element qualifierdeclarationE = (Element)qualifierdeclarationV.elementAt(i);
                CIMQualifierType o = CIMXMLParserImpl.parseQUALIFIERDECLARATION(qualifierdeclarationE);
                rtnV.add(o);
            }
        }
        return rtnV;
    }

    public static Object parseObject(Element rootE) throws CIMXMLParseException {
        Serializable o = null;
        String nodeName = rootE.getNodeName();
        o = nodeName.equalsIgnoreCase("INSTANCE") ? CIMXMLParserImpl.parseINSTANCE(rootE) : (nodeName.equalsIgnoreCase("VALUE.NAMEDINSTANCE") ? CIMXMLParserImpl.parseVALUENAMEDINSTANCE(rootE) : (nodeName.equalsIgnoreCase("VALUE.NAMEDOBJECT") ? CIMXMLParserImpl.parseVALUENAMEDOBJECT(rootE) : (nodeName.equalsIgnoreCase("VALUE.OBJECTWITHPATH") ? CIMXMLParserImpl.parseVALUEOBJECTWITHPATH(rootE) : (nodeName.equalsIgnoreCase("VALUE.OBJECTWITHLOCALPATH") ? CIMXMLParserImpl.parseVALUEOBJECTWITHLOCALPATH(rootE) : (nodeName.equalsIgnoreCase("CLASS") ? CIMXMLParserImpl.parseCLASS(rootE) : (nodeName.equalsIgnoreCase("CLASSPATH") ? CIMXMLParserImpl.parseCLASSPATH(rootE) : (nodeName.equalsIgnoreCase("LOCALCLASSPATH") ? CIMXMLParserImpl.parseLOCALCLASSPATH(rootE) : (nodeName.equalsIgnoreCase("OBJECTPATH") ? CIMXMLParserImpl.parseOBJECTPATH(rootE) : (nodeName.equalsIgnoreCase("CLASSNAME") ? CIMXMLParserImpl.parseCLASSNAME(rootE) : (nodeName.equalsIgnoreCase("INSTANCEPATH") ? CIMXMLParserImpl.parseINSTANCEPATH(rootE) : (nodeName.equalsIgnoreCase("LOCALINSTANCEPATH") ? CIMXMLParserImpl.parseLOCALINSTANCEPATH(rootE) : (nodeName.equalsIgnoreCase("INSTANCENAME") ? CIMXMLParserImpl.parseINSTANCENAME(rootE) : (nodeName.equalsIgnoreCase("QUALIFIER") ? CIMXMLParserImpl.parseQUALIFIER(rootE) : (nodeName.equalsIgnoreCase("PROPERTY") ? CIMXMLParserImpl.parsePROPERTY(rootE) : (nodeName.equalsIgnoreCase("PROPERTY.ARRAY") ? CIMXMLParserImpl.parsePROPERTYARRAY(rootE) : (nodeName.equalsIgnoreCase("PROPERTY.REFERENCE") ? CIMXMLParserImpl.parsePROPERTYREFERENCE(rootE) : (nodeName.equalsIgnoreCase("METHOD") ? CIMXMLParserImpl.parseMETHOD(rootE) : (nodeName.equalsIgnoreCase("PARAMETER") ? CIMXMLParserImpl.parsePARAMETER(rootE) : (nodeName.equalsIgnoreCase("PARAMETER.REFERENCE") ? CIMXMLParserImpl.parsePARAMETERREFERENCE(rootE) : (nodeName.equalsIgnoreCase("PARAMETER.ARRAY") ? CIMXMLParserImpl.parsePARAMETERARRAY(rootE) : (nodeName.equalsIgnoreCase("PARAMETER.REFARRAY") ? CIMXMLParserImpl.parsePARAMETERREFARRAY(rootE) : null)))))))))))))))))))));
        return o;
    }

    public static Vector searchNodes(Element parentE, String tagName) {
        NodeList nl = parentE.getChildNodes();
        Vector<Node> v = new Vector<Node>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equals(tagName)) continue;
            v.add(n);
        }
        return v.size() == 0 ? null : v;
    }

    public static Node searchFirstNode(Element parentE, String tagName) {
        NodeList nl = parentE.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equals(tagName)) continue;
            return n;
        }
        return null;
    }

    public static Node searchAttribute(Node parentN, String attrName) {
        NamedNodeMap nnm = parentN.getAttributes();
        return nnm.getNamedItem(attrName);
    }

    public static Node searchFirstChild(Element parentE) {
        return parentE.getFirstChild();
    }

    public static Object createJavaObject(String typeStr, String value) {
        Object o = null;
        CIMDataType cimType = CIMDataType.getDataType(typeStr, false);
        int radix = 10;
        if ((typeStr.toLowerCase().startsWith("sint") || typeStr.toLowerCase().startsWith("int")) && ((value = value.toLowerCase()).startsWith("0x") || value.startsWith("+0x") || value.startsWith("-0x"))) {
            radix = 16;
            value = value.startsWith("-") ? "-" + value.substring(3) : value.substring(value.indexOf(120) + 1);
        }
        switch (cimType.getType()) {
            case 0: {
                o = new UnsignedInt8(Short.parseShort(value, radix));
                break;
            }
            case 2: {
                o = new UnsignedInt16(Integer.parseInt(value, radix));
                break;
            }
            case 4: {
                o = new UnsignedInt32(Long.parseLong(value, radix));
                break;
            }
            case 6: {
                o = new UnsignedInt64(new BigInteger(value, radix));
                break;
            }
            case 1: {
                o = Byte.valueOf(value, radix);
                break;
            }
            case 3: {
                o = Short.valueOf(value, radix);
                break;
            }
            case 5: {
                o = Integer.valueOf(value, radix);
                break;
            }
            case 7: {
                o = Long.valueOf(value, radix);
                break;
            }
            case 8: {
                o = value;
                break;
            }
            case 9: {
                o = new Boolean(value);
                break;
            }
            case 10: {
                o = new Float(value);
                break;
            }
            case 11: {
                o = new Double(value);
                break;
            }
            case 12: {
                o = CIMDateTime.valueOf(value);
                break;
            }
            case 14: {
                o = new CIMObjectPath(value);
                break;
            }
            case 13: {
                o = new Character(value.charAt(0));
                break;
            }
            case 15: {
                o = new Numeric(new BigInteger(value, radix).toString());
            }
        }
        return o;
    }
}

