/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMElement;
import org.sblim.wbem.cim.CIMFlavor;
import org.sblim.wbem.cim.CIMScope;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.util.Utils;

public class CIMQualifierType
extends CIMElement
implements Cloneable,
Comparable,
Serializable {
    private static final long serialVersionUID = -2092769638867980096L;
    private Vector iFlavors = new Vector(0);
    private Vector iScopes = new Vector(0);
    private CIMDataType iType = null;
    private CIMValue iDefaultValue;

    public CIMQualifierType() {
    }

    public CIMQualifierType(String pName) {
        super(pName);
    }

    public void addFlavor(CIMFlavor pFlavor) {
        if (pFlavor == null) {
            throw new IllegalArgumentException("null flavor argument");
        }
        Utils.addSorted(this.iFlavors, pFlavor);
    }

    public void addScope(CIMScope pScope) {
        if (pScope == null) {
            throw new IllegalArgumentException("null scope argument");
        }
        Utils.addSorted(this.iScopes, pScope);
    }

    public Object clone() {
        CIMQualifierType that = new CIMQualifierType(this.iName);
        that.iFlavors = (Vector)this.iFlavors.clone();
        that.iScopes = (Vector)this.iScopes.clone();
        if (this.iType != null) {
            that.iType = (CIMDataType)this.iType.clone();
        }
        if (this.iDefaultValue != null) {
            that.iDefaultValue = (CIMValue)this.iDefaultValue.clone();
        }
        return that;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CIMQualifierType)) {
            return false;
        }
        CIMQualifierType that = (CIMQualifierType)o;
        if (!this.iFlavors.equals(that.iFlavors) || !this.iScopes.equals(that.iScopes)) {
            return false;
        }
        if (!(this.iType == null && that.iType == null || this.iType != null && this.iType.equals(that.iType))) {
            return false;
        }
        if (!(this.iName == null && that.iName == null || this.iName != null && this.iName.equalsIgnoreCase(that.iName))) {
            return false;
        }
        return this.iDefaultValue == null && that.iDefaultValue == null || this.iDefaultValue != null && this.iDefaultValue.equals(that.iDefaultValue);
    }

    public int hashCode() {
        return this.iFlavors.hashCode() << 24 + this.iScopes.hashCode() << 16 + (this.iDefaultValue != null ? this.iDefaultValue.hashCode() : 0) << 8 + (this.iType != null ? this.iType.hashCode() : 0);
    }

    public CIMValue getDefaultValue() {
        return this.iDefaultValue;
    }

    public Vector getFlavor() {
        return this.iFlavors;
    }

    public Vector getScope() {
        return this.iScopes;
    }

    public CIMDataType getType() {
        return this.iType;
    }

    public boolean hasDefaultValue() {
        return this.iDefaultValue != null;
    }

    public boolean hasFlavor(CIMFlavor pFlavor) {
        if (pFlavor == null) {
            throw new IllegalArgumentException("null flavor argument");
        }
        return Utils.hasValue(this.iFlavors, pFlavor);
    }

    public boolean hasScope(CIMScope pScope) {
        if (pScope == null) {
            throw new IllegalArgumentException("null scope argument");
        }
        Iterator iter = this.iScopes.iterator();
        while (iter.hasNext()) {
            CIMScope scp = (CIMScope)iter.next();
            if (!scp.equals(pScope) && scp.getScope() != 8) continue;
            return true;
        }
        return false;
    }

    public boolean isArrayValue() {
        if (this.iType != null) {
            return this.iType.isArrayType();
        }
        if (this.iDefaultValue != null && this.iDefaultValue.getType() != null) {
            return this.iDefaultValue.getType().isArrayType();
        }
        return false;
    }

    public void setDefaultValue(CIMValue pValue) {
        this.iDefaultValue = pValue;
    }

    public void setType(CIMDataType pType) {
        this.iType = pType;
    }

    public String toMOF() {
        StringBuffer buf = new StringBuffer();
        buf.append("Qualifier ");
        buf.append(this.getName());
        buf.append(" : ");
        CIMDataType type = this.getType();
        if (type != null) {
            buf.append(type);
        }
        if (type != null && !type.isArrayType()) {
            buf.append(" = ");
            buf.append(this.getDefaultValue());
        }
        buf.append(",\n");
        if (this.iScopes.size() > 0) {
            buf.append("\tScope(");
            buf.append(CIMQualifierType.vectorToMOFString(this.iScopes));
            buf.append(")");
        }
        if (this.iFlavors.size() > 0) {
            buf.append(",\n\tFlavor(");
            buf.append(CIMQualifierType.vectorToMOFString(this.iFlavors));
            buf.append(")");
        }
        buf.append(";");
        return buf.toString();
    }

    public String toString() {
        return this.toMOF();
    }

    public int compareTo(Object o) {
        if (!(o instanceof CIMQualifierType)) {
            throw new IllegalArgumentException("Invalid object to compare with");
        }
        return this.iName.toUpperCase().compareTo(((CIMQualifierType)o).iName.toUpperCase());
    }
}

