/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMMethod;
import org.sblim.wbem.cim.CIMObject;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMParameter;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMQualifier;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.util.Utils;

public class CIMClass
extends CIMObject
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 117915892431935944L;
    private String iSuperclass = null;
    private Vector iAllMethods = new Vector(0);

    public CIMClass() {
    }

    public CIMClass(String pClassName) {
        super(pClassName);
        this.iObjectPath = new CIMObjectPath(pClassName);
    }

    public CIMClass(CIMObjectPath pObjectPath) {
        if (pObjectPath == null) {
            throw new IllegalArgumentException("null object path");
        }
        this.iName = pObjectPath.getObjectName();
        if (this.iName == null) {
            throw new IllegalArgumentException("null class name");
        }
        this.iObjectPath = new CIMObjectPath(this.iName);
        this.iObjectPath.setHost(pObjectPath.getHost());
        this.iObjectPath.setNameSpace(pObjectPath.getNameSpace());
    }

    public void addMethod(CIMMethod pMethod) {
        if (pMethod == null) {
            throw new IllegalArgumentException("null method argument");
        }
        if (this.getAllMethods(pMethod) == null) {
            Utils.addSorted(this.iAllMethods, pMethod);
        }
    }

    public Object clone() {
        CIMClass that = new CIMClass(this.iName);
        that.iSuperclass = this.iSuperclass;
        Iterator iter = this.iQualifiers.iterator();
        while (iter.hasNext()) {
            that.iQualifiers.add(((CIMQualifier)iter.next()).clone());
        }
        iter = this.iAllProperties.iterator();
        while (iter.hasNext()) {
            that.addProperty((CIMProperty)((CIMProperty)iter.next()).clone());
        }
        iter = this.iAllMethods.iterator();
        while (iter.hasNext()) {
            that.addMethod((CIMMethod)((CIMMethod)iter.next()).clone());
        }
        return that;
    }

    public int hashCode() {
        return this.iAllProperties.hashCode() + this.iAllMethods.hashCode() + this.iQualifiers.hashCode() + (this.iSuperclass != null ? this.iSuperclass.hashCode() : 0) + this.iName.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CIMClass)) {
            return false;
        }
        CIMClass that = (CIMClass)o;
        if (!(this.iAllProperties.equals(that.iAllProperties) && this.iAllMethods.equals(that.iAllMethods) && this.iQualifiers.equals(that.iQualifiers) && this.iObjectPath.equals(that.iObjectPath))) {
            return false;
        }
        if (!(this.iSuperclass != null ? this.iSuperclass.equalsIgnoreCase(that.iSuperclass) : that.iSuperclass == null)) {
            return false;
        }
        return this.iName == null ? that.iName == null : this.iName.equalsIgnoreCase(that.iName);
    }

    protected CIMMethod getMethod(CIMMethod pMethod) {
        Iterator iter = this.iAllMethods.iterator();
        while (iter.hasNext()) {
            CIMMethod method = (CIMMethod)iter.next();
            if (!method.getName().equalsIgnoreCase(pMethod.getName())) continue;
            return method;
        }
        return null;
    }

    protected CIMMethod getAllMethods(CIMMethod pMethod) {
        Iterator iter = this.iAllMethods.iterator();
        while (iter.hasNext()) {
            CIMMethod method = (CIMMethod)iter.next();
            if (!method.getName().equalsIgnoreCase(pMethod.getName())) continue;
            return method;
        }
        return null;
    }

    public CIMClass filterProperties(String[] pPropertyList) {
        CIMClass that = new CIMClass(this.iName);
        that.iSuperclass = this.iSuperclass;
        Iterator iter = this.iQualifiers.iterator();
        while (iter.hasNext()) {
            that.iQualifiers.add(((CIMQualifier)iter.next()).clone());
        }
        iter = this.iAllProperties.iterator();
        block1: while (iter.hasNext()) {
            CIMProperty property = (CIMProperty)((CIMProperty)iter.next()).clone();
            String propName = property.getName();
            for (int i = 0; i < pPropertyList.length; ++i) {
                if (!propName.equalsIgnoreCase(pPropertyList[i])) continue;
                that.addProperty(property);
                continue block1;
            }
        }
        iter = this.iAllMethods.iterator();
        while (iter.hasNext()) {
            that.addMethod((CIMMethod)((CIMMethod)iter.next()).clone());
        }
        return that;
    }

    public Vector getAllMethods() {
        return this.iAllMethods;
    }

    public CIMMethod getMethod(String pName) {
        if (pName == null) {
            return null;
        }
        int delimiter = pName.indexOf(46);
        if (delimiter > -1) {
            return this.getMethod(pName.substring(delimiter + 1), pName.substring(0, delimiter));
        }
        Iterator iter = this.iAllMethods.iterator();
        while (iter.hasNext()) {
            CIMMethod method = (CIMMethod)iter.next();
            if (!method.getName().equalsIgnoreCase(pName)) continue;
            String overridingMethod = method.getOverridingMethod();
            if (overridingMethod != null) {
                delimiter = overridingMethod.indexOf(46);
                if (delimiter > -1) {
                    return this.getMethod(overridingMethod.substring(delimiter + 1), overridingMethod.substring(0, delimiter));
                }
                return this.getMethod(overridingMethod);
            }
            return method;
        }
        return null;
    }

    public CIMMethod getMethod(String pName, String pOriginClass) {
        if (pName == null) {
            return null;
        }
        if (pOriginClass == null || pOriginClass.length() == 0) {
            return this.getMethod(pName);
        }
        Iterator iter = this.iAllMethods.iterator();
        while (iter.hasNext()) {
            CIMMethod method = (CIMMethod)iter.next();
            if (!method.getName().equalsIgnoreCase(pName) || !method.getOriginClass().equalsIgnoreCase(pOriginClass)) continue;
            String overridingMethod = method.getOverridingMethod();
            if (overridingMethod != null) {
                int delimiter = overridingMethod.indexOf(46);
                if (delimiter > -1) {
                    return this.getMethod(overridingMethod.substring(delimiter + 1), overridingMethod.substring(0, delimiter));
                }
                return this.getMethod(overridingMethod);
            }
            return method;
        }
        return null;
    }

    public Vector getMethods() {
        Vector<CIMMethod> methods = new Vector<CIMMethod>();
        Iterator iter = this.iAllMethods.iterator();
        while (iter.hasNext()) {
            CIMMethod method = (CIMMethod)iter.next();
            if (method.getOriginClass() != null) continue;
            methods.add(method);
        }
        return methods;
    }

    public String getSuperClass() {
        return this.iSuperclass;
    }

    public boolean isAssociation() {
        Iterator iter = this.iQualifiers.iterator();
        while (iter.hasNext()) {
            CIMQualifier qualifier = (CIMQualifier)iter.next();
            if (!qualifier.getName().equalsIgnoreCase("Association") || qualifier.getValue() != null && !CIMValue.TRUE.equals(qualifier.getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean isKeyed() {
        Iterator iter = this.iAllProperties.iterator();
        while (iter.hasNext()) {
            CIMProperty property = (CIMProperty)iter.next();
            if (!property.isKey()) continue;
            return true;
        }
        return false;
    }

    public CIMClass localElements() {
        CIMClass that = new CIMClass(this.iName);
        that.setObjectPath((CIMObjectPath)this.getObjectPath().clone());
        that.iSuperclass = this.iSuperclass;
        Iterator iter = this.iAllMethods.iterator();
        while (iter.hasNext()) {
            CIMMethod method = (CIMMethod)iter.next();
            if (!method.getOriginClass().equalsIgnoreCase(this.iName)) continue;
            that.addMethod((CIMMethod)method.clone());
        }
        iter = this.iAllProperties.iterator();
        while (iter.hasNext()) {
            CIMProperty property = (CIMProperty)iter.next();
            if (!property.getOriginClass().equalsIgnoreCase(this.iName)) continue;
            that.addProperty((CIMProperty)property.clone());
        }
        iter = this.iQualifiers.iterator();
        while (iter.hasNext()) {
            CIMQualifier qualifiers = (CIMQualifier)iter.next();
            that.iQualifiers.add(qualifiers.clone());
        }
        return that;
    }

    public CIMInstance newInstance() {
        CIMInstance inst = new CIMInstance();
        inst.setName(this.getName());
        Vector<Object> newProperties = new Vector<Object>();
        for (int i = 0; i < this.iAllProperties.size(); ++i) {
            CIMProperty property = (CIMProperty)this.iAllProperties.elementAt(i);
            newProperties.add(property.clone());
        }
        inst.setProperties(newProperties);
        Vector<Object> newQualifiers = new Vector<Object>();
        for (int i = 0; i < this.iQualifiers.size(); ++i) {
            CIMQualifier qualifier = (CIMQualifier)this.iQualifiers.elementAt(i);
            newQualifiers.add(qualifier.clone());
        }
        inst.setQualifiers(newQualifiers);
        return inst;
    }

    public int numberOfProperties() {
        return this.getProperties().size();
    }

    public int numberOfQualifiers() {
        return this.iQualifiers.size();
    }

    public void setSuperClass(String pClass) {
        this.iSuperclass = pClass;
    }

    public void setIsAssociation(boolean pValue) {
        CIMQualifier associationQualifier = this.getQualifier("Association");
        if (associationQualifier == null && pValue) {
            Utils.addSorted(this.iQualifiers, new CIMQualifier("Association"));
        } else if (associationQualifier != null && !pValue) {
            this.removeQualifier(associationQualifier.getName());
        }
    }

    public void setIsKeyed(boolean pValue) {
    }

    public void setMethods(Vector pMethods) {
        if (pMethods == null) {
            this.iAllMethods.setSize(0);
        } else {
            this.iAllMethods.setSize(0);
            Utils.addSorted(this.iAllMethods, pMethods);
        }
    }

    public void setName(String pName) {
        if (pName == null) {
            throw new IllegalArgumentException("null name argument");
        }
        super.setName(pName);
        if (this.iObjectPath == null) {
            this.iObjectPath = new CIMObjectPath(pName);
        } else {
            this.iObjectPath.setObjectName(pName);
        }
    }

    public CIMObjectPath getObjectPath() {
        return this.iObjectPath;
    }

    public void setObjectPath(CIMObjectPath pObjectPath) {
        if (pObjectPath == null) {
            throw new IllegalArgumentException("null objectpath argument");
        }
        if (this.iObjectPath == null) {
            this.iObjectPath = new CIMObjectPath();
        }
        this.iObjectPath.setHost(pObjectPath.getHost());
        this.iObjectPath.setNameSpace(pObjectPath.getNameSpace());
        this.setName(pObjectPath.getObjectName());
    }

    public String toMOF() {
        StringBuffer buf = new StringBuffer();
        buf.append(CIMClass.vectorToMOFString(this.iQualifiers, false, 1));
        buf.append("\nclass ");
        buf.append(this.getName());
        if (this.iSuperclass != null && this.iSuperclass.length() > 0) {
            buf.append(" : ");
            buf.append(this.iSuperclass);
        }
        buf.append(" {\n");
        if (this.iAllProperties.size() > 0) {
            buf.append(CIMClass.vectorToMOFString(this.iAllProperties, true, 0, 0, false));
            buf.append("\n");
        }
        if (this.iAllMethods.size() > 0) {
            buf.append(CIMClass.vectorToMOFString(this.iAllMethods, true, 1, 0, false));
        }
        buf.append("};");
        return buf.toString();
    }

    public String toString() {
        return this.toMOF();
    }

    public static void main(String[] args) {
        CIMClass cl1 = new CIMClass("CIM_ComputerSystem");
        CIMMethod m1 = new CIMMethod("AddProperty");
        m1.addQualifier(new CIMQualifier("Overridable"));
        m1.setType(new CIMDataType(5, 32));
        CIMParameter p1 = new CIMParameter("Arg1");
        p1.addQualifier(new CIMQualifier("IN"));
        m1.addParameter(p1);
        System.out.println(cl1);
    }
}

