/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.proxy.common;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.proxy.WalkResponse;
import org.opennms.netmgt.snmp.proxy.common.AbstractSNMPRequestBuilder;
import org.opennms.netmgt.snmp.proxy.common.LocationAwareSnmpClientRpcImpl;
import org.opennms.netmgt.snmp.proxy.common.SnmpMultiResponseDTO;
import org.opennms.netmgt.snmp.proxy.common.SnmpWalkRequestDTO;

public class SNMPWalkWithTrackerBuilder
extends AbstractSNMPRequestBuilder<CollectionTracker> {
    private final CollectionTracker m_tracker;

    public SNMPWalkWithTrackerBuilder(LocationAwareSnmpClientRpcImpl client, SnmpAgentConfig agent, CollectionTracker tracker) {
        super(client, agent, Collections.emptyList(), SNMPWalkWithTrackerBuilder.buildWalkRequests(tracker));
        this.m_tracker = tracker;
    }

    private static List<SnmpWalkRequestDTO> buildWalkRequests(CollectionTracker tracker) {
        return tracker.getWalkRequests().stream().map(req -> {
            SnmpWalkRequestDTO walkRequest = new SnmpWalkRequestDTO();
            walkRequest.setCorrelationId(req.getCorrelationId());
            walkRequest.setOids(Collections.singletonList(req.getBaseOid()));
            walkRequest.setMaxRepetitions(req.getMaxRepetitions());
            walkRequest.setInstance(req.getInstance());
            return walkRequest;
        }).collect(Collectors.toList());
    }

    @Override
    protected CollectionTracker processResponse(SnmpMultiResponseDTO response) {
        List responses = response.getResponses().stream().map(res -> new WalkResponse(res.getResults(), res.getCorrelationId())).collect(Collectors.toList());
        this.m_tracker.handleWalkResponses(responses);
        return this.m_tracker;
    }
}

