/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.proxy.common;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.opennms.core.rpc.api.RpcClient;
import org.opennms.core.rpc.api.RpcClientFactory;
import org.opennms.core.rpc.api.RpcModule;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.opennms.netmgt.snmp.proxy.SNMPRequestBuilder;
import org.opennms.netmgt.snmp.proxy.common.SNMPMultiGetBuilder;
import org.opennms.netmgt.snmp.proxy.common.SNMPSingleGetBuilder;
import org.opennms.netmgt.snmp.proxy.common.SNMPWalkBuilder;
import org.opennms.netmgt.snmp.proxy.common.SNMPWalkWithTrackerBuilder;
import org.opennms.netmgt.snmp.proxy.common.SnmpMultiResponseDTO;
import org.opennms.netmgt.snmp.proxy.common.SnmpProxyRpcModule;
import org.opennms.netmgt.snmp.proxy.common.SnmpRequestDTO;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class LocationAwareSnmpClientRpcImpl
implements LocationAwareSnmpClient,
InitializingBean {
    @Autowired
    private RpcClientFactory rpcClientFactory;
    private RpcClient<SnmpRequestDTO, SnmpMultiResponseDTO> delegate;

    public LocationAwareSnmpClientRpcImpl() {
    }

    public LocationAwareSnmpClientRpcImpl(RpcClientFactory rpcClientFactory) {
        this.rpcClientFactory = Objects.requireNonNull(rpcClientFactory);
        this.afterPropertiesSet();
    }

    public void afterPropertiesSet() {
        this.delegate = this.rpcClientFactory.getClient((RpcModule)SnmpProxyRpcModule.INSTANCE);
    }

    public SNMPRequestBuilder<List<SnmpResult>> walk(SnmpAgentConfig agent, String ... oids) {
        List<SnmpObjId> snmpObjIds = Arrays.stream(oids).map(oid -> SnmpObjId.get((String)oid)).collect(Collectors.toList());
        return this.walk(agent, snmpObjIds);
    }

    public SNMPRequestBuilder<List<SnmpResult>> walk(SnmpAgentConfig agent, SnmpObjId ... oids) {
        return this.walk(agent, Arrays.asList(oids));
    }

    public SNMPRequestBuilder<List<SnmpResult>> walk(SnmpAgentConfig agent, List<SnmpObjId> oids) {
        return new SNMPWalkBuilder(this, agent, oids);
    }

    public SNMPRequestBuilder<CollectionTracker> walk(SnmpAgentConfig agent, CollectionTracker tracker) {
        return new SNMPWalkWithTrackerBuilder(this, agent, tracker);
    }

    public SNMPRequestBuilder<SnmpValue> get(SnmpAgentConfig agent, String oid) {
        return this.get(agent, SnmpObjId.get((String)oid));
    }

    public SNMPRequestBuilder<SnmpValue> get(SnmpAgentConfig agent, SnmpObjId oid) {
        return new SNMPSingleGetBuilder(this, agent, oid);
    }

    public SNMPRequestBuilder<List<SnmpValue>> get(SnmpAgentConfig agent, String ... oids) {
        List<SnmpObjId> snmpObjIds = Arrays.stream(oids).map(oid -> SnmpObjId.get((String)oid)).collect(Collectors.toList());
        return this.get(agent, snmpObjIds);
    }

    public SNMPRequestBuilder<List<SnmpValue>> get(SnmpAgentConfig agent, SnmpObjId ... oids) {
        return this.get(agent, Arrays.asList(oids));
    }

    public SNMPRequestBuilder<List<SnmpValue>> get(SnmpAgentConfig agent, List<SnmpObjId> oids) {
        return new SNMPMultiGetBuilder(this, agent, oids);
    }

    public CompletableFuture<SnmpMultiResponseDTO> execute(SnmpRequestDTO request) {
        return this.delegate.execute((RpcRequest)request);
    }
}

