/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import org.opennms.netmgt.snmp.AbstractSnmpStore;
import org.opennms.netmgt.snmp.NamedSnmpVar;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpStore
extends AbstractSnmpStore {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpStore.class);
    protected final NamedSnmpVar[] ms_elemList;

    public SnmpStore(NamedSnmpVar[] list) {
        this.ms_elemList = (NamedSnmpVar[])list.clone();
    }

    public int getElementListSize() {
        return this.ms_elemList.length;
    }

    public NamedSnmpVar[] getElements() {
        return this.ms_elemList;
    }

    @Override
    public void storeResult(SnmpResult res) {
        SnmpObjId base = res.getBase();
        SnmpValue value = res.getValue();
        this.putValue(base.toString(), value);
        for (NamedSnmpVar var : this.ms_elemList) {
            if (!base.equals(var.getSnmpObjId())) continue;
            if (value.isError()) {
                LOG.error("storeResult: got an error for alias {} [{}].[{}], but we should only be getting non-errors: {}", new Object[]{var.getAlias(), base, res.getInstance(), value});
                continue;
            }
            if (value.isEndOfMib()) {
                LOG.debug("storeResult: got endOfMib for alias {} [{}].[{}], not storing", new Object[]{var.getAlias(), base, res.getInstance()});
                continue;
            }
            SnmpValueType type = SnmpValueType.valueOf(value.getType());
            LOG.debug("Storing Result: alias: {} [{}].[{}] = {}: {}", new Object[]{var.getAlias(), base, res.getInstance(), type == null ? "Unknown" : type.getDisplayString(), this.toLogString(value)});
            this.putValue(var.getAlias(), value);
        }
    }

    private String toLogString(SnmpValue val) {
        if (val.getType() == 4) {
            return val.toDisplayString() + " (" + val.toHexString() + ")";
        }
        return val.toString();
    }
}

