/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.util.StringTokenizer;
import org.opennms.netmgt.snmp.SnmpObjId;

public class SnmpInstId
extends SnmpObjId {
    public static final SnmpInstId INST_ZERO = new SnmpInstId(0);

    public SnmpInstId(int[] instanceIds) {
        super(instanceIds);
    }

    public SnmpInstId(String instance) {
        super(instance);
    }

    public SnmpInstId(SnmpObjId instance) {
        super(instance);
    }

    public SnmpInstId(int instance) {
        super(new int[]{instance}, false);
    }

    @Override
    protected boolean addPrefixDotInToString() {
        return false;
    }

    public static SnmpInstId[] convertToSnmpInstIds(String instances) {
        StringTokenizer tokenizer = new StringTokenizer(instances, ",");
        SnmpInstId[] insts = new SnmpInstId[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            SnmpInstId inst;
            String token = tokenizer.nextToken();
            insts[index] = inst = new SnmpInstId(token);
            ++index;
        }
        return insts;
    }

    public int toInt() {
        if (this.length() != 1) {
            throw new IllegalArgumentException("Cannot convert " + this + " to an int");
        }
        return this.getLastSubId();
    }
}

