/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.aws.sqs;

import org.opennms.core.rpc.common.RpcStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.ImportResource;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@Conditional(value={Condition.class})
@ImportResource(value={"/META-INF/opennms/applicationContext-rpc-client-sqs.xml"})
public class ConditionalAmazonSqsRpcContext {
    private static final Logger LOG = LoggerFactory.getLogger(ConditionalAmazonSqsRpcContext.class);

    static class Condition
    implements ConfigurationCondition {
        Condition() {
        }

        public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
            return ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION;
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            boolean enabled = RpcStrategy.Strategy.SQS.equals((Object)RpcStrategy.getRpcStrategy());
            LOG.debug("Enable SQS RPC: {}", (Object)enabled);
            return enabled;
        }
    }
}

