/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jmx.impl.connection.connectors;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.opennms.netmgt.jmx.connection.JmxConnectionConfigBuilder;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionWrapper;
import org.opennms.netmgt.jmx.impl.connection.connectors.DefaultJmxConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Jsr160ConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(Jsr160ConnectionFactory.class);
    private static final long DEFAULT_TIMEOUT = 30000L;
    private static final ExecutorService executor = Executors.newCachedThreadPool();

    public static JmxServerConnectionWrapper getMBeanServerConnection(final Map<String, String> propertiesMap, final InetAddress address) throws IOException {
        long timeout = 30000L;
        propertiesMap.putIfAbsent("factory", "STANDARD");
        propertiesMap.putIfAbsent("port", "1099");
        propertiesMap.putIfAbsent("protocol", "rmi");
        propertiesMap.putIfAbsent("urlPath", "/jmxrmi");
        propertiesMap.putIfAbsent("timeout", Long.toString(30000L));
        Callable<JmxServerConnectionWrapper> task = new Callable<JmxServerConnectionWrapper>(){

            @Override
            public JmxServerConnectionWrapper call() throws Exception {
                return new DefaultJmxConnector().createConnection(address, propertiesMap);
            }
        };
        Future<JmxServerConnectionWrapper> future = executor.submit(task);
        try {
            JmxServerConnectionWrapper connectionWrapper = future.get(30000L, TimeUnit.MILLISECONDS);
            return connectionWrapper;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            String url = JmxConnectionConfigBuilder.buildFrom((InetAddress)address, propertiesMap).build().getUrl();
            LOG.info("Exception connecting JMXConnectorFactory url {} , Error: {}", (Object)url, (Object)e.getMessage());
            if (!future.isDone()) {
                future.cancel(true);
                LOG.info(" the task {}", (Object)(future.isCancelled() ? "was cancelled" : "could not be cancelled"));
            }
            throw new ConnectException("Error connecting JMXConnectionFactory  " + url);
        }
    }
}

