/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jmx.impl.connection.connectors;

import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionException;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionWrapper;
import org.opennms.netmgt.jmx.connection.JmxServerConnector;
import org.opennms.netmgt.jmx.impl.connection.connectors.IsolatingClassLoader;
import org.opennms.netmgt.jmx.impl.connection.connectors.JBossConnectionWrapper;
import org.opennms.netmgt.jmx.impl.connection.connectors.MBeanServerProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JBossMBeanServerConnector
implements JmxServerConnector {
    private static final Logger LOG = LoggerFactory.getLogger(JBossMBeanServerConnector.class);
    private static final String[] PACKAGES = new String[]{"org.jboss.naming.*", "org.jboss.interfaces.*"};

    JBossMBeanServerConnector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JmxServerConnectionWrapper createConnection(InetAddress ipAddress, Map<String, String> propertiesMap) throws JmxServerConnectionException {
        InitialContext ctx;
        JBossConnectionWrapper wrapper = null;
        IsolatingClassLoader icl = null;
        final ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        String connectionType = ParameterMap.getKeyedString(propertiesMap, (String)"factory", (String)"RMI");
        String timeout = ParameterMap.getKeyedString(propertiesMap, (String)"timeout", (String)"3000");
        String jbossVersion = ParameterMap.getKeyedString(propertiesMap, (String)"version", (String)"4");
        String port = ParameterMap.getKeyedString(propertiesMap, (String)"port", (String)"1099");
        if (jbossVersion == null || jbossVersion.startsWith("4")) {
            try {
                icl = new IsolatingClassLoader("jboss", new URL[]{new File(System.getProperty("opennms.home") + "/lib/jboss/jbossall-client.jar").toURI().toURL()}, originalLoader, PACKAGES, true);
            }
            catch (MalformedURLException e) {
                LOG.error("JBossConnectionWrapper MalformedURLException", (Throwable)e);
            }
            catch (IsolatingClassLoader.InvalidContextClassLoaderException e) {
                LOG.error("JBossConnectionWrapper InvalidContextClassLoaderException", (Throwable)e);
            }
        } else if (jbossVersion.startsWith("3")) {
            PrivilegedAction<IsolatingClassLoader> action = new PrivilegedAction<IsolatingClassLoader>(){

                @Override
                public IsolatingClassLoader run() {
                    try {
                        return new IsolatingClassLoader("jboss", new URL[]{new File(System.getProperty("opennms.home") + "/lib/jboss/jbossall-client32.jar").toURI().toURL()}, originalLoader, PACKAGES, true);
                    }
                    catch (MalformedURLException e) {
                        LOG.error("JBossConnectionWrapper MalformedURLException", (Throwable)e);
                    }
                    catch (IsolatingClassLoader.InvalidContextClassLoaderException e) {
                        LOG.error("JBossConnectionWrapper InvalidContextClassLoaderException", (Throwable)e);
                    }
                    return null;
                }
            };
            AccessController.doPrivileged(action);
        }
        if (icl == null) {
            return null;
        }
        Thread.currentThread().setContextClassLoader(icl);
        if (connectionType.equals("RMI")) {
            ctx = null;
            String hostAddress = InetAddressUtils.toUrlIpAddress((InetAddress)ipAddress);
            try {
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("java.naming.factory.initial", "org.jboss.naming.NamingContextFactory");
                props.put("java.naming.provider.url", "jnp://" + hostAddress + ":" + port);
                props.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
                props.put("jnp.sotimeout", timeout);
                ctx = new InitialContext(props);
                Object rmiAdaptor = ctx.lookup("jmx/rmi/RMIAdaptor");
                wrapper = new JBossConnectionWrapper(MBeanServerProxy.buildServerProxy(rmiAdaptor));
            }
            catch (Throwable e) {
                LOG.debug("JBossConnectionFactory - unable to get MBeanServer using RMI on {}:{}", (Object)hostAddress, (Object)port);
            }
            finally {
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (Throwable e1) {
                    LOG.debug("JBossConnectionFactory error closing initial context");
                }
            }
        } else if (connectionType.equals("HTTP")) {
            ctx = null;
            Object invokerSuffix = null;
            String hostAddress = InetAddressUtils.toUrlIpAddress((InetAddress)ipAddress);
            try {
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("java.naming.factory.initial", "org.jboss.naming.HttpNamingContextFactory");
                props.put("java.naming.provider.url", "http://" + hostAddress + ":" + port + "/invoker/JNDIFactory");
                props.put("jnp.sotimeout", timeout);
                ctx = new InitialContext(props);
                Object rmiAdaptor = ctx.lookup("jmx/rmi/RMIAdaptor");
                wrapper = new JBossConnectionWrapper(MBeanServerProxy.buildServerProxy(rmiAdaptor));
            }
            catch (Throwable e) {
                LOG.debug("JBossConnectionFactory - unable to get MBeanServer using HTTP on {}{}", (Object)hostAddress, invokerSuffix);
            }
            finally {
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e1) {
                    LOG.debug("JBossConnectionFactory error closing initial context");
                }
            }
        }
        Thread.currentThread().setContextClassLoader(originalLoader);
        return wrapper;
    }
}

