/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.camel;

import java.util.Objects;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.ipc.sink.camel.CamelMessageConsumerManager;

public class CamelSinkServerProcessor
implements Processor {
    private final CamelMessageConsumerManager consumerManager;
    private final SinkModule<?, Message> module;

    public CamelSinkServerProcessor(CamelMessageConsumerManager consumerManager, SinkModule<?, Message> module) {
        this.consumerManager = Objects.requireNonNull(consumerManager);
        this.module = Objects.requireNonNull(module);
    }

    public void process(Exchange exchange) {
        String messageAsString = (String)exchange.getIn().getBody(String.class);
        Message message = this.module.unmarshal(messageAsString);
        this.consumerManager.dispatch(this.module, message);
    }
}

