/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.camel;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointInject;
import org.apache.camel.ProducerTemplate;
import org.opennms.core.camel.JmsQueueNameFactory;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.ipc.sink.camel.CamelLocalMessageDispatcherFactory;
import org.opennms.core.ipc.sink.common.AbstractMessageDispatcherFactory;

public class CamelRemoteMessageDispatcherFactory
extends AbstractMessageDispatcherFactory<Map<String, Object>> {
    @EndpointInject(uri="direct:sendMessage", context="sinkClient")
    private ProducerTemplate template;
    @EndpointInject(uri="direct:sendMessage", context="sinkClient")
    private Endpoint endpoint;
    private JmxReporter reporter;

    public <S extends Message, T extends Message> Map<String, Object> getModuleMetadata(SinkModule<S, T> module) {
        JmsQueueNameFactory queueNameFactory = new JmsQueueNameFactory("Sink", module.getId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("JmsQueueName", queueNameFactory.getName());
        return Collections.unmodifiableMap(headers);
    }

    public <S extends Message, T extends Message> void dispatch(SinkModule<S, T> module, Map<String, Object> headers, T message) {
        this.template.sendBodyAndHeaders(this.endpoint, (Object)module.marshal(message), headers);
    }

    public void registerJmxReporter() {
        this.reporter = JmxReporter.forRegistry((MetricRegistry)this.getMetrics()).inDomain(CamelLocalMessageDispatcherFactory.class.getPackage().getName()).build();
        this.reporter.start();
    }

    public void unregisterJmxReporter() {
        if (this.reporter != null) {
            this.reporter.close();
            this.reporter = null;
        }
    }
}

