/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class SyslogTimeStamp
extends Format {
    private static final long serialVersionUID = -6116771489369028204L;
    public static final String DEFAULT_GMT_TZID = "GMT+00";

    public static final SyslogTimeStamp getInstance() {
        return new SyslogTimeStamp();
    }

    public String format(Date date) throws IllegalArgumentException {
        TimeZone tz = TimeZone.getTimeZone(DEFAULT_GMT_TZID);
        return this.formatTimeZone(date, tz);
    }

    public String formatTimeZone(Date date, TimeZone tz) throws IllegalArgumentException {
        Locale loc = Locale.US;
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM", loc);
        dateFormat.setTimeZone(tz);
        String month = dateFormat.format(date);
        month = month.substring(0, 3);
        dateFormat = new SimpleDateFormat("dd HH:mm:ss", loc);
        dateFormat.setTimeZone(tz);
        String rest = dateFormat.format(date);
        return month + " " + rest;
    }

    @Override
    public StringBuffer format(Object date, StringBuffer appendTo, FieldPosition fieldPos) throws IllegalArgumentException {
        String tmpFormat = this.format((Date)date);
        appendTo.append(tmpFormat);
        return appendTo;
    }

    public Date parse(String source) throws ParseException {
        return this.parseTimestamp(source);
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        Date stamp = null;
        try {
            stamp = this.parseTimestamp(source);
        }
        catch (ParseException ex) {
            stamp = null;
        }
        return stamp;
    }

    public Date parseTimestamp(String source) throws ParseException {
        String monName = null;
        String dateStr = null;
        String hmsStr = null;
        String hourStr = null;
        String minStr = null;
        String secStr = null;
        StringTokenizer toker = new StringTokenizer(source, " ");
        int tokeCount = toker.countTokens();
        if (tokeCount != 3) {
            throw new ParseException("a valid timestamp has 3 fields, not " + tokeCount, 0);
        }
        try {
            monName = toker.nextToken();
        }
        catch (NoSuchElementException ex) {
            throw new ParseException("could not parse month name (field 1)", 0);
        }
        try {
            dateStr = toker.nextToken();
        }
        catch (NoSuchElementException ex) {
            throw new ParseException("could not parse day of month (field 2)", 0);
        }
        try {
            hmsStr = toker.nextToken();
        }
        catch (NoSuchElementException ex) {
            throw new ParseException("could not parse time hh:mm:ss (field 3)", 0);
        }
        toker = new StringTokenizer(hmsStr, ":");
        tokeCount = toker.countTokens();
        if (tokeCount != 3) {
            throw new ParseException("'" + hmsStr + "' is not a valid timestamp time string", 0);
        }
        try {
            hourStr = toker.nextToken();
        }
        catch (NoSuchElementException ex) {
            throw new ParseException("could not parse time hour (field 3.1)", 0);
        }
        try {
            minStr = toker.nextToken();
        }
        catch (NoSuchElementException ex) {
            throw new ParseException("could not parse time minute (field 3.2)", 0);
        }
        try {
            secStr = toker.nextToken();
        }
        catch (NoSuchElementException ex) {
            throw new ParseException("could not parse time second (field 3.3)", 0);
        }
        int month = 0;
        int date = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        try {
            month = this.monthNameToInt(monName);
        }
        catch (ParseException ex) {
            throw new ParseException("could not convert month name (field 1)", 0);
        }
        try {
            date = Integer.parseInt(dateStr);
        }
        catch (NumberFormatException ex) {
            throw new ParseException("could not convert month day (field 2)", 0);
        }
        if (date < 1 || date > 31) {
            throw new ParseException("month day '" + date + "' is out of range", 0);
        }
        try {
            hour = Integer.parseInt(hourStr);
        }
        catch (NumberFormatException ex) {
            throw new ParseException("could not convert hour (field 3.1) '" + hourStr + "' - " + ex.getMessage(), 0);
        }
        if (hour < 0 || hour > 24) {
            throw new ParseException("hour '" + hour + "' is out of range", 0);
        }
        try {
            minute = Integer.parseInt(minStr);
        }
        catch (NumberFormatException ex) {
            throw new ParseException("could not convert minute (field 3.2) '" + minStr + "' - " + ex.getMessage(), 0);
        }
        if (minute < 0 || minute > 59) {
            throw new ParseException("minute '" + minute + "' is out of range", 0);
        }
        try {
            second = Integer.parseInt(secStr);
        }
        catch (NumberFormatException ex) {
            throw new ParseException("could not convert second (field 3.3) '" + secStr + "' - " + ex.getMessage(), 0);
        }
        if (second < 0 || second > 59) {
            throw new ParseException("second '" + second + "' is out of range", 0);
        }
        Locale loc = Locale.US;
        TimeZone tz = TimeZone.getTimeZone(DEFAULT_GMT_TZID);
        Calendar cal = Calendar.getInstance(tz, loc);
        Date now = new Date();
        cal.setTime(now);
        cal.set(cal.get(1), month, date, hour, minute, second);
        SyslogTimeStamp.adjustYear(cal, now.toInstant().atZone(tz.toZoneId()).toLocalDateTime());
        Date result = new Date(cal.getTime().getTime());
        return result;
    }

    private int monthNameToInt(String name) throws ParseException {
        if (name.equalsIgnoreCase("Jan")) {
            return 0;
        }
        if (name.equalsIgnoreCase("Feb")) {
            return 1;
        }
        if (name.equalsIgnoreCase("Mar")) {
            return 2;
        }
        if (name.equalsIgnoreCase("Apr")) {
            return 3;
        }
        if (name.equalsIgnoreCase("May")) {
            return 4;
        }
        if (name.equalsIgnoreCase("Jun")) {
            return 5;
        }
        if (name.equalsIgnoreCase("Jul")) {
            return 6;
        }
        if (name.equalsIgnoreCase("Aug")) {
            return 7;
        }
        if (name.equalsIgnoreCase("Sep")) {
            return 8;
        }
        if (name.equalsIgnoreCase("Oct")) {
            return 9;
        }
        if (name.equalsIgnoreCase("Nov")) {
            return 10;
        }
        if (name.equalsIgnoreCase("Dec")) {
            return 11;
        }
        throw new ParseException("unknown month name '" + name + "'", 0);
    }

    public static void adjustYear(Calendar cal, LocalDateTime referenceTime) {
        LocalDateTime referenceDateTime = referenceTime == null ? LocalDateTime.now() : referenceTime;
        int referenceYear = referenceDateTime.getYear();
        cal.set(1, referenceYear);
        if (referenceDateTime.atZone(ZoneId.systemDefault()).toInstant().isBefore(cal.toInstant())) {
            cal.set(1, referenceYear - 1);
        }
    }
}

