/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.wsman;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.opennms.core.wsman.WSManVersion;

public class WSManEndpoint {
    private final URL url;
    private final String username;
    private final String password;
    private final boolean gssAuth;
    private final boolean strictSSL;
    private final WSManVersion serverVersion;
    private final Integer maxElements;
    private final Integer maxEnvelopeSize;
    private final Integer connectionTimeout;
    private final Integer receiveTimeout;

    private WSManEndpoint(Builder builder) {
        this.url = builder.url;
        this.username = builder.username;
        this.password = builder.password;
        this.gssAuth = builder.gssAuth;
        this.strictSSL = builder.strictSSL;
        this.serverVersion = builder.serverVersion;
        this.maxElements = builder.maxElements;
        this.maxEnvelopeSize = builder.maxEnvelopeSize;
        this.connectionTimeout = builder.connectionTimeout;
        this.receiveTimeout = builder.receiveTimeout;
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean isBasicAuth() {
        return !this.isGSSAuth() && this.username != null;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isGSSAuth() {
        return this.gssAuth;
    }

    public boolean isStrictSSL() {
        return this.strictSSL;
    }

    public WSManVersion getServerVersion() {
        return this.serverVersion;
    }

    public Integer getMaxElements() {
        return this.maxElements;
    }

    public Integer getMaxEnvelopeSize() {
        return this.maxEnvelopeSize;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Integer getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public String toString() {
        return String.format("WSManEndpoint[url='%s', isGSSAuth='%s', isBasicAuth='%s', isStrictSSL='%s', serverVersion='%s',  maxElements='%s', maxEnvelopeSize='%s'connectionTimeout='%s', receiveTimeout='%s']", new Object[]{this.url, this.isGSSAuth(), this.isBasicAuth(), this.isStrictSSL(), this.serverVersion, this.maxElements, this.maxEnvelopeSize, this.connectionTimeout, this.receiveTimeout});
    }

    public static class Builder {
        private final URL url;
        private boolean strictSSL = true;
        private String username;
        private String password;
        private boolean gssAuth = false;
        private WSManVersion serverVersion = WSManVersion.WSMAN_1_2;
        private Integer maxElements;
        private Integer maxEnvelopeSize;
        private Integer connectionTimeout;
        private Integer receiveTimeout;

        public Builder(String url) throws MalformedURLException {
            this(new URL(Objects.requireNonNull(url, "url cannot be null")));
        }

        public Builder(URL url) {
            this.url = Objects.requireNonNull(url, "url cannot be null");
        }

        public Builder withBasicAuth(String username, String password) {
            this.username = Objects.requireNonNull(username, "username cannot be null");
            this.password = Objects.requireNonNull(password, "password cannot be null");
            return this;
        }

        public Builder withGSSAuth() {
            this.gssAuth = true;
            return this;
        }

        public Builder withStrictSSL(boolean strictSSL) {
            this.strictSSL = strictSSL;
            return this;
        }

        public Builder withServerVersion(WSManVersion version) {
            this.serverVersion = Objects.requireNonNull(version, "version cannot be null");
            return this;
        }

        public Builder withMaxElements(Integer maxElements) {
            if (maxElements == null || maxElements < 1) {
                throw new IllegalArgumentException("maxElements must be strictly positive");
            }
            this.maxElements = maxElements;
            return this;
        }

        public Builder withMaxEnvelopeSize(Integer maxEnvelopeSize) {
            if (maxEnvelopeSize == null || maxEnvelopeSize < 1) {
                throw new IllegalArgumentException("maxEnvelopeSize must be strictly positive");
            }
            this.maxEnvelopeSize = maxEnvelopeSize;
            return this;
        }

        public Builder withConnectionTimeout(Integer connectionTimeout) {
            if (connectionTimeout == null || connectionTimeout < 0) {
                throw new IllegalArgumentException("connectionTimeout must be non-negative");
            }
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder withReceiveTimeout(Integer receiveTimeout) {
            if (receiveTimeout == null || receiveTimeout < 0) {
                throw new IllegalArgumentException("receiveTimeout must be non-negative");
            }
            this.receiveTimeout = receiveTimeout;
            return this;
        }

        public WSManEndpoint build() {
            return new WSManEndpoint(this);
        }
    }
}

