/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;
import org.json.JSONWriter;
import org.opennms.netmgt.snmp.InetAddrUtils;
import org.opennms.netmgt.snmp.InetAddrXmlAdapter;
import org.opennms.netmgt.snmp.SnmpConfiguration;

@XmlRootElement(name="snmpAgentConfig")
public class SnmpAgentConfig
extends SnmpConfiguration
implements Serializable {
    private static final long serialVersionUID = -6646744513933866811L;
    private InetAddress m_address;
    private InetAddress m_proxyFor;

    public SnmpAgentConfig() {
        this((InetAddress)null);
    }

    public SnmpAgentConfig(InetAddress agentAddress) {
        this(agentAddress, SnmpConfiguration.DEFAULTS);
    }

    public SnmpAgentConfig(InetAddress agentAddress, SnmpConfiguration defaults) {
        super(defaults);
        this.m_address = agentAddress;
    }

    public static SnmpAgentConfig parseProtocolConfigurationString(String protocolConfigString) {
        if (protocolConfigString == null) {
            throw new IllegalArgumentException("Protocol configuration string for SnmpAgentConfig must not be null.");
        }
        JSONObject protocolConfig = new JSONObject(new JSONTokener(protocolConfigString)).optJSONObject("snmp");
        if (protocolConfig == null) {
            throw new IllegalArgumentException("Invalid protocol configuration string for SnmpAgentConfig: Expected it to start with snmp object" + protocolConfigString);
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        Iterator keysItr = protocolConfig.keys();
        while (keysItr.hasNext()) {
            String key;
            attributes.put(key, protocolConfig.isNull(key = (String)keysItr.next()) ? null : protocolConfig.getString(key));
        }
        return SnmpAgentConfig.fromMap(attributes);
    }

    public String toProtocolConfigString() {
        JSONWriter writer = new JSONStringer().object().key("snmp").object();
        this.toMap().entrySet().stream().forEach(e -> writer.key((String)e.getKey()).value(e.getValue()));
        return writer.endObject().endObject().toString();
    }

    public String toString() {
        StringBuilder buff = new StringBuilder("SnmpAgentConfig[");
        buff.append("Address: " + InetAddrUtils.str(this.m_address));
        buff.append(", ProxyForAddress: " + InetAddrUtils.str(this.m_proxyFor));
        buff.append(", Port: " + this.getPort());
        buff.append(", Timeout: " + this.getTimeout());
        buff.append(", Retries: " + this.getRetries());
        buff.append(", MaxVarsPerPdu: " + this.getMaxVarsPerPdu());
        buff.append(", MaxRepetitions: " + this.getMaxRepetitions());
        buff.append(", MaxRequestSize: " + this.getMaxRequestSize());
        buff.append(", Version: " + SnmpAgentConfig.versionToString(this.getVersion()));
        if (this.isVersion3()) {
            buff.append(", SecurityLevel: " + this.getSecurityLevel());
            buff.append(", SecurityName: " + this.getSecurityName());
            buff.append(", AuthPassPhrase: XXXXXXXX");
            buff.append(", AuthProtocol: " + this.getAuthProtocol());
            buff.append(", PrivPassphrase: XXXXXXXX");
            buff.append(", PrivProtocol: " + this.getPrivProtocol());
            buff.append(", ContextName: " + this.getContextName());
            buff.append(", EngineId: " + this.getEngineId());
            buff.append(", ContextEngineId: " + this.getContextEngineId());
            buff.append(", EnterpriseId:" + this.getEnterpriseId());
        } else {
            buff.append(", ReadCommunity: XXXXXXXX");
            buff.append(", WriteCommunity: XXXXXXXX");
        }
        buff.append("]");
        return buff.toString();
    }

    @XmlJavaTypeAdapter(value=InetAddrXmlAdapter.class)
    public InetAddress getAddress() {
        return this.m_address;
    }

    public void setAddress(InetAddress address) {
        this.m_address = address;
    }

    @XmlJavaTypeAdapter(value=InetAddrXmlAdapter.class)
    public InetAddress getProxyFor() {
        return this.m_proxyFor;
    }

    public void setProxyFor(InetAddress address) {
        this.m_proxyFor = address;
    }

    @XmlTransient
    public InetAddress getEffectiveAddress() {
        if (this.m_proxyFor == null) {
            return this.m_address;
        }
        return this.m_proxyFor;
    }

    public int hashCode() {
        int hash = Objects.hash(this.getAddress(), this.getProxyFor(), this.getPort(), this.getTimeout(), this.getRetries(), this.getMaxVarsPerPdu(), this.getMaxRepetitions(), this.getMaxRequestSize(), this.getVersion(), this.getSecurityLevel(), this.getSecurityName(), this.getAuthPassPhrase(), this.getAuthProtocol(), this.getPrivPassPhrase(), this.getPrivProtocol(), this.getContextName(), this.getEngineId(), this.getContextEngineId(), this.getEnterpriseId(), this.getReadCommunity(), this.getWriteCommunity());
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            System.err.println("obj = null!");
            return false;
        }
        if (obj instanceof SnmpAgentConfig) {
            SnmpAgentConfig other = (SnmpAgentConfig)obj;
            return Objects.equals(this.getAddress(), other.getAddress()) && Objects.equals(this.getProxyFor(), other.getProxyFor()) && Objects.equals(this.getPort(), other.getPort()) && Objects.equals(this.getTimeout(), other.getTimeout()) && Objects.equals(this.getRetries(), other.getRetries()) && Objects.equals(this.getMaxRepetitions(), other.getMaxRepetitions()) && Objects.equals(this.getMaxRequestSize(), other.getMaxRequestSize()) && Objects.equals(this.getMaxVarsPerPdu(), other.getMaxVarsPerPdu()) && Objects.equals(this.getVersion(), other.getVersion()) && Objects.equals(this.getSecurityLevel(), other.getSecurityLevel()) && Objects.equals(this.getSecurityName(), other.getSecurityName()) && Objects.equals(this.getAuthPassPhrase(), other.getAuthPassPhrase()) && Objects.equals(this.getAuthProtocol(), other.getAuthProtocol()) && Objects.equals(this.getPrivPassPhrase(), other.getPrivPassPhrase()) && Objects.equals(this.getPrivProtocol(), other.getPrivProtocol()) && Objects.equals(this.getEngineId(), other.getEngineId()) && Objects.equals(this.getContextEngineId(), other.getContextEngineId()) && Objects.equals(this.getEnterpriseId(), other.getEnterpriseId()) && Objects.equals(this.getReadCommunity(), other.getReadCommunity()) && Objects.equals(this.getWriteCommunity(), other.getWriteCommunity());
        }
        return false;
    }

    public Map<String, String> toMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("address", this.m_address == null ? null : InetAddrUtils.str(this.m_address));
        map.put("proxyFor", this.m_proxyFor == null ? null : InetAddrUtils.str(this.m_proxyFor));
        map.put("port", Integer.toString(this.getPort()));
        map.put("timeout", Integer.toString(this.getTimeout()));
        map.put("retries", Integer.toString(this.getRetries()));
        map.put("max-vars-per-pdu", Integer.toString(this.getMaxVarsPerPdu()));
        map.put("max-repetitions", Integer.toString(this.getMaxRepetitions()));
        map.put("max-request-size", Integer.toString(this.getMaxRequestSize()));
        map.put("version", Integer.toString(this.getVersion()));
        map.put("security-level", Integer.toString(this.getSecurityLevel()));
        map.put("security-name", this.getSecurityName());
        map.put("auth-passphrase", this.getAuthPassPhrase());
        map.put("auth-protocol", this.getAuthProtocol());
        map.put("priv-passphrase", this.getPrivPassPhrase());
        map.put("priv-protocol", this.getPrivProtocol());
        map.put("context-name", this.getContextName());
        map.put("engine-id", this.getEngineId());
        map.put("context-engine-id", this.getContextEngineId());
        map.put("enterprise-id", this.getEnterpriseId());
        map.put("read-community", this.getReadCommunity());
        map.put("write-community", this.getWriteCommunity());
        return map;
    }

    public static SnmpAgentConfig fromMap(Map<String, String> map) {
        SnmpAgentConfig config = new SnmpAgentConfig();
        if (map.get("address") != null) {
            config.setAddress(InetAddrUtils.addr(map.get("address")));
        }
        if (map.get("proxyFor") != null) {
            config.setProxyFor(InetAddrUtils.addr(map.get("proxyFor")));
        }
        if (map.get("port") != null) {
            config.setPort(Integer.parseInt(map.get("port")));
        }
        if (map.get("timeout") != null) {
            config.setTimeout(Integer.parseInt(map.get("timeout")));
        }
        if (map.get("retries") != null) {
            config.setRetries(Integer.parseInt(map.get("retries")));
        }
        if (map.get("max-vars-per-pdu") != null) {
            config.setMaxVarsPerPdu(Integer.parseInt(map.get("max-vars-per-pdu")));
        }
        if (map.get("max-repetitions") != null) {
            config.setMaxRepetitions(Integer.parseInt(map.get("max-repetitions")));
        }
        if (map.get("max-request-size") != null) {
            config.setMaxRequestSize(Integer.parseInt(map.get("max-request-size")));
        }
        if (map.get("version") != null) {
            config.setVersion(Integer.parseInt(map.get("version")));
        }
        if (map.get("security-level") != null) {
            config.setSecurityLevel(Integer.parseInt(map.get("security-level")));
        }
        if (map.get("security-name") != null) {
            config.setSecurityName(map.get("security-name"));
        }
        if (map.get("auth-passphrase") != null) {
            config.setAuthPassPhrase(map.get("auth-passphrase"));
        }
        if (map.get("auth-protocol") != null) {
            config.setAuthProtocol(map.get("auth-protocol"));
        }
        if (map.get("priv-passphrase") != null) {
            config.setPrivPassPhrase(map.get("priv-passphrase"));
        }
        if (map.get("priv-protocol") != null) {
            config.setPrivProtocol(map.get("priv-protocol"));
        }
        if (map.get("context-name") != null) {
            config.setContextName(map.get("context-name"));
        }
        if (map.get("engine-id") != null) {
            config.setEngineId(map.get("engine-id"));
        }
        if (map.get("context-engine-id") != null) {
            config.setContextEngineId(map.get("context-engine-id"));
        }
        if (map.get("enterprise-id") != null) {
            config.setEnterpriseId(map.get("enterprise-id"));
        }
        if (map.get("read-community") != null) {
            config.setReadCommunity(map.get("read-community"));
        }
        if (map.get("write-community") != null) {
            config.setWriteCommunity(map.get("write-community"));
        }
        return config;
    }
}

