/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.PrintStream;
import java.util.Properties;
import kafka.admin.AdminClient;
import kafka.admin.AdminClient$;
import kafka.admin.DeleteRecordsCommand;
import kafka.common.AdminCommandFailedException;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeLong$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DeleteRecordsCommand$ {
    public static final DeleteRecordsCommand$ MODULE$;

    static {
        new DeleteRecordsCommand$();
    }

    public void main(String[] args) {
        this.execute(args, System.out);
    }

    public Seq<Tuple2<TopicPartition, Object>> parseOffsetJsonStringWithoutDedup(String jsonData) {
        return (Seq)Option$.MODULE$.option2Iterable(Json$.MODULE$.parseFull(jsonData)).toSeq().flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Tuple2<TopicPartition, Object>> apply(JsonValue js) {
                return (Seq)Option$.MODULE$.option2Iterable(js.asJsonObject().get("partitions")).toSeq().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Buffer<Tuple2<TopicPartition, Object>> apply(JsonValue partitionsJs) {
                        return partitionsJs.asJsonArray().iterator().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final JsonObject apply(JsonValue x$1) {
                                return x$1.asJsonObject();
                            }
                        }).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<TopicPartition, Object> apply(JsonObject partitionJs) {
                                String topic = partitionJs.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
                                int partition = BoxesRunTime.unboxToInt((Object)partitionJs.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
                                long offset2 = BoxesRunTime.unboxToLong((Object)partitionJs.apply("offset").to(DecodeJson$DecodeLong$.MODULE$));
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, partition)), (Object)BoxesRunTime.boxToLong((long)offset2));
                            }
                        }).toBuffer();
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public void execute(String[] args, PrintStream out) {
        DeleteRecordsCommand.DeleteRecordsCommandOptions opts = new DeleteRecordsCommand.DeleteRecordsCommandOptions(args);
        AdminClient adminClient = this.createAdminClient(opts);
        String offsetJsonFile = (String)opts.options().valueOf(opts.offsetJsonFileOpt());
        String offsetJsonString = Utils.readFileAsString((String)offsetJsonFile);
        Seq<Tuple2<TopicPartition, Object>> offsetSeq = this.parseOffsetJsonStringWithoutDedup(offsetJsonString);
        Iterable duplicatePartitions = CoreUtils$.MODULE$.duplicates((Traversable)offsetSeq.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TopicPartition apply(Tuple2<TopicPartition, Object> x0$1) {
                Tuple2<TopicPartition, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp;
                    TopicPartition topicPartition = tp = (TopicPartition)tuple2._1();
                    return topicPartition;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom()));
        if (duplicatePartitions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Offset json file contains duplicate topic partitions: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicatePartitions.mkString(",")})));
        }
        out.println("Executing records delete operation");
        Map<TopicPartition, AdminClient.DeleteRecordsResult> deleteRecordsResult = adminClient.deleteRecordsBefore((Map<TopicPartition, Object>)offsetSeq.toMap(Predef$.MODULE$.$conforms())).get();
        out.println("Records delete operation completed:");
        deleteRecordsResult.foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final PrintStream out$1;

            public final void apply(Tuple2<TopicPartition, AdminClient.DeleteRecordsResult> x0$2) {
                Tuple2<TopicPartition, AdminClient.DeleteRecordsResult> tuple2 = x0$2;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    AdminClient.DeleteRecordsResult partitionResult = (AdminClient.DeleteRecordsResult)tuple2._2();
                    if (partitionResult.error() == null) {
                        this.out$1.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition: ", "\\tlow_watermark: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, BoxesRunTime.boxToLong((long)partitionResult.lowWatermark())})));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.out$1.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition: ", "\\terror: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, partitionResult.error().toString()})));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.out$1 = out$1;
            }
        });
        adminClient.close();
    }

    private AdminClient createAdminClient(DeleteRecordsCommand.DeleteRecordsCommandOptions opts) {
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt()))) : new Properties();
        props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
        return AdminClient$.MODULE$.create(props);
    }

    private DeleteRecordsCommand$() {
        MODULE$ = this;
    }
}

