/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.common.aws.sqs;

import com.amazonaws.regions.Regions;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.core.ipc.common.aws.sqs.AmazonSQSConfig;
import org.opennms.core.ipc.common.aws.sqs.AmazonSQSQueueConfig;

public class MapBasedSQSConfig
implements AmazonSQSConfig {
    public static final String DEFAULT_REGION = Regions.US_EAST_1.getName();
    private final String queuePrefix;
    private final Regions region;
    private final String accessKey;
    private final String secretKey;
    private final boolean useHttp;
    private final AmazonSQSQueueConfig sinkQueueConfig;
    private final AmazonSQSQueueConfig rpcQueueConfig;

    public MapBasedSQSConfig() {
        this(MapBasedSQSConfig.getConfigMapFromSystemProperties());
    }

    public MapBasedSQSConfig(Map<String, String> sqsConfig) {
        this.queuePrefix = sqsConfig.get("aws_queue_name_prefix");
        this.region = Regions.fromName((String)sqsConfig.getOrDefault("aws_region", DEFAULT_REGION));
        this.accessKey = sqsConfig.get("aws_access_key_id");
        this.secretKey = sqsConfig.get("aws_secret_access_key");
        this.useHttp = Boolean.TRUE.toString().equals(sqsConfig.get("aws_use_http"));
        this.sinkQueueConfig = new AmazonSQSQueueConfig(MapBasedSQSConfig.filterKeysByPrefix(sqsConfig, "sink."));
        this.rpcQueueConfig = new AmazonSQSQueueConfig(MapBasedSQSConfig.filterKeysByPrefix(sqsConfig, "rpc."));
    }

    protected static Map<String, String> getConfigMapFromSystemProperties() {
        return MapBasedSQSConfig.filterKeysByPrefix(System.getProperties().entrySet(), "org.opennms.core.ipc.aws.sqs.");
    }

    @Override
    public String getQueuePrefix() {
        return this.queuePrefix;
    }

    @Override
    public Regions getRegion() {
        return this.region;
    }

    @Override
    public boolean hasStaticCredentials() {
        return this.accessKey != null && this.secretKey != null;
    }

    @Override
    public String getAccessKey() {
        return this.accessKey;
    }

    @Override
    public String getSecretKey() {
        return this.secretKey;
    }

    @Override
    public boolean isUseHttp() {
        return this.useHttp;
    }

    @Override
    public AmazonSQSQueueConfig getSinkQueueConfig() {
        return this.sinkQueueConfig;
    }

    @Override
    public AmazonSQSQueueConfig getRpcQueueConfig() {
        return this.rpcQueueConfig;
    }

    public String toString() {
        return "MapBasedSQSConfig{queuePrefix='" + this.queuePrefix + '\'' + ", region='" + this.region + '\'' + ", accessKey='" + this.accessKey != null ? "********" : (this.accessKey + '\'' + ", secretKey='" + this.secretKey != null ? "********" : this.secretKey + '\'' + ", useHttp=" + this.useHttp + ", sinkQueueConfig=" + this.sinkQueueConfig + ", rpcQueueConfig=" + this.rpcQueueConfig + '}');
    }

    private static Map<String, String> filterKeysByPrefix(Map<String, String> map, String prefix) {
        return MapBasedSQSConfig.filterKeysByPrefix(map.entrySet(), prefix);
    }

    private static <K, V> Map<String, String> filterKeysByPrefix(Set<Map.Entry<K, V>> entrySet, String prefix) {
        return entrySet.stream().filter(e -> e.getKey() != null && e.getKey() instanceof String).filter(e -> e.getValue() == null || e.getValue() instanceof String).map(e -> e).filter(e -> ((String)e.getKey()).startsWith(prefix)).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(prefix.length(), ((String)e.getKey()).length()), e -> (String)e.getValue()));
    }
}

