/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.aws.sqs;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.AmazonSQSException;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import org.opennms.core.ipc.common.aws.sqs.AmazonSQSManager;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.ipc.sink.aws.sqs.AmazonSQSLocalMessageDispatcherFactory;
import org.opennms.core.ipc.sink.common.AbstractMessageDispatcherFactory;
import org.opennms.core.logging.Logging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonSQSRemoteMessageDispatcherFactory
extends AbstractMessageDispatcherFactory<String> {
    private static final Logger LOG = LoggerFactory.getLogger(AmazonSQSRemoteMessageDispatcherFactory.class);
    private JmxReporter reporter;
    private AmazonSQS sqs;
    private AmazonSQSManager awsSqsManager;

    public <S extends Message, T extends Message> void dispatch(SinkModule<S, T> module, String topic, T message) {
        try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"ipc");){
            LOG.trace("dispatch({}): sending message {}", (Object)topic, message);
            try {
                String queueUrl = this.awsSqsManager.getSinkQueueUrlAndCreateIfNecessary(module.getId());
                String messageId = this.awsSqsManager.sendMessage(queueUrl, module.marshal(message));
                LOG.debug("SQS Message with ID {} has been successfully sent to {}", (Object)messageId, (Object)queueUrl);
            }
            catch (InterruptedException ex) {
                LOG.warn("Interrupted while trying to send message. Aborting.", (Throwable)ex);
            }
            catch (RuntimeException ex) {
                LOG.error("Unexpected AWS SDK exception while sending a message. Aborting.", (Throwable)ex);
            }
        }
    }

    public void init() throws IOException {
        try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"ipc");){
            this.registerJmxReporter();
            try {
                this.sqs = this.awsSqsManager.getSQSClient();
            }
            catch (AmazonSQSException e) {
                LOG.error("Can't create an AmazonSQS Object", (Throwable)e);
            }
        }
    }

    private void registerJmxReporter() {
        if (this.reporter == null) {
            this.reporter = JmxReporter.forRegistry((MetricRegistry)this.getMetrics()).inDomain(AmazonSQSLocalMessageDispatcherFactory.class.getPackage().getName()).build();
            this.reporter.start();
        }
    }

    public void destroy() {
        if (this.reporter != null) {
            this.reporter.close();
            this.reporter = null;
        }
        this.sqs.shutdown();
    }

    public void setAwsSqsManager(AmazonSQSManager awsSqsManager) {
        this.awsSqsManager = awsSqsManager;
    }
}

