/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.aws.sqs;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.AmazonSQSException;
import com.amazonaws.services.sqs.model.Message;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opennms.core.ipc.common.aws.sqs.AmazonSQSManager;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.ipc.sink.common.AbstractMessageConsumerManager;
import org.opennms.core.logging.Logging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonSQSMessageConsumerManager
extends AbstractMessageConsumerManager {
    private static final Logger LOG = LoggerFactory.getLogger(AmazonSQSMessageConsumerManager.class);
    private final Map<SinkModule<?, org.opennms.core.ipc.sink.api.Message>, List<AwsConsumerRunner>> consumerRunnersByModule = new ConcurrentHashMap();
    private final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("sqs-consumer-%d").build();
    private final ExecutorService executor = Executors.newCachedThreadPool(this.threadFactory);
    private AmazonSQSManager awsSqsManager;

    public void setAwsSqsManager(AmazonSQSManager awsSqsManager) {
        this.awsSqsManager = awsSqsManager;
    }

    protected void startConsumingForModule(SinkModule<?, org.opennms.core.ipc.sink.api.Message> module) throws Exception {
        if (!this.consumerRunnersByModule.containsKey(module)) {
            LOG.info("Starting consumers for module: {}", module);
            int numConsumerThreads = AmazonSQSMessageConsumerManager.getNumConsumerThreads(module);
            ArrayList<AwsConsumerRunner> consumerRunners = new ArrayList<AwsConsumerRunner>(numConsumerThreads);
            for (int i = 0; i < numConsumerThreads; ++i) {
                AwsConsumerRunner consumerRunner = new AwsConsumerRunner(module);
                this.executor.execute(consumerRunner);
                consumerRunners.add(new AwsConsumerRunner(module));
            }
            this.consumerRunnersByModule.put(module, consumerRunners);
        }
    }

    protected void stopConsumingForModule(SinkModule<?, org.opennms.core.ipc.sink.api.Message> module) throws Exception {
        if (this.consumerRunnersByModule.containsKey(module)) {
            LOG.info("Stopping consumers for module: {}", module);
            List<AwsConsumerRunner> consumerRunners = this.consumerRunnersByModule.get(module);
            for (AwsConsumerRunner consumerRunner : consumerRunners) {
                consumerRunner.shutdown();
            }
            this.consumerRunnersByModule.remove(module);
        }
    }

    private class AwsConsumerRunner
    implements Runnable {
        private final SinkModule<?, org.opennms.core.ipc.sink.api.Message> module;
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private final AmazonSQS sqs;
        private String queueUrl;

        public AwsConsumerRunner(SinkModule<?, org.opennms.core.ipc.sink.api.Message> module) throws AmazonSQSException {
            this.module = module;
            this.sqs = AmazonSQSMessageConsumerManager.this.awsSqsManager.getSQSClient();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Logging.putPrefix((String)"ipc");
            try {
                LOG.debug("Retrieving queue URL for module with id: {}", (Object)this.module.getId());
                this.queueUrl = AmazonSQSMessageConsumerManager.this.awsSqsManager.getSinkQueueUrlAndCreateIfNecessary(this.module.getId());
                LOG.debug("Using queue URL: {}", (Object)this.queueUrl);
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted while retrieving queue URL. Aborting consumer.", (Throwable)e);
            }
            while (!this.closed.get()) {
                List messages = null;
                try {
                    messages = this.sqs.receiveMessage(this.queueUrl).getMessages();
                }
                catch (RuntimeException e) {
                    LOG.error("Unexpected exception while receiving messages from " + this.queueUrl, (Throwable)e);
                }
                if (messages == null) continue;
                for (Message m : messages) {
                    try {
                        LOG.debug("Received SQS message with ID {} from {}", (Object)m.getMessageId(), (Object)this.queueUrl);
                        org.opennms.core.ipc.sink.api.Message msg = this.module.unmarshal(m.getBody());
                        AmazonSQSMessageConsumerManager.this.dispatch(this.module, msg);
                        LOG.debug("Message with ID {} successfully dispatched.", (Object)m.getMessageId(), (Object)this.queueUrl);
                    }
                    catch (RuntimeException e) {
                        String msg = String.format("Unexpected exception while dispatching message with ID %s from %s", m.getMessageId(), this.queueUrl);
                        LOG.warn(msg, (Throwable)e);
                    }
                    finally {
                        LOG.debug("Deleting SQS message receipt handle {} from {}", (Object)m.getReceiptHandle(), (Object)this.queueUrl);
                        this.sqs.deleteMessage(this.queueUrl, m.getReceiptHandle());
                    }
                }
            }
        }

        public void shutdown() {
            this.closed.set(true);
            this.sqs.shutdown();
        }
    }
}

