/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.request;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jolokia.client.request.J4pResponse;
import org.jolokia.client.request.J4pTargetConfig;
import org.jolokia.client.request.J4pType;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class J4pRequest {
    private J4pType type;
    private String preferredHttpMethod;
    private J4pTargetConfig targetConfig;
    private static final Pattern SLASH_ESCAPE_PATTERN = Pattern.compile("((?:[^!/]|!.)*)(?:/|$)");
    private static final Pattern UNESCAPE_PATTERN = Pattern.compile("!(.)");

    protected J4pRequest(J4pType pType, J4pTargetConfig pTargetConfig) {
        this.type = pType;
        this.targetConfig = pTargetConfig;
    }

    public static String escape(String pInput) {
        return pInput.replaceAll("!", "!!").replaceAll("/", "!/");
    }

    public J4pType getType() {
        return this.type;
    }

    public J4pTargetConfig getTargetConfig() {
        return this.targetConfig;
    }

    public String getPreferredHttpMethod() {
        return this.preferredHttpMethod;
    }

    public void setPreferredHttpMethod(String pPreferredHttpMethod) {
        this.preferredHttpMethod = pPreferredHttpMethod != null ? pPreferredHttpMethod.toUpperCase() : null;
    }

    abstract List<String> getRequestParts();

    JSONObject toJson() {
        JSONObject ret = new JSONObject();
        ret.put((Object)"type", (Object)this.type.name());
        if (this.targetConfig != null) {
            ret.put((Object)"target", (Object)this.targetConfig.toJson());
        }
        return ret;
    }

    abstract <R extends J4pResponse<? extends J4pRequest>> R createResponse(JSONObject var1);

    protected void addPath(List<String> pParts, String pPath) {
        if (pPath != null) {
            pParts.addAll(this.splitPath(pPath));
        }
    }

    protected String serializeArgumentToRequestPart(Object pArg) {
        if (pArg != null) {
            if (pArg.getClass().isArray()) {
                return this.getArrayForArgument((Object[])pArg);
            }
            if (List.class.isAssignableFrom(pArg.getClass())) {
                List list = (List)pArg;
                Object[] args = new Object[list.size()];
                int i = 0;
                for (Object e : list) {
                    args[i++] = e;
                }
                return this.getArrayForArgument(args);
            }
        }
        return this.nullEscape(pArg);
    }

    protected Object serializeArgumentToJson(Object pArg) {
        if (pArg == null) {
            return null;
        }
        if (pArg instanceof JSONAware) {
            return pArg;
        }
        if (pArg.getClass().isArray()) {
            return this.serializeArray(pArg);
        }
        if (pArg instanceof Map) {
            return this.serializeMap((Map)pArg);
        }
        if (pArg instanceof Collection) {
            return this.serializeCollection((Collection)pArg);
        }
        return pArg instanceof Number || pArg instanceof Boolean ? pArg : pArg.toString();
    }

    protected List<String> splitPath(String pArg) {
        ArrayList<String> ret = new ArrayList<String>();
        if (pArg != null) {
            Matcher m = SLASH_ESCAPE_PATTERN.matcher(pArg);
            while (m.find() && m.start(1) != pArg.length()) {
                ret.add(UNESCAPE_PATTERN.matcher(m.group(1)).replaceAll("$1"));
            }
        }
        return ret;
    }

    private Object serializeCollection(Collection pArg) {
        JSONArray array = new JSONArray();
        for (Object value : pArg) {
            array.add(this.serializeArgumentToJson(value));
        }
        return array;
    }

    private Object serializeMap(Map pArg) {
        JSONObject map = new JSONObject();
        for (Map.Entry entry : pArg.entrySet()) {
            map.put(entry.getKey(), this.serializeArgumentToJson(entry.getValue()));
        }
        return map;
    }

    private Object serializeArray(Object pArg) {
        JSONArray innerArray = new JSONArray();
        for (int i = 0; i < Array.getLength(pArg); ++i) {
            innerArray.add(this.serializeArgumentToJson(Array.get(pArg, i)));
        }
        return innerArray;
    }

    private String getArrayForArgument(Object[] pArg) {
        StringBuilder inner = new StringBuilder();
        for (int i = 0; i < pArg.length; ++i) {
            inner.append(this.nullEscape(pArg[i]));
            if (i >= pArg.length - 1) continue;
            inner.append(",");
        }
        return inner.toString();
    }

    private String nullEscape(Object pArg) {
        if (pArg == null) {
            return "[null]";
        }
        if (pArg instanceof String && ((String)pArg).length() == 0) {
            return "\"\"";
        }
        if (pArg instanceof JSONAware) {
            return ((JSONAware)pArg).toJSONString();
        }
        return pArg.toString();
    }
}

