/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.topology;

import java.util.Set;
import org.opennms.netmgt.model.topology.BridgePort;
import org.opennms.netmgt.model.topology.BridgeTopologyException;
import org.opennms.netmgt.model.topology.Topology;

public class BridgePortWithMacs
implements Topology {
    private final BridgePort m_port;
    private final Set<String> m_macs;

    public static BridgePortWithMacs create(BridgePort port, Set<String> macs) throws BridgeTopologyException {
        if (port == null) {
            throw new BridgeTopologyException("cannot create BridgePortWithMacs bridge port is null");
        }
        if (macs == null) {
            throw new BridgeTopologyException("cannot create BridgePortWithMacs macs is null");
        }
        return new BridgePortWithMacs(port, macs);
    }

    private BridgePortWithMacs(BridgePort port, Set<String> macs) {
        this.m_port = port;
        this.m_macs = macs;
    }

    public BridgePort getPort() {
        return this.m_port;
    }

    public Set<String> getMacs() {
        return this.m_macs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_port == null ? 0 : this.m_port.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BridgePortWithMacs other = (BridgePortWithMacs)obj;
        return !(this.m_port == null ? other.m_port != null : !this.m_port.equals(other.m_port));
    }

    @Override
    public String printTopology() {
        StringBuffer strbfr = new StringBuffer();
        strbfr.append(this.m_port.printTopology());
        strbfr.append(" macs:");
        strbfr.append(this.m_macs);
        return strbfr.toString();
    }
}

