/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.topology;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.BridgeElement;
import org.opennms.netmgt.model.topology.BroadcastDomain;
import org.opennms.netmgt.model.topology.Topology;

public class Bridge
implements Topology {
    final Integer m_nodeId;
    Integer m_rootPort;
    boolean m_isRootBridge;
    Set<String> m_identifiers = new HashSet<String>();
    String m_designated;

    public static Set<String> getIdentifier(List<BridgeElement> elems) {
        HashSet<String> identifiers = new HashSet<String>();
        for (BridgeElement element : elems) {
            if (!InetAddressUtils.isValidBridgeAddress((String)element.getBaseBridgeAddress())) continue;
            identifiers.add(element.getBaseBridgeAddress());
        }
        return identifiers;
    }

    public static String getDesignated(List<BridgeElement> elems) {
        for (BridgeElement element : elems) {
            String designated;
            if (!InetAddressUtils.isValidStpBridgeId((String)element.getStpDesignatedRoot()) || element.getBaseBridgeAddress().equals(InetAddressUtils.getBridgeAddressFromStpBridgeId((String)element.getStpDesignatedRoot())) || !InetAddressUtils.isValidBridgeAddress((String)(designated = InetAddressUtils.getBridgeAddressFromStpBridgeId((String)element.getStpDesignatedRoot())))) continue;
            return designated;
        }
        return null;
    }

    public static Bridge create(BroadcastDomain domain, Integer nodeid) {
        Bridge bridge = new Bridge(nodeid);
        domain.getBridges().add(bridge);
        return bridge;
    }

    public static Bridge createRootBridge(BroadcastDomain domain, Integer nodeid) {
        Bridge bridge = new Bridge(nodeid);
        bridge.setRootBridge();
        domain.getBridges().add(bridge);
        return bridge;
    }

    public static Bridge create(BroadcastDomain domain, Integer nodeid, Integer rootport) {
        Bridge bridge = new Bridge(nodeid);
        bridge.setRootPort(rootport);
        domain.getBridges().add(bridge);
        return bridge;
    }

    private Bridge(Integer id) {
        this.m_nodeId = id;
    }

    public Integer getRootPort() {
        return this.m_rootPort;
    }

    public boolean isNewTopology() {
        if (this.m_rootPort != null) {
            return false;
        }
        return !this.m_isRootBridge;
    }

    public void setRootPort(Integer rootPort) {
        this.m_rootPort = rootPort;
        this.m_isRootBridge = false;
    }

    public boolean isRootBridge() {
        return this.m_isRootBridge;
    }

    public void setRootBridge() {
        this.m_isRootBridge = true;
        this.m_rootPort = null;
    }

    public Integer getNodeId() {
        return this.m_nodeId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_nodeId == null ? 0 : this.m_nodeId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bridge other = (Bridge)obj;
        return !(this.m_nodeId == null ? other.m_nodeId != null : !this.m_nodeId.equals(other.m_nodeId));
    }

    @Override
    public String printTopology() {
        StringBuffer strbfr = new StringBuffer();
        strbfr.append("bridge: nodeid[");
        strbfr.append(this.m_nodeId);
        strbfr.append("],");
        if (this.m_isRootBridge) {
            strbfr.append(" isRootBridge,");
        } else {
            strbfr.append(" designated port:[");
            strbfr.append(this.m_rootPort);
            strbfr.append("],");
        }
        strbfr.append(" designated:[");
        strbfr.append(this.m_designated);
        strbfr.append("], identifiers:");
        strbfr.append(this.m_identifiers);
        return strbfr.toString();
    }

    public Set<String> getIdentifiers() {
        return this.m_identifiers;
    }

    public void setIdentifiers(Set<String> identifiers) {
        this.m_identifiers = identifiers;
    }

    public String getDesignated() {
        return this.m_designated;
    }

    public void setDesignated(String designated) {
        this.m_designated = designated;
    }

    public void clear() {
        this.m_identifiers.clear();
        this.m_designated = null;
    }
}

