/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.hibernate.annotations.Type;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.core.style.ToStringCreator;

@Entity
@Table(name="ipNetToMedia")
public class IpNetToMedia
implements Serializable {
    private static final long serialVersionUID = 7750043250236397014L;
    private Integer m_id;
    private InetAddress m_netAddress;
    private String m_physAddress;
    private IpNetToMediaType m_ipNetToMediaType;
    private OnmsNode m_sourceNode;
    private Integer m_sourceIfIndex;
    private Date m_createTime = new Date();
    private Date m_lastPollTime;

    @Id
    @Column(nullable=false)
    @XmlTransient
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @Column(name="netAddress", nullable=false)
    @Type(type="org.opennms.netmgt.model.InetAddressUserType")
    public InetAddress getNetAddress() {
        return this.m_netAddress;
    }

    public void setNetAddress(InetAddress netAddress) {
        this.m_netAddress = netAddress;
    }

    @Column(name="physAddress", length=32, nullable=false)
    public String getPhysAddress() {
        return this.m_physAddress;
    }

    public void setPhysAddress(String physAddr) {
        this.m_physAddress = physAddr;
    }

    @Transient
    public IpNetToMediaType getIpNetToMediaType() {
        return this.m_ipNetToMediaType;
    }

    public void setIpNetToMediaType(IpNetToMediaType ipNetToMediaType) {
        this.m_ipNetToMediaType = ipNetToMediaType;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="sourceNodeId", nullable=false)
    public OnmsNode getSourceNode() {
        return this.m_sourceNode;
    }

    public void setSourceNode(OnmsNode sourceNode) {
        this.m_sourceNode = sourceNode;
    }

    @Column(name="sourceIfIndex", nullable=false)
    public Integer getSourceIfIndex() {
        return this.m_sourceIfIndex;
    }

    public void setSourceIfIndex(Integer ifIndex) {
        this.m_sourceIfIndex = ifIndex;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="createTime", nullable=false)
    public Date getCreateTime() {
        return this.m_createTime;
    }

    public void setCreateTime(Date lastPoll) {
        this.m_createTime = lastPoll;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lastPollTime", nullable=false)
    public Date getLastPollTime() {
        return this.m_lastPollTime;
    }

    public void setLastPollTime(Date lastPoll) {
        this.m_lastPollTime = lastPoll;
    }

    public void merge(IpNetToMedia element) {
        this.setSourceNode(element.getSourceNode());
        this.setSourceIfIndex(element.getSourceIfIndex());
        this.setLastPollTime(element.getCreateTime());
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("ipaddr", (Object)this.getNetAddress()).append("physaddr", (Object)this.getPhysAddress()).append("sourcenode", (Object)this.getSourceNode()).append("sourceifindex", (Object)this.getSourceIfIndex()).append("createTime", (Object)this.getCreateTime()).append("lastPollTime", (Object)this.getLastPollTime()).toString();
    }

    public static enum IpNetToMediaType {
        IPNETTOMEDIA_TYPE_OTHER(1),
        IPNETTOMEDIA_TYPE_INVALID(2),
        IPNETTOMEDIA_TYPE_DYNAMIC(3),
        IPNETTOMEDIA_TYPE_STATIC(4);

        private int m_value;
        protected static final Map<Integer, String> s_typeMap;

        private IpNetToMediaType(int value) {
            this.m_value = value;
        }

        public static String getTypeString(Integer code) {
            if (s_typeMap.containsKey(code)) {
                return s_typeMap.get(code);
            }
            return null;
        }

        public static IpNetToMediaType get(Integer code) {
            if (code == null) {
                return null;
            }
            switch (code) {
                case 1: {
                    return IPNETTOMEDIA_TYPE_OTHER;
                }
                case 2: {
                    return IPNETTOMEDIA_TYPE_INVALID;
                }
                case 3: {
                    return IPNETTOMEDIA_TYPE_DYNAMIC;
                }
                case 4: {
                    return IPNETTOMEDIA_TYPE_STATIC;
                }
            }
            return null;
        }

        public Integer getValue() {
            return this.m_value;
        }

        static {
            s_typeMap = new HashMap<Integer, String>();
            s_typeMap.put(1, "other");
            s_typeMap.put(2, "invalid");
            s_typeMap.put(3, "dynamic");
            s_typeMap.put(4, "static");
        }
    }
}

