/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.proxy.common;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.proxy.SNMPRequestBuilder;
import org.opennms.netmgt.snmp.proxy.common.LocationAwareSnmpClientRpcImpl;
import org.opennms.netmgt.snmp.proxy.common.SnmpGetRequestDTO;
import org.opennms.netmgt.snmp.proxy.common.SnmpMultiResponseDTO;
import org.opennms.netmgt.snmp.proxy.common.SnmpRequestDTO;
import org.opennms.netmgt.snmp.proxy.common.SnmpWalkRequestDTO;

public abstract class AbstractSNMPRequestBuilder<T>
implements SNMPRequestBuilder<T> {
    private final LocationAwareSnmpClientRpcImpl client;
    private final SnmpAgentConfig agent;
    private List<SnmpGetRequestDTO> gets;
    private List<SnmpWalkRequestDTO> walks;
    private String location;
    private String systemId;
    private String description;
    private Long timeToLiveInMilliseconds = null;

    public AbstractSNMPRequestBuilder(LocationAwareSnmpClientRpcImpl client, SnmpAgentConfig agent, List<SnmpGetRequestDTO> gets, List<SnmpWalkRequestDTO> walks) {
        this.client = Objects.requireNonNull(client);
        this.agent = Objects.requireNonNull(agent);
        this.gets = Objects.requireNonNull(gets);
        this.walks = Objects.requireNonNull(walks);
    }

    public SNMPRequestBuilder<T> withLocation(String location) {
        this.location = location;
        return this;
    }

    public SNMPRequestBuilder<T> withSystemId(String systemId) {
        this.systemId = systemId;
        return this;
    }

    public SNMPRequestBuilder<T> withDescription(String description) {
        this.description = description;
        return this;
    }

    public SNMPRequestBuilder<T> withTimeToLive(Long ttlInMs) {
        this.timeToLiveInMilliseconds = ttlInMs;
        return this;
    }

    public SNMPRequestBuilder<T> withTimeToLive(long duration, TimeUnit unit) {
        this.timeToLiveInMilliseconds = unit.toMillis(duration);
        return this;
    }

    public CompletableFuture<T> execute() {
        SnmpRequestDTO snmpRequestDTO = new SnmpRequestDTO();
        snmpRequestDTO.setLocation(this.location);
        snmpRequestDTO.setSystemId(this.systemId);
        snmpRequestDTO.setAgent(this.agent);
        snmpRequestDTO.setDescription(this.description);
        snmpRequestDTO.setGetRequests(this.gets);
        snmpRequestDTO.setWalkRequests(this.walks);
        snmpRequestDTO.setTimeToLive(this.timeToLiveInMilliseconds);
        return this.client.execute(snmpRequestDTO).thenApply(res -> this.processResponse((SnmpMultiResponseDTO)res));
    }

    protected abstract T processResponse(SnmpMultiResponseDTO var1);
}

