/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.minion;

import java.util.Dictionary;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.core.ipc.sink.api.MessageDispatcherFactory;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.telemetry.ipc.ProtocolDefinition;
import org.opennms.netmgt.telemetry.ipc.TelemetrySinkModule;
import org.opennms.netmgt.telemetry.listeners.api.Listener;
import org.opennms.netmgt.telemetry.listeners.api.ListenerDefinition;
import org.opennms.netmgt.telemetry.listeners.api.TelemetryMessage;
import org.opennms.netmgt.telemetry.minion.MapBasedListenerDef;
import org.opennms.netmgt.telemetry.minion.MapBasedProtocolDef;
import org.opennms.netmgt.telemetry.minion.MapUtils;
import org.opennms.netmgt.telemetry.utils.ListenerFactory;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerManager
implements ManagedServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ListenerManager.class);
    private MessageDispatcherFactory messageDispatcherFactory;
    private DistPollerDao distPollerDao;
    private Map<String, Listener> listenersByPid = new LinkedHashMap<String, Listener>();
    private Map<String, AsyncDispatcher<TelemetryMessage>> dispatchersByPid = new LinkedHashMap<String, AsyncDispatcher<TelemetryMessage>>();

    public String getName() {
        return "Manages telemetry listener lifecycle.";
    }

    public void updated(String pid, Dictionary<String, ?> properties) {
        Listener existingListener = this.listenersByPid.get(pid);
        if (existingListener != null) {
            LOG.info("Updating existing listener/dispatcher for pid: {}", (Object)pid);
            this.deleted(pid);
        } else {
            LOG.info("Creating new listener/dispatcher for pid: {}", (Object)pid);
        }
        Map<String, String> parameters = MapUtils.fromDict(properties);
        MapBasedProtocolDef protocolDef = new MapBasedProtocolDef(parameters);
        MapBasedListenerDef listenerDef = new MapBasedListenerDef(parameters);
        TelemetrySinkModule sinkModule = new TelemetrySinkModule((ProtocolDefinition)protocolDef);
        sinkModule.setDistPollerDao(this.distPollerDao);
        AsyncDispatcher dispatcher = this.messageDispatcherFactory.createAsyncDispatcher((SinkModule)sinkModule);
        try {
            Listener listener = ListenerFactory.buildListener((ListenerDefinition)listenerDef, (AsyncDispatcher)dispatcher);
            listener.start();
            this.listenersByPid.put(pid, listener);
            this.dispatchersByPid.put(pid, (AsyncDispatcher<TelemetryMessage>)dispatcher);
        }
        catch (Exception e) {
            LOG.error("Failed to build listener.", (Throwable)e);
            try {
                dispatcher.close();
            }
            catch (Exception ee) {
                LOG.error("Failed to close dispatcher.", (Throwable)e);
            }
        }
        LOG.info("Successfully started listener/dispatcher for pid: {}", (Object)pid);
    }

    public void deleted(String pid) {
        AsyncDispatcher<TelemetryMessage> dispatcher;
        Listener listener = this.listenersByPid.remove(pid);
        if (listener != null) {
            LOG.info("Stopping listener for pid: {}", (Object)pid);
            try {
                listener.stop();
            }
            catch (InterruptedException e) {
                LOG.error("Error occured while stopping listener for pid: {}", (Object)pid, (Object)e);
            }
        }
        if ((dispatcher = this.dispatchersByPid.remove(pid)) != null) {
            LOG.info("Closing dispatcher for pid: {}", (Object)pid);
            try {
                dispatcher.close();
            }
            catch (Exception e) {
                LOG.error("Error occured while closing dispatcher for pid: {}", (Object)pid, (Object)e);
            }
        }
    }

    public void init() {
        LOG.info("ListenerManager started.");
    }

    public void destroy() {
        this.listenersByPid.keySet().forEach(pid -> this.deleted((String)pid));
        LOG.info("ListenerManager stopped.");
    }

    public MessageDispatcherFactory getMessageDispatcherFactory() {
        return this.messageDispatcherFactory;
    }

    public void setMessageDispatcherFactory(MessageDispatcherFactory messageDispatcherFactory) {
        this.messageDispatcherFactory = messageDispatcherFactory;
    }

    public DistPollerDao getDistPollerDao() {
        return this.distPollerDao;
    }

    public void setDistPollerDao(DistPollerDao distPollerDao) {
        this.distPollerDao = distPollerDao;
    }
}

