/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.notificationCommands;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.notificationCommands.Argument;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="command")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="notificationCommands.xsd")
public class Command
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="binary")
    private Boolean m_binary;
    @XmlElement(name="name", required=true)
    private String m_name;
    @XmlElement(name="execute", required=true)
    private String m_execute;
    @XmlElement(name="comment")
    private String m_comment;
    @XmlElement(name="contact-type")
    private String m_contactType;
    @XmlElement(name="argument")
    private List<Argument> m_arguments = new ArrayList<Argument>();

    public Boolean getBinary() {
        return this.m_binary != null ? this.m_binary : Boolean.TRUE;
    }

    public void setBinary(Boolean binary) {
        this.m_binary = binary;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public String getExecute() {
        return this.m_execute;
    }

    public void setExecute(String execute) {
        this.m_execute = ConfigUtils.assertNotEmpty(execute, "execute");
    }

    public Optional<String> getComment() {
        return Optional.ofNullable(this.m_comment);
    }

    public void setComment(String comment) {
        this.m_comment = ConfigUtils.normalizeString(comment);
    }

    public Optional<String> getContactType() {
        return Optional.ofNullable(this.m_contactType);
    }

    public void setContactType(String contactType) {
        this.m_contactType = ConfigUtils.normalizeString(contactType);
    }

    public List<Argument> getArguments() {
        return this.m_arguments;
    }

    public void setArguments(List<Argument> arguments) {
        if (arguments == this.m_arguments) {
            return;
        }
        this.m_arguments.clear();
        if (arguments != null) {
            this.m_arguments.addAll(arguments);
        }
    }

    public void addArgument(Argument argument) {
        this.m_arguments.add(argument);
    }

    public boolean removeArgument(Argument argument) {
        return this.m_arguments.remove(argument);
    }

    public int hashCode() {
        return Objects.hash(this.m_binary, this.m_name, this.m_execute, this.m_comment, this.m_contactType, this.m_arguments);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Command) {
            Command that = (Command)obj;
            return Objects.equals(this.m_binary, that.m_binary) && Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_execute, that.m_execute) && Objects.equals(this.m_comment, that.m_comment) && Objects.equals(this.m_contactType, that.m_contactType) && Objects.equals(this.m_arguments, that.m_arguments);
        }
        return false;
    }
}

