/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.ami;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.ami.Range;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="definition")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="ami-config.xsd")
public class Definition
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="port")
    private Integer m_port;
    @XmlAttribute(name="use-ssl")
    private Boolean m_useSsl;
    @XmlAttribute(name="timeout")
    private Integer m_timeout;
    @XmlAttribute(name="retry")
    private Integer m_retry;
    @XmlAttribute(name="username")
    private String m_username;
    @XmlAttribute(name="password")
    private String m_password;
    @XmlElement(name="range")
    private List<Range> m_ranges = new ArrayList<Range>();
    @XmlElement(name="specific")
    private List<String> m_specifics = new ArrayList<String>();
    @XmlElement(name="ip-match")
    private List<String> m_ipMatches = new ArrayList<String>();

    public Definition() {
    }

    public Definition(Integer port, Boolean useSsl, Integer timeout, Integer retry, String username, String password, List<Range> ranges, List<String> specifics, List<String> ipMatches) {
        this.setPort(port);
        this.setUseSsl(useSsl);
        this.setTimeout(timeout);
        this.setRetry(retry);
        this.setUsername(username);
        this.setPassword(password);
        this.setRanges(ranges);
        this.setSpecifics(specifics);
        this.setIpMatches(ipMatches);
    }

    public Optional<Integer> getPort() {
        return Optional.ofNullable(this.m_port);
    }

    public void setPort(Integer port) {
        this.m_port = port;
    }

    public boolean getUseSsl() {
        return this.m_useSsl == null ? false : this.m_useSsl;
    }

    public void setUseSsl(Boolean useSsl) {
        this.m_useSsl = useSsl;
    }

    public Optional<Integer> getTimeout() {
        return Optional.ofNullable(this.m_timeout);
    }

    public void setTimeout(Integer timeout) {
        this.m_timeout = timeout;
    }

    public Optional<Integer> getRetry() {
        return Optional.ofNullable(this.m_retry);
    }

    public void setRetry(Integer retry) {
        this.m_retry = retry;
    }

    public Optional<String> getUsername() {
        return Optional.ofNullable(this.m_username);
    }

    public void setUsername(String username) {
        this.m_username = ConfigUtils.normalizeString(username);
    }

    public Optional<String> getPassword() {
        return Optional.ofNullable(this.m_password);
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public List<Range> getRanges() {
        return this.m_ranges;
    }

    public void setRanges(List<Range> ranges) {
        if (ranges == this.m_ranges) {
            return;
        }
        this.m_ranges.clear();
        if (ranges != null) {
            this.m_ranges.addAll(ranges);
        }
    }

    public List<String> getSpecifics() {
        return this.m_specifics;
    }

    public void setSpecifics(List<String> specifics) {
        if (specifics == this.m_specifics) {
            return;
        }
        this.m_specifics.clear();
        if (specifics != null) {
            this.m_specifics.addAll(specifics);
        }
    }

    public void addSpecific(String vSpecific) {
        this.m_specifics.add(vSpecific);
    }

    public List<String> getIpMatches() {
        return this.m_ipMatches;
    }

    public void setIpMatches(List<String> ipMatches) {
        if (ipMatches == this.m_ipMatches) {
            return;
        }
        this.m_ipMatches.clear();
        if (ipMatches != null) {
            this.m_ipMatches.addAll(ipMatches);
        }
    }

    public int hashCode() {
        return Objects.hash(this.m_port, this.m_useSsl, this.m_timeout, this.m_retry, this.m_username, this.m_password, this.m_ranges, this.m_specifics, this.m_ipMatches);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Definition) {
            Definition that = (Definition)obj;
            return Objects.equals(this.m_port, that.m_port) && Objects.equals(this.m_useSsl, that.m_useSsl) && Objects.equals(this.m_timeout, that.m_timeout) && Objects.equals(this.m_retry, that.m_retry) && Objects.equals(this.m_username, that.m_username) && Objects.equals(this.m_password, that.m_password) && Objects.equals(this.m_ranges, that.m_ranges) && Objects.equals(this.m_specifics, that.m_specifics) && Objects.equals(this.m_ipMatches, that.m_ipMatches);
        }
        return false;
    }
}

