/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.net.InetAddress;
import java.util.Objects;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpVarBindDTO;
import org.opennms.netmgt.snmp.TrapInformation;

public class TrapUtils {
    protected static final SnmpObjId SNMP_TRAP_ADDRESS_OID = SnmpObjId.get((String)".1.3.6.1.6.3.18.1.3.0");
    public static final String GET_TRAP_ADDRESS_FROM_VARBIND_SYS_PROP = "org.opennms.trapd";

    public static InetAddress getEffectiveTrapAddress(TrapInformation trapInfo, boolean useAddressFromVarbind) {
        SnmpVarBindDTO varBindDTO;
        if (useAddressFromVarbind && (varBindDTO = TrapUtils.getFirstVarBindWithOid(trapInfo, SNMP_TRAP_ADDRESS_OID)) != null) {
            return varBindDTO.getSnmpValue().toInetAddress();
        }
        return trapInfo.getTrapAddress();
    }

    public static SnmpVarBindDTO getFirstVarBindWithOid(TrapInformation trapInfo, SnmpObjId oid) {
        for (int i = 0; i < trapInfo.getPduLength(); ++i) {
            SnmpVarBindDTO varBindDTO = trapInfo.getSnmpVarBindDTO(i);
            if (varBindDTO == null || !Objects.equals(oid, varBindDTO.getSnmpObjectId())) continue;
            return varBindDTO;
        }
        return null;
    }
}

