/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.camel;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.opennms.core.camel.JmsQueueNameFactory;
import org.opennms.core.rpc.api.RpcModule;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.rpc.api.RpcResponse;
import org.opennms.core.rpc.camel.CamelRpcServerProcessor;
import org.opennms.minion.core.api.MinionIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelRpcServerRouteManager {
    private static final Logger LOG = LoggerFactory.getLogger(CamelRpcServerRouteManager.class);
    private final CamelContext context;
    private final MinionIdentity identity;
    private final Map<RpcModule<RpcRequest, RpcResponse>, String> routeIdsByModule = new ConcurrentHashMap<RpcModule<RpcRequest, RpcResponse>, String>();

    public CamelRpcServerRouteManager(CamelContext context, MinionIdentity identity) {
        this.context = Objects.requireNonNull(context);
        this.identity = Objects.requireNonNull(identity);
    }

    public static String getRouteId(RpcModule<?, ?> module) {
        return "RPC.Server." + module.getId();
    }

    public void bind(RpcModule module) throws Exception {
        if (module != null) {
            RpcModule rpcModule = module;
            String routeId = CamelRpcServerRouteManager.getRouteId(rpcModule);
            Route existingRoute = this.context.getRoute(routeId);
            if (this.routeIdsByModule.containsKey(rpcModule)) {
                if (existingRoute == null) {
                    LOG.error("RpcModule {} ({}) was marked as registered but its route {} cannot be found in the Camel context", new Object[]{rpcModule.getId(), Integer.toHexString(rpcModule.hashCode()), routeId});
                } else {
                    LOG.warn("RpcModule {} ({}) was already registered on route {}: {}", new Object[]{rpcModule.getId(), Integer.toHexString(rpcModule.hashCode()), routeId, existingRoute});
                }
            } else if (existingRoute == null) {
                DynamicRpcRouteBuilder routeBuilder = new DynamicRpcRouteBuilder(this.context, this.identity, rpcModule);
                this.context.addRoutes((RoutesBuilder)routeBuilder);
                this.routeIdsByModule.put((RpcModule<RpcRequest, RpcResponse>)rpcModule, routeId);
                LOG.info("Registered RpcModule {} ({}) on route {} with queue {}", new Object[]{rpcModule.getId(), Integer.toHexString(rpcModule.hashCode()), routeId, routeBuilder.getQueueName()});
            } else {
                LOG.warn("RpcModule {} ({}) cannot be registered, route {} is already present: {}", new Object[]{rpcModule.getId(), Integer.toHexString(rpcModule.hashCode()), routeId, existingRoute});
            }
        }
    }

    public void unbind(RpcModule module) throws Exception {
        if (module != null) {
            RpcModule rpcModule = module;
            String routeId = this.routeIdsByModule.remove(rpcModule);
            if (routeId != null) {
                this.context.stopRoute(routeId);
                this.context.removeRoute(routeId);
                LOG.info("Deregistered RpcModule {} ({})", (Object)rpcModule.getId(), (Object)Integer.toHexString(rpcModule.hashCode()));
            } else {
                LOG.warn("Could not determine route ID for RpcModule {} ({})", (Object)rpcModule.getId(), (Object)Integer.toHexString(rpcModule.hashCode()));
            }
        }
    }

    static String getJmsSelector(String systemId) {
        if (systemId == null) {
            return String.format("%s IS NULL", "SystemId");
        }
        return String.format("%s='%s' OR %s IS NULL", "SystemId", systemId.replace("'", "\\'"), "SystemId");
    }

    private static final class DynamicRpcRouteBuilder
    extends RouteBuilder {
        private final MinionIdentity identity;
        private final RpcModule<RpcRequest, RpcResponse> module;
        private final JmsQueueNameFactory queueNameFactory;

        private DynamicRpcRouteBuilder(CamelContext context, MinionIdentity identity, RpcModule<RpcRequest, RpcResponse> module) {
            super(context);
            this.identity = identity;
            this.module = module;
            this.queueNameFactory = new JmsQueueNameFactory("RPC", module.getId(), identity.getLocation());
        }

        public String getQueueName() {
            return this.queueNameFactory.getName();
        }

        public void configure() throws Exception {
            JmsEndpoint endpoint = (JmsEndpoint)this.getContext().getEndpoint(String.format("queuingservice:%s?asyncConsumer=true", this.queueNameFactory.getName()), JmsEndpoint.class);
            String selector = CamelRpcServerRouteManager.getJmsSelector(this.identity.getId());
            LOG.trace("Using JMS selector: {} for module: {} on: {}", new Object[]{selector, this.module, this.identity});
            endpoint.setSelector(selector);
            ((RouteDefinition)((RouteDefinition)this.from((Endpoint)endpoint).setExchangePattern(ExchangePattern.InOut)).process((Processor)new CamelRpcServerProcessor(this.module))).routeId(CamelRpcServerRouteManager.getRouteId(this.module));
        }
    }
}

