/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.provisiond;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.provisiond.RequisitionDef;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="provisiond-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="provisiond-configuration.xsd")
public class ProvisiondConfiguration
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final String DEFAULT_REQUISITION_DIR = "${install.dir}/etc/imports";
    private static final String DEFAULT_FOREIGN_SOURCE_DIR = "${install.dir}/etc/foreign-sources";
    @XmlAttribute(name="importThreads")
    private Long m_importThreads;
    @XmlAttribute(name="scanThreads")
    private Long m_scanThreads;
    @XmlAttribute(name="rescanThreads")
    private Long m_rescanThreads;
    @XmlAttribute(name="writeThreads")
    private Long m_writeThreads;
    @XmlAttribute(name="requistion-dir")
    private String m_requistionDir;
    @XmlAttribute(name="foreign-source-dir")
    private String m_foreignSourceDir;
    @XmlElement(name="requisition-def")
    private List<RequisitionDef> m_requisitionDefs = new ArrayList<RequisitionDef>();

    public Long getImportThreads() {
        return this.m_importThreads != null ? this.m_importThreads : 8L;
    }

    public void setImportThreads(Long importThreads) {
        this.m_importThreads = importThreads;
    }

    public Long getScanThreads() {
        return this.m_scanThreads != null ? this.m_scanThreads : 10L;
    }

    public void setScanThreads(Long scanThreads) {
        this.m_scanThreads = scanThreads;
    }

    public Long getRescanThreads() {
        return this.m_rescanThreads != null ? this.m_rescanThreads : 10L;
    }

    public void setRescanThreads(Long rescanThreads) {
        this.m_rescanThreads = rescanThreads;
    }

    public Long getWriteThreads() {
        return this.m_writeThreads != null ? this.m_writeThreads : 8L;
    }

    public void setWriteThreads(Long writeThreads) {
        this.m_writeThreads = writeThreads;
    }

    public String getRequistionDir() {
        return this.m_requistionDir != null ? this.m_requistionDir : DEFAULT_REQUISITION_DIR;
    }

    public void setRequistionDir(String requistionDir) {
        this.m_requistionDir = ConfigUtils.assertNotEmpty(requistionDir, "requisition-dir");
    }

    public String getForeignSourceDir() {
        return this.m_foreignSourceDir != null ? this.m_foreignSourceDir : DEFAULT_FOREIGN_SOURCE_DIR;
    }

    public void setForeignSourceDir(String foreignSourceDir) {
        this.m_foreignSourceDir = ConfigUtils.assertNotEmpty(foreignSourceDir, "foreign-source-dir");
    }

    public List<RequisitionDef> getRequisitionDefs() {
        return this.m_requisitionDefs;
    }

    public void setRequisitionDefs(List<RequisitionDef> requisitionDefs) {
        if (requisitionDefs == this.m_requisitionDefs) {
            return;
        }
        this.m_requisitionDefs.clear();
        if (requisitionDefs != null) {
            this.m_requisitionDefs.addAll(requisitionDefs);
        }
    }

    public void addRequisitionDef(RequisitionDef def) {
        this.m_requisitionDefs.add(def);
    }

    public boolean removeRequisitionDef(RequisitionDef def) {
        return this.m_requisitionDefs.remove(def);
    }

    public int hashCode() {
        return Objects.hash(this.m_importThreads, this.m_scanThreads, this.m_rescanThreads, this.m_writeThreads, this.m_requistionDir, this.m_foreignSourceDir, this.m_requisitionDefs);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProvisiondConfiguration) {
            ProvisiondConfiguration that = (ProvisiondConfiguration)obj;
            return Objects.equals(this.m_importThreads, that.m_importThreads) && Objects.equals(this.m_scanThreads, that.m_scanThreads) && Objects.equals(this.m_rescanThreads, that.m_rescanThreads) && Objects.equals(this.m_writeThreads, that.m_writeThreads) && Objects.equals(this.m_requistionDir, that.m_requistionDir) && Objects.equals(this.m_foreignSourceDir, that.m_foreignSourceDir) && Objects.equals(this.m_requisitionDefs, that.m_requisitionDefs);
        }
        return false;
    }
}

