/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.poller.outages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.poller.outages.Outage;

@XmlRootElement(name="outages", namespace="http://xmlns.opennms.org/xsd/config/poller/outages")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="poll-outages.xsd")
public class Outages
implements Serializable {
    private static final long serialVersionUID = 2L;
    private Map<String, Outage> m_outages = new LinkedHashMap<String, Outage>();

    @XmlElement(name="outage")
    public List<Outage> getOutages() {
        return new ArrayList<Outage>(this.m_outages.values());
    }

    public void setOutages(List<Outage> outages) {
        LinkedHashMap<String, Outage> m = new LinkedHashMap<String, Outage>();
        for (Outage o : outages) {
            m.put(o.getName(), o);
        }
        this.m_outages = m;
    }

    public Outage getOutage(String name) {
        return this.m_outages.get(name);
    }

    public void addOutage(Outage outage) {
        this.m_outages.put(outage.getName(), outage);
    }

    public boolean removeOutage(Outage outage) {
        Outage removed = this.m_outages.remove(outage.getName());
        return removed != null;
    }

    public void removeOutage(String outageName) {
        this.m_outages.remove(outageName);
    }

    public boolean replaceOutage(Outage oldOutage, Outage newOutage) {
        String match = null;
        for (Map.Entry<String, Outage> entry : this.m_outages.entrySet()) {
            if (!entry.getValue().equals(oldOutage)) continue;
            match = entry.getKey();
            break;
        }
        if (match != null) {
            this.m_outages.put(match, newOutage);
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.m_outages);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Outages) {
            Outages that = (Outages)obj;
            return Objects.equals(this.m_outages, that.m_outages);
        }
        return false;
    }
}

