/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;

public abstract class IPLike {
    public static boolean matches(InetAddress address, String pattern) {
        return IPLike.matches(InetAddressUtils.str(address), pattern);
    }

    private static AddressType classifyAddress(String address) {
        if (address.indexOf(58) != -1) {
            return AddressType.IPv6;
        }
        if (address.indexOf(46) != -1) {
            return AddressType.IPv4;
        }
        return null;
    }

    private static String[] parseIPv4Address(String address) {
        return address.split("\\.", 0);
    }

    private static IPv6Address parseIPv6Address(String address) {
        String[] addressAndScope = address.split("%", 2);
        String[] fields = addressAndScope[0].split("\\:", 0);
        String scope = addressAndScope.length == 2 ? addressAndScope[1] : null;
        return new IPv6Address(fields, scope);
    }

    public static boolean matches(String address, String pattern) {
        RangeMatcher matcher;
        int expectedFieldCount;
        String[] patternFields;
        String[] addressFields;
        AddressType patternType;
        AddressType addressType = IPLike.classifyAddress(address);
        if (addressType != (patternType = IPLike.classifyAddress(pattern))) {
            return false;
        }
        switch (addressType) {
            case IPv4: {
                addressFields = IPLike.parseIPv4Address(address);
                patternFields = IPLike.parseIPv4Address(pattern);
                expectedFieldCount = 4;
                matcher = new DecimalRangeMatcher();
                break;
            }
            case IPv6: {
                IPv6Address parsedAddress = IPLike.parseIPv6Address(address);
                IPv6Address parsedPattern = IPLike.parseIPv6Address(pattern);
                if (parsedPattern.scope != null) {
                    if (parsedAddress.scope == null) {
                        return false;
                    }
                    if (!IPLike.matchNumericListOrRange(parsedAddress.scope, parsedPattern.scope, new DecimalRangeMatcher())) {
                        return false;
                    }
                }
                addressFields = parsedAddress.fields;
                patternFields = parsedPattern.fields;
                expectedFieldCount = 8;
                matcher = new HexRangeMatcher();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (addressFields.length != expectedFieldCount) {
            throw new IllegalArgumentException("Malformatted IP address: " + address);
        }
        if (patternFields.length != expectedFieldCount) {
            throw new IllegalArgumentException("Malformatted IPLIKE match expression: " + pattern);
        }
        for (int i = 0; i < expectedFieldCount; ++i) {
            if (IPLike.matchNumericListOrRange(addressFields[i], patternFields[i], matcher)) continue;
            return false;
        }
        return true;
    }

    public static boolean matchNumericListOrRange(String value, String patterns) {
        return IPLike.matchNumericListOrRange(value, patterns, new DecimalRangeMatcher());
    }

    public static boolean matchNumericListOrRange(String value, String patterns, RangeMatcher matcher) {
        String[] patternList;
        for (String element : patternList = patterns.split(",", 0)) {
            if (!matcher.match(value, element)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchRange(String value, String pattern) {
        int dashCount = IPLike.countChar('-', pattern);
        if ("*".equals(pattern)) {
            return true;
        }
        if (dashCount == 0) {
            return Long.parseLong(pattern, 10) == Long.parseLong(value, 10);
        }
        if (dashCount > 1) {
            return false;
        }
        if (dashCount == 1) {
            String[] ar = pattern.split("-");
            long rangeBegin = Long.parseLong(ar[0]);
            long rangeEnd = Long.parseLong(ar[1]);
            long ip = Long.parseLong(value);
            return ip >= rangeBegin && ip <= rangeEnd;
        }
        return false;
    }

    public static boolean matchRangeHex(String value, String pattern) {
        int dashCount = IPLike.countChar('-', pattern);
        if ("*".equals(pattern)) {
            return true;
        }
        if (dashCount == 0) {
            return Long.parseLong(pattern, 16) == Long.parseLong(value, 16);
        }
        if (dashCount > 1) {
            return false;
        }
        if (dashCount == 1) {
            String[] ar = pattern.split("-");
            long rangeBegin = Long.parseLong(ar[0], 16);
            long rangeEnd = Long.parseLong(ar[1], 16);
            long ip = Long.parseLong(value, 16);
            return ip >= rangeBegin && ip <= rangeEnd;
        }
        return false;
    }

    public static int countChar(char charIn, String stingIn) {
        int charCount = 0;
        int charIndex = 0;
        for (int i = 0; i < stingIn.length(); ++i) {
            charIndex = stingIn.indexOf(charIn, i);
            if (charIndex == -1) continue;
            ++charCount;
            i = charIndex + 1;
        }
        return charCount;
    }

    private static class DecimalRangeMatcher
    implements RangeMatcher {
        private DecimalRangeMatcher() {
        }

        @Override
        public boolean match(String value, String range) {
            return IPLike.matchRange(value, range);
        }
    }

    private static class HexRangeMatcher
    implements RangeMatcher {
        private HexRangeMatcher() {
        }

        @Override
        public boolean match(String value, String range) {
            return IPLike.matchRangeHex(value, range);
        }
    }

    private static interface RangeMatcher {
        public boolean match(String var1, String var2);
    }

    private static class IPv6Address {
        public final String[] fields;
        public final String scope;

        private IPv6Address(String[] fields, String scope) {
            this.fields = fields;
            this.scope = scope;
        }
    }

    private static enum AddressType {
        IPv4,
        IPv6;

    }
}

