/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.opennms.core.utils.EmptyKeyRelaxedTrustProvider;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.web.HttpClientWrapper;
import org.opennms.netmgt.collection.api.AbstractRemoteServiceCollector;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionStatus;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.config.HttpCollectionConfigFactory;
import org.opennms.netmgt.config.httpdatacollection.Attrib;
import org.opennms.netmgt.config.httpdatacollection.HttpCollection;
import org.opennms.netmgt.config.httpdatacollection.Parameter;
import org.opennms.netmgt.config.httpdatacollection.Uri;
import org.opennms.netmgt.config.httpdatacollection.Url;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCollector
extends AbstractRemoteServiceCollector {
    private static final Logger LOG = LoggerFactory.getLogger(HttpCollector.class);
    private static final String HTTP_COLLECTION_KEY = "httpCollection";
    private static final Map<String, Class<?>> TYPE_MAP = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, Class<HttpCollection>>("httpCollection", HttpCollection.class)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Class)e.getValue())));
    private static final int DEFAULT_RETRY_COUNT = 2;
    private static final int DEFAULT_SO_TIMEOUT = 3000;
    private static final NumberFormat PARSER = NumberFormat.getNumberInstance();

    public HttpCollector() {
        super(TYPE_MAP);
    }

    public void initialize() throws CollectionInitializationException {
        LOG.debug("initialize: Initializing HttpCollector.");
        HttpCollector.initHttpCollectionConfig();
    }

    public Map<String, Object> getRuntimeAttributes(CollectionAgent agent, Map<String, Object> parameters) {
        HashMap<String, Object> runtimeAttributes = new HashMap<String, Object>();
        String collectionName = ParameterMap.getKeyedString(parameters, (String)"collection", (String)ParameterMap.getKeyedString(parameters, (String)"http-collection", null));
        HttpCollection collection = HttpCollectionConfigFactory.getInstance().getHttpCollection(collectionName);
        if (collection == null) {
            throw new IllegalArgumentException(String.format("HttpCollector: No collection found with name '%s'.", collectionName));
        }
        runtimeAttributes.put(HTTP_COLLECTION_KEY, collection);
        return runtimeAttributes;
    }

    public CollectionSet collect(CollectionAgent agent, Map<String, Object> parameters) {
        HttpCollection collection = (HttpCollection)parameters.get(HTTP_COLLECTION_KEY);
        CollectionSetBuilder collectionSetBuilder = new CollectionSetBuilder(agent);
        HttpCollectorAgent httpCollectorAgent = new HttpCollectorAgent(agent, parameters, collection, collectionSetBuilder);
        httpCollectorAgent.collect();
        return collectionSetBuilder.build();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void doCollection(HttpCollectorAgent collectorAgent, CollectionSetBuilder collectionSetBuilder) throws HttpCollectorException {
        HttpRequestBase method = null;
        HttpClientWrapper clientWrapper = null;
        try {
            HttpVersion httpVersion = HttpCollector.computeVersion(collectorAgent.getUriDef());
            clientWrapper = HttpClientWrapper.create().setConnectionTimeout(Integer.valueOf(ParameterMap.getKeyedInteger(collectorAgent.getParameters(), (String)ServiceParameters.ParameterName.TIMEOUT.toString(), (int)3000))).setSocketTimeout(Integer.valueOf(ParameterMap.getKeyedInteger(collectorAgent.getParameters(), (String)ServiceParameters.ParameterName.TIMEOUT.toString(), (int)3000))).useBrowserCompatibleCookies();
            if ("https".equals(collectorAgent.getUriDef().getUrl().getScheme())) {
                clientWrapper.useRelaxedSSL("https");
            }
            String key = ServiceParameters.ParameterName.RETRY.toString();
            if (collectorAgent.getParameters().containsKey(ServiceParameters.ParameterName.RETRIES.toString())) {
                key = ServiceParameters.ParameterName.RETRIES.toString();
            }
            Integer retryCount = ParameterMap.getKeyedInteger(collectorAgent.getParameters(), (String)key, (int)2);
            clientWrapper.setRetries(retryCount);
            method = HttpCollector.buildHttpMethod(collectorAgent);
            method.setProtocolVersion((ProtocolVersion)httpVersion);
            String userAgent = HttpCollector.determineUserAgent(collectorAgent);
            if (userAgent != null && !userAgent.trim().isEmpty()) {
                clientWrapper.setUserAgent(userAgent);
            }
            HttpClientWrapper wrapper = clientWrapper;
            if (collectorAgent.getUriDef().getUrl().getUserInfo().isPresent()) {
                String userInfo = (String)collectorAgent.getUriDef().getUrl().getUserInfo().get();
                String[] streetCred = userInfo.split(":", 2);
                if (streetCred.length == 2) {
                    wrapper.addBasicCredentials(streetCred[0], streetCred[1]);
                } else {
                    LOG.warn("Illegal value found for username/password HTTP credentials: {}", (Object)userInfo);
                }
            }
            LOG.info("doCollection: collecting using method: {}", (Object)method);
            CloseableHttpResponse response = clientWrapper.execute((HttpUriRequest)method);
            HttpCollector.persistResponse(collectorAgent, collectionSetBuilder, (HttpResponse)response);
        }
        catch (URISyntaxException e) {
            try {
                throw new HttpCollectorException("Error building HttpClient URI", e);
                catch (IOException e2) {
                    throw new HttpCollectorException("IO Error retrieving page", e2);
                }
                catch (PatternSyntaxException e3) {
                    throw new HttpCollectorException("Invalid regex specified in HTTP collection configuration", e3);
                }
                catch (Throwable e4) {
                    throw new HttpCollectorException("Unexpected exception caught during HTTP collection", e4);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(clientWrapper);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)clientWrapper);
    }

    private static void processResponse(Locale responseLocale, String responseBodyAsString, HttpCollectorAgent collectorAgent, CollectionSetBuilder collectionSetBuilder) {
        LOG.debug("processResponse:");
        LOG.debug("responseBody = {}", (Object)responseBodyAsString);
        LOG.debug("getmatches = {}", (Object)collectorAgent.getUriDef().getUrl().getMatches());
        int numberOfButes = 0;
        int flags = 0;
        if (collectorAgent.getUriDef().getUrl().isCanonicalEquivalence()) {
            flags |= 0x80;
        }
        if (collectorAgent.getUriDef().getUrl().isCaseInsensitive()) {
            flags |= 2;
        }
        if (collectorAgent.getUriDef().getUrl().isComments()) {
            flags |= 4;
        }
        if (collectorAgent.getUriDef().getUrl().isDotall()) {
            flags |= 0x20;
        }
        if (collectorAgent.getUriDef().getUrl().isLiteral()) {
            flags |= 0x10;
        }
        if (collectorAgent.getUriDef().getUrl().isMultiline()) {
            flags |= 8;
        }
        if (collectorAgent.getUriDef().getUrl().isUnicodeCase()) {
            flags |= 0x40;
        }
        if (collectorAgent.getUriDef().getUrl().isUnixLines()) {
            flags |= 1;
        }
        LOG.debug("flags = {}", (Object)flags);
        Pattern p = Pattern.compile(collectorAgent.getUriDef().getUrl().getMatches(), flags);
        Matcher m = p.matcher(responseBodyAsString);
        boolean matches = m.matches();
        if (matches) {
            LOG.debug("processResponse: found matching attributes: {}", (Object)matches);
            List attribDefs = collectorAgent.getUriDef().getAttributes();
            ArrayList<Locale> locales = new ArrayList<Locale>();
            if (responseLocale != null) {
                locales.add(responseLocale);
            }
            locales.add(Locale.getDefault());
            if (Locale.getDefault() != Locale.ENGLISH) {
                locales.add(Locale.ENGLISH);
            }
            NodeLevelResource resource = new NodeLevelResource(collectorAgent.getAgent().getNodeId());
            for (Attrib attribDef : attribDefs) {
                AttributeType type = attribDef.getType();
                String value = null;
                try {
                    value = m.group(attribDef.getMatchGroup());
                }
                catch (IndexOutOfBoundsException e) {
                    LOG.error("IndexOutOfBoundsException thrown while trying to find regex group, your regex does not contain the following group index: {}", (Object)attribDef.getMatchGroup());
                    LOG.error("Regex statement: {}", (Object)collectorAgent.getUriDef().getUrl().getMatches());
                    continue;
                }
                if (type.isNumeric()) {
                    Number num = null;
                    for (Locale locale : locales) {
                        try {
                            num = NumberFormat.getNumberInstance(locale).parse(value);
                            LOG.debug("processResponse: found a parsable number with locale \"{}\".", (Object)locale);
                            break;
                        }
                        catch (ParseException e) {
                            LOG.warn("attribute {} failed to match a parsable number with locale \"{}\"! Matched \"{}\" instead.", new Object[]{attribDef.getAlias(), locale, value});
                        }
                    }
                    if (num == null) {
                        LOG.warn("processResponse: gave up attempting to parse numeric value, skipping group {}", (Object)attribDef.getMatchGroup());
                        continue;
                    }
                    LOG.debug("processResponse: adding numeric attribute {}", num);
                    collectionSetBuilder.withNumericAttribute((Resource)resource, collectorAgent.getUriDef().getName(), attribDef.getAlias(), num, type);
                    ++numberOfButes;
                    continue;
                }
                LOG.debug("processResponse: adding string attribute {}", (Object)value);
                collectionSetBuilder.withStringAttribute((Resource)resource, collectorAgent.getUriDef().getName(), attribDef.getAlias(), value);
                ++numberOfButes;
            }
        } else {
            LOG.debug("processResponse: found matching attributes: {}", (Object)matches);
        }
        if (numberOfButes < 1) {
            LOG.warn("doCollection: no attributes defined by the response: {}", (Object)responseBodyAsString.trim());
            throw new HttpCollectorException("No attributes specified were found.");
        }
    }

    private static void persistResponse(HttpCollectorAgent collectorAgent, CollectionSetBuilder collectionSetBuilder, HttpResponse response) throws IOException {
        String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
        if (responseString != null && !"".equals(responseString)) {
            Locale responseLocale = null;
            Header[] headers = response.getHeaders("Content-Language");
            if (headers != null) {
                LOG.debug("doCollection: Trying to devise response's locale from Content-Language header.");
                if (headers.length == 1) {
                    if (headers[0].getValue().split(",").length == 1) {
                        String[] values = headers[0].getValue().split("-");
                        LOG.debug("doCollection: Found one Content-Language header with value: {}", (Object)headers[0].getValue());
                        switch (values.length) {
                            case 1: {
                                responseLocale = new Locale(values[0]);
                                break;
                            }
                            case 2: {
                                responseLocale = new Locale(values[0], values[1]);
                                break;
                            }
                            default: {
                                LOG.warn("doCollection: Ignoring Content-Language header with value {}. No support for more than 1 language subtag!", (Object)headers[0].getValue());
                                break;
                            }
                        }
                    } else {
                        LOG.warn("doCollection: Multiple languages specified. That doesn't make sense. Ignoring...");
                    }
                } else {
                    LOG.warn("doCollection: More than 1 Content-Language headers received. Ignoring them!");
                }
            }
            HttpCollector.processResponse(responseLocale, responseString, collectorAgent, collectionSetBuilder);
        }
    }

    private static String determineUserAgent(HttpCollectorAgent collectorAgent) {
        Url url = collectorAgent.getUriDef().getUrl();
        if (url.getUserAgent().isPresent()) {
            return (String)url.getUserAgent().get();
        }
        return null;
    }

    private static HttpVersion computeVersion(Uri uri) {
        return new HttpVersion(Integer.parseInt(uri.getUrl().getHttpVersion().substring(0, 1)), Integer.parseInt(uri.getUrl().getHttpVersion().substring(2)));
    }

    private static HttpRequestBase buildHttpMethod(HttpCollectorAgent collectorAgent) throws URISyntaxException {
        String virtualHost;
        URI uri = HttpCollector.buildUri(collectorAgent);
        Url url = collectorAgent.getUriDef().getUrl();
        Object method = "GET".equals(url.getMethod()) ? HttpCollector.buildGetMethod(uri, collectorAgent) : HttpCollector.buildPostMethod(uri, collectorAgent);
        if (url.getVirtualHost().isPresent() && !(virtualHost = (String)url.getVirtualHost().get()).trim().isEmpty()) {
            method.setHeader("Host", virtualHost);
        }
        return method;
    }

    private static HttpPost buildPostMethod(URI uri, HttpCollectorAgent collectorAgent) {
        HttpPost method = new HttpPost(uri);
        List<NameValuePair> postParams = HttpCollector.buildRequestParameters(collectorAgent);
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(postParams, StandardCharsets.UTF_8);
        method.setEntity((HttpEntity)entity);
        return method;
    }

    private static HttpGet buildGetMethod(URI uri, HttpCollectorAgent collectorAgent) {
        URI uriWithQueryString = null;
        List<NameValuePair> queryParams = HttpCollector.buildRequestParameters(collectorAgent);
        try {
            List params;
            StringBuilder query = new StringBuilder();
            query.append(URLEncodedUtils.format(queryParams, (Charset)StandardCharsets.UTF_8));
            if (uri.getQuery() != null && !uri.getQuery().trim().isEmpty()) {
                if (query.length() > 0) {
                    query.append("&");
                }
                query.append(uri.getQuery());
            }
            URIBuilder ub = new URIBuilder(uri);
            if (query.length() > 0 && !(params = URLEncodedUtils.parse((String)query.toString(), (Charset)StandardCharsets.UTF_8)).isEmpty()) {
                ub.setParameters(params);
            }
            uriWithQueryString = ub.build();
            return new HttpGet(uriWithQueryString);
        }
        catch (URISyntaxException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            return new HttpGet(uri);
        }
    }

    private static List<NameValuePair> buildRequestParameters(HttpCollectorAgent collectorAgent) {
        ArrayList<NameValuePair> retval = new ArrayList<NameValuePair>();
        if (collectorAgent.getUriDef().getUrl().getParameters() == null) {
            return retval;
        }
        for (Parameter p : collectorAgent.getUriDef().getUrl().getParameters()) {
            retval.add((NameValuePair)new BasicNameValuePair(p.getKey(), p.getValue()));
        }
        return retval;
    }

    private static URI buildUri(HttpCollectorAgent collectorAgent) throws URISyntaxException {
        HashMap<String, String> substitutions = new HashMap<String, String>();
        substitutions.put("ipaddr", InetAddressUtils.str((InetAddress)((InetAddress)collectorAgent.getAgent().getAddress())));
        substitutions.put("nodeid", Integer.toString(collectorAgent.getAgent().getNodeId()));
        URIBuilder ub = new URIBuilder();
        ub.setScheme(collectorAgent.getUriDef().getUrl().getScheme());
        ub.setHost(HttpCollector.substituteKeywords(substitutions, collectorAgent.getUriDef().getUrl().getHost(), "getHost"));
        ub.setPort(collectorAgent.getPort());
        ub.setPath(HttpCollector.substituteKeywords(substitutions, collectorAgent.getUriDef().getUrl().getPath(), "getURL"));
        String query = HttpCollector.substituteKeywords(substitutions, collectorAgent.getUriDef().getUrl().getQuery().orElse(null), "getQuery");
        List params = URLEncodedUtils.parse((String)query, (Charset)StandardCharsets.UTF_8);
        ub.setParameters(params);
        ub.setFragment(HttpCollector.substituteKeywords(substitutions, collectorAgent.getUriDef().getUrl().getFragment().orElse(null), "getFragment"));
        return ub.build();
    }

    private static String substituteKeywords(Map<String, String> substitutions, String urlFragment, String desc) {
        String newFragment = urlFragment;
        if (newFragment != null) {
            for (Map.Entry<String, String> entry : substitutions.entrySet()) {
                String key = entry.getKey();
                newFragment = newFragment.replaceAll("\\$\\{" + key + "\\}", entry.getValue());
            }
            if (LOG.isDebugEnabled() && newFragment.compareTo(urlFragment) != 0) {
                LOG.debug("doSubs: {} substituted as \"{}\"", (Object)desc, (Object)newFragment);
            }
        }
        return newFragment;
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return HttpCollectionConfigFactory.getInstance().getRrdRepository(collectionName);
    }

    private static void initHttpCollectionConfig() {
        try {
            LOG.debug("initialize: Initializing collector: {}", (Object)HttpCollector.class.getSimpleName());
            HttpCollectionConfigFactory.init();
        }
        catch (FileNotFoundException e) {
            LOG.error("initialize: Error locating configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            LOG.error("initialize: Error reading configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    static {
        ((DecimalFormat)PARSER).setParseBigDecimal(true);
        Security.addProvider((Provider)new EmptyKeyRelaxedTrustProvider());
    }

    public static class HttpCollectorException
    extends RuntimeException {
        private static final long serialVersionUID = 4413332529546573490L;

        HttpCollectorException(String message) {
            super(message);
        }

        HttpCollectorException(String message, Throwable e) {
            super(message, e);
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(super.toString());
            buffer.append(": client URL: ");
            return buffer.toString();
        }
    }

    private static class HttpCollectorAgent {
        private final CollectionAgent m_agent;
        private final Map<String, Object> m_parameters;
        private final HttpCollection m_httpCollection;
        private final CollectionSetBuilder m_collectionSetBuilder;
        private Uri m_uriDef;

        public Uri getUriDef() {
            return this.m_uriDef;
        }

        public HttpCollectorAgent(CollectionAgent agent, Map<String, Object> parameters, HttpCollection httpCollection, CollectionSetBuilder collectionSetBuilder) {
            this.m_agent = Objects.requireNonNull(agent);
            this.m_parameters = Objects.requireNonNull(parameters);
            this.m_httpCollection = Objects.requireNonNull(httpCollection);
            this.m_collectionSetBuilder = Objects.requireNonNull(collectionSetBuilder);
        }

        public void collect() {
            List uriDefs = this.m_httpCollection.getUris();
            Iterator iterator = uriDefs.iterator();
            while (iterator.hasNext()) {
                Uri uriDef;
                this.m_uriDef = uriDef = (Uri)iterator.next();
                try {
                    HttpCollector.doCollection(this, this.m_collectionSetBuilder);
                }
                catch (HttpCollectorException e) {
                    LOG.warn("collect: http collection failed", (Throwable)e);
                    this.m_collectionSetBuilder.withStatus(CollectionStatus.FAILED);
                }
            }
        }

        public CollectionAgent getAgent() {
            return this.m_agent;
        }

        public Map<String, Object> getParameters() {
            return this.m_parameters;
        }

        public int getPort() {
            int port = this.getUriDef().getUrl().getPort();
            if (port == 80 && this.m_parameters.containsKey(ServiceParameters.ParameterName.PORT.toString())) {
                try {
                    port = Integer.parseInt(this.m_parameters.get(ServiceParameters.ParameterName.PORT.toString()).toString());
                    LOG.debug("getPort: using service provided HTTP port {}", (Object)port);
                }
                catch (Exception e) {
                    LOG.warn("Malformed HTTP port on service definition.");
                }
            }
            return port;
        }
    }
}

