/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.slp.internal.msg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sblim.slp.ServiceLocationException;
import org.sblim.slp.internal.msg.MsgHeader;
import org.sblim.slp.internal.msg.ReplyMessage;
import org.sblim.slp.internal.msg.SLPInputStream;
import org.sblim.slp.internal.msg.SLPMessage;
import org.sblim.slp.internal.msg.SLPOutputStream;
import org.sblim.slp.internal.msg.SerializeOption;

public class ServiceReply
extends ReplyMessage {
    private List iURLEntries;
    private List iURLExceptions;

    public static SLPMessage parse(MsgHeader pHdr, SLPInputStream pInStr) throws ServiceLocationException, IOException {
        int errorCode = pInStr.read16();
        ArrayList urlExceptions = new ArrayList();
        List urlEntries = pInStr.readUrlList(urlExceptions);
        return new ServiceReply(pHdr, errorCode, urlEntries, urlExceptions);
    }

    public ServiceReply(int pErrorCode, List pURLEntries) {
        super(2, pErrorCode);
        this.iURLEntries = pURLEntries;
    }

    public ServiceReply(String pLangTag, int pErrorCode, List pURLEntries, List pURLExceptions) {
        super(2, pLangTag, pErrorCode);
        this.iURLEntries = pURLEntries;
        this.iURLExceptions = pURLExceptions;
    }

    public ServiceReply(MsgHeader pHeader, int pErrorCode, List pURLEntries, List pURLExceptions) {
        super(pHeader, pErrorCode);
        this.iURLEntries = pURLEntries;
        this.iURLExceptions = pURLExceptions;
    }

    public Iterator getResultIterator() {
        return this.iURLEntries == null ? null : this.iURLEntries.iterator();
    }

    public Iterator getExceptionIterator() {
        return this.iURLExceptions == null ? null : this.iURLExceptions.iterator();
    }

    public List getURLEntries() {
        return this.iURLEntries;
    }

    public List getURLExceptions() {
        return this.iURLExceptions;
    }

    protected boolean serializeBody(SLPOutputStream pOutStr, SerializeOption pOption) {
        return pOutStr.write16(this.getErrorCode()) && pOutStr.writeURLList(this.iURLEntries);
    }
}

