/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.api;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class InterfaceToNodeMap {
    private final ReadWriteLock m_lock = new ReentrantReadWriteLock();
    private final Map<LocationIpAddressKey, Integer> m_managedAddresses = new HashMap<LocationIpAddressKey, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addManagedAddress(String location, InetAddress address, int nodeId) {
        this.m_lock.writeLock().lock();
        try {
            Integer retval = this.m_managedAddresses.put(new LocationIpAddressKey(location, address), nodeId);
            int n = retval == null ? -1 : retval;
            return n;
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeManagedAddress(String location, InetAddress address) {
        this.m_lock.writeLock().lock();
        try {
            Integer retval = this.m_managedAddresses.remove(new LocationIpAddressKey(location, address));
            int n = retval == null ? -1 : retval;
            return n;
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    public int size() {
        this.m_lock.readLock().lock();
        try {
            int n = this.m_managedAddresses.size();
            return n;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNodeId(String location, InetAddress address) {
        this.m_lock.readLock().lock();
        try {
            Integer retval = this.m_managedAddresses.get(new LocationIpAddressKey(location, address));
            int n = retval == null ? -1 : retval;
            return n;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    public void setManagedAddresses(Map<LocationIpAddressKey, Integer> addresses) {
        this.m_lock.writeLock().lock();
        try {
            this.m_managedAddresses.clear();
            this.m_managedAddresses.putAll(addresses);
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    public String toString() {
        this.m_lock.readLock().lock();
        try {
            String string = String.format("InterfaceToNodeMap[managedAddresses='%s']", this.m_managedAddresses);
            return string;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    public static class LocationIpAddressKey {
        private final String m_location;
        private final InetAddress m_ipAddress;

        public LocationIpAddressKey(String location, InetAddress ipAddress) {
            this.m_location = location != null ? location : "Default";
            this.m_ipAddress = Objects.requireNonNull(ipAddress);
        }

        public InetAddress getIpAddress() {
            return this.m_ipAddress;
        }

        public String getLocation() {
            return this.m_location;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            LocationIpAddressKey other = (LocationIpAddressKey)obj;
            return Objects.equals(this.m_ipAddress, other.m_ipAddress) && Objects.equals(this.m_location, other.m_location);
        }

        public int hashCode() {
            return Objects.hash(this.m_ipAddress, this.m_location);
        }

        public String toString() {
            return String.format("LocationIpAddressKey[location='%s', ipAddress='%s']", this.m_location, this.m_ipAddress);
        }
    }
}

