/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.EventLabelComparator;
import org.opennms.netmgt.xml.eventconf.EventMatchers;
import org.opennms.netmgt.xml.eventconf.EventOrdering;
import org.opennms.netmgt.xml.eventconf.Events;
import org.opennms.netmgt.xml.eventconf.Field;
import org.opennms.netmgt.xml.eventconf.Partition;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;

public class DefaultEventConfDao
implements EventConfDao,
InitializingBean {
    private static final String DEFAULT_PROGRAMMATIC_STORE_RELATIVE_PATH = "events/programmatic.events.xml";
    private String m_programmaticStoreRelativePath = "events/programmatic.events.xml";
    private Events m_events;
    private Resource m_configResource;
    private Partition m_partition;
    private Map<String, Long> m_lastModifiedEventFiles = new LinkedHashMap<String, Long>();

    public String getProgrammaticStoreRelativeUrl() {
        return this.m_programmaticStoreRelativePath;
    }

    public void setProgrammaticStoreRelativeUrl(String programmaticStoreRelativeUrl) {
        this.m_programmaticStoreRelativePath = programmaticStoreRelativeUrl;
    }

    public void reload() throws DataAccessException {
        try {
            this.reloadConfig();
        }
        catch (Exception e) {
            throw new DataRetrievalFailureException("Unabled to load " + this.m_configResource, (Throwable)e);
        }
    }

    public List<Event> getEvents(final String uei) {
        List events = (List)this.m_events.forEachEvent(new ArrayList(), (Events.EventCallback)new Events.EventCallback<List<Event>>(){

            public List<Event> process(List<Event> accum, Event event) {
                if (uei.equals(event.getUei())) {
                    accum.add(event);
                }
                return accum;
            }
        });
        return events.isEmpty() ? null : events;
    }

    public List<String> getEventUEIs() {
        return (List)this.m_events.forEachEvent(new ArrayList(), (Events.EventCallback)new Events.EventCallback<List<String>>(){

            public List<String> process(List<String> ueis, Event event) {
                ueis.add(event.getUei());
                return ueis;
            }
        });
    }

    public Map<String, String> getEventLabels() {
        return (Map)this.m_events.forEachEvent(new TreeMap(), (Events.EventCallback)new Events.EventCallback<Map<String, String>>(){

            public Map<String, String> process(Map<String, String> ueiToLabelMap, Event event) {
                ueiToLabelMap.put(event.getUei(), event.getEventLabel());
                return ueiToLabelMap;
            }
        });
    }

    public String getEventLabel(String uei) {
        Event event = this.findByUei(uei);
        return event == null ? null : event.getEventLabel();
    }

    public void saveCurrent() {
        this.m_events.save(this.m_configResource);
    }

    public List<Event> getAllEvents() {
        return (List)this.m_events.forEachEvent(new ArrayList(), (Events.EventCallback)new Events.EventCallback<List<Event>>(){

            public List<Event> process(List<Event> accum, Event event) {
                accum.add(event);
                return accum;
            }
        });
    }

    public List<Event> getEventsByLabel() {
        SortedSet events = (SortedSet)this.m_events.forEachEvent(new TreeSet(new EventLabelComparator()), (Events.EventCallback)new Events.EventCallback<SortedSet<Event>>(){

            public SortedSet<Event> process(SortedSet<Event> accum, Event event) {
                accum.add(event);
                return accum;
            }
        });
        return new ArrayList<Event>(events);
    }

    public void addEvent(Event event) {
        this.m_events.addEvent(event);
        this.m_events.initialize(this.m_partition, new EventOrdering());
    }

    public void addEventToProgrammaticStore(Event event) {
        Events programmaticEvents = this.m_events.getLoadEventsByFile(this.m_programmaticStoreRelativePath);
        if (programmaticEvents == null) {
            programmaticEvents = new Events();
            this.m_events.addLoadedEventFile(this.m_programmaticStoreRelativePath, programmaticEvents);
        }
        programmaticEvents.addEvent(event);
        this.m_events.initialize(this.m_partition, new EventOrdering());
    }

    public boolean removeEventFromProgrammaticStore(Event event) {
        Events programmaticEvents = this.m_events.getLoadEventsByFile(this.m_programmaticStoreRelativePath);
        if (programmaticEvents == null) {
            return false;
        }
        programmaticEvents.removeEvent(event);
        if (programmaticEvents.getEvents().size() <= 0) {
            this.m_events.removeLoadedEventFile(this.m_programmaticStoreRelativePath);
        }
        this.m_events.initialize(this.m_partition, new EventOrdering());
        return true;
    }

    public boolean isSecureTag(String tag) {
        return this.m_events.isSecureTag(tag);
    }

    public Event findByUei(final String uei) {
        if (uei == null) {
            return null;
        }
        return this.m_events.findFirstMatchingEvent(new Events.EventCriteria(){

            public boolean matches(Event e) {
                return uei.equals(e.getUei());
            }
        });
    }

    public Event findByEvent(org.opennms.netmgt.xml.event.Event matchingEvent) {
        return this.m_events.findFirstMatchingEvent(matchingEvent);
    }

    public Events getRootEvents() {
        return this.m_events;
    }

    public void setConfigResource(Resource configResource) throws IOException {
        this.m_configResource = configResource;
    }

    public void afterPropertiesSet() throws DataAccessException {
        this.loadConfig();
    }

    private synchronized void reloadConfig() throws DataAccessException {
        try {
            Events events = (Events)JaxbUtils.unmarshal(Events.class, (Resource)this.m_configResource);
            HashSet eventFiles = new HashSet();
            eventFiles.addAll(events.getEventFiles());
            for (String eventFile : this.m_events.getEventFiles()) {
                if (!eventFiles.contains(eventFile)) {
                    this.m_lastModifiedEventFiles.remove(eventFile);
                    continue;
                }
                events.addLoadedEventFile(eventFile, this.m_events.getLoadEventsByFile(eventFile));
            }
            events.loadEventFilesIfModified(this.m_configResource, this.m_lastModifiedEventFiles);
            events.initialize(this.m_partition, new EventOrdering());
            this.m_events = events;
        }
        catch (Exception e) {
            throw new DataRetrievalFailureException("Unabled to load " + this.m_configResource, (Throwable)e);
        }
    }

    private synchronized void loadConfig() throws DataAccessException {
        try {
            Events events = (Events)JaxbUtils.unmarshal(Events.class, (Resource)this.m_configResource);
            this.m_lastModifiedEventFiles = events.loadEventFiles(this.m_configResource);
            this.m_partition = new EnterpriseIdPartition();
            events.initialize(this.m_partition, new EventOrdering());
            this.m_events = events;
        }
        catch (Exception e) {
            throw new DataRetrievalFailureException("Unabled to load " + this.m_configResource, (Throwable)e);
        }
    }

    private static class EnterpriseIdPartition
    implements Partition {
        private Field m_field = EventMatchers.field((String)"id");

        private EnterpriseIdPartition() {
        }

        public List<String> group(Event eventConf) {
            List keys = eventConf.getMaskElementValues("id");
            if (keys == null) {
                return null;
            }
            for (String key : keys) {
                if (key.endsWith("%")) {
                    return null;
                }
                if (!key.startsWith("~")) continue;
                return null;
            }
            return keys;
        }

        public String group(org.opennms.netmgt.xml.event.Event matchingEvent) {
            return this.m_field.get(matchingEvent);
        }
    }
}

