/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.internal.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.netmgt.collection.api.Parameter;
import org.opennms.netmgt.config.api.collection.IExpression;
import org.opennms.netmgt.config.datacollection.Collect;
import org.opennms.netmgt.config.datacollection.Group;
import org.opennms.netmgt.config.datacollection.IncludeCollection;
import org.opennms.netmgt.config.datacollection.IpList;
import org.opennms.netmgt.config.datacollection.MibObj;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.config.datacollection.SnmpCollection;
import org.opennms.netmgt.config.datacollection.SystemDef;
import org.opennms.netmgt.config.internal.collection.AbstractDatacollectionConfigVisitor;
import org.opennms.netmgt.config.internal.collection.ColumnImpl;
import org.opennms.netmgt.config.internal.collection.DataCollectionConfigImpl;
import org.opennms.netmgt.config.internal.collection.DataCollectionGroupImpl;
import org.opennms.netmgt.config.internal.collection.GroupImpl;
import org.opennms.netmgt.config.internal.collection.MibObjectImpl;
import org.opennms.netmgt.config.internal.collection.ResourceTypeImpl;
import org.opennms.netmgt.config.internal.collection.SnmpCollectionImpl;
import org.opennms.netmgt.config.internal.collection.SystemDefImpl;
import org.opennms.netmgt.config.internal.collection.TableImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCollectionConfigConverter
extends AbstractDatacollectionConfigVisitor {
    private static Logger LOG = LoggerFactory.getLogger(DataCollectionConfigConverter.class);
    private DataCollectionConfigImpl m_config = new DataCollectionConfigImpl();
    private SnmpCollectionImpl m_currentSnmpCollection = null;
    private DataCollectionGroupImpl m_currentDataCollectionGroup = null;
    private String m_groupName = null;
    private GroupImpl m_currentGroup = null;
    private TableImpl m_currentTable = null;
    private SystemDefImpl m_currentSystemDef = null;
    private Map<String, ColumnImpl> m_columns = new HashMap<String, ColumnImpl>();
    private Map<String, MibObjectImpl> m_mibs = new HashMap<String, MibObjectImpl>();

    public DataCollectionConfigImpl getDataCollectionConfig() {
        return this.m_config;
    }

    @Override
    public void visitSnmpCollection(SnmpCollection collection) {
        ResourceTypeImpl ifIndexResourceType = new ResourceTypeImpl("ifIndex", "Interfaces (MIB-2 ifTable)");
        ifIndexResourceType.setResourceNameTemplate("${ifDescr}-${ifPhysAddr}");
        ifIndexResourceType.setResourceLabelTemplate("${ifDescr}-${ifPhysAddr}");
        ifIndexResourceType.setResourceKindTemplate("${ifType}");
        ifIndexResourceType.addColumn(".1.3.6.1.2.1.2.2.1.2", "ifDescr", "string");
        ifIndexResourceType.addColumn(".1.3.6.1.2.1.2.2.1.6", "ifPhysAddr", "string", "1x:");
        ifIndexResourceType.addColumn(".1.3.6.1.2.1.2.2.1.3", "ifType", "string");
        ifIndexResourceType.addColumn(".1.3.6.1.2.1.31.1.1.1.1", "ifName", "string");
        this.m_currentSnmpCollection = new SnmpCollectionImpl(collection.getName());
        this.m_currentDataCollectionGroup = new DataCollectionGroupImpl(collection.getName() + "-all");
        this.m_currentSnmpCollection.addDataCollectionGroup(this.m_currentDataCollectionGroup);
        this.m_currentDataCollectionGroup.addResourceType(ifIndexResourceType);
    }

    @Override
    public void visitSnmpCollectionComplete() {
        this.m_config.addSnmpCollection(this.m_currentSnmpCollection);
        this.m_currentDataCollectionGroup = null;
        this.m_currentSnmpCollection = null;
    }

    @Override
    public void visitIncludeCollection(IncludeCollection includeCollection) {
        this.m_currentSnmpCollection.addIncludedGroup(includeCollection.getDataCollectionGroup());
    }

    @Override
    public void visitGroup(Group group) {
        this.m_groupName = group.getName();
    }

    @Override
    public void visitGroupComplete() {
        if (this.m_currentTable != null) {
            this.m_currentDataCollectionGroup.addTable(this.m_currentTable);
            this.m_currentTable = null;
        } else if (this.m_currentGroup != null) {
            this.m_currentDataCollectionGroup.addGroup(this.m_currentGroup);
            this.m_currentGroup = null;
        } else {
            LOG.warn("No table or group in-process!");
        }
        this.m_groupName = null;
    }

    @Override
    public void visitMibObj(MibObj mibObj) {
        String instance = mibObj.getInstance();
        if (this.m_currentTable == null && this.m_currentGroup == null) {
            if (this.m_groupName == null) {
                throw new IllegalStateException("visitMibObj called, but no current group name has been set!");
            }
            try {
                Integer.parseInt(instance, 10);
                this.m_currentGroup = new GroupImpl(this.m_groupName);
            }
            catch (NumberFormatException e) {
                this.m_currentTable = new TableImpl(this.m_groupName, instance);
            }
        }
        if (this.m_currentTable != null) {
            ColumnImpl column = new ColumnImpl(mibObj.getOid(), mibObj.getAlias(), mibObj.getType());
            this.m_currentTable.addColumn(column);
            this.m_columns.put(column.getAlias(), column);
        } else if (this.m_currentGroup != null) {
            MibObjectImpl obj = new MibObjectImpl();
            obj.setOid(mibObj.getOid());
            obj.setInstance(instance);
            obj.setAlias(mibObj.getAlias());
            obj.setType(mibObj.getType());
            this.m_currentGroup.addMibObject(obj);
            this.m_mibs.put(obj.getAlias(), obj);
        } else {
            throw new IllegalStateException("visitMibObj called, but no current table or group initialized!");
        }
    }

    @Override
    public void visitSystemDef(SystemDef systemDef) {
        SystemDefImpl def = new SystemDefImpl(systemDef.getName());
        if (systemDef.getSysoid() != null) {
            def.setSysoid(systemDef.getSysoid());
        } else if (systemDef.getSysoidMask() != null) {
            def.setSysoidMask(systemDef.getSysoidMask());
        }
        this.m_currentSystemDef = def;
    }

    @Override
    public void visitSystemDefComplete() {
        this.m_currentDataCollectionGroup.addSystemDef(this.m_currentSystemDef);
        this.m_currentSystemDef = null;
    }

    @Override
    public void visitIpList(IpList ipList) {
        LOG.debug("visitIpList({})", (Object)ipList);
    }

    @Override
    public void visitCollect(Collect collect) {
        if (this.m_currentSystemDef == null) {
            throw new IllegalStateException("visitCollect called, but we don't have a current SystemDefImpl in-progress!");
        }
        this.m_currentSystemDef.setIncludes(collect.getIncludeGroups().toArray(new String[0]));
    }

    @Override
    public void visitResourceType(ResourceType resourceType) {
        String strategy;
        ResourceTypeImpl type = new ResourceTypeImpl(resourceType.getName(), resourceType.getLabel());
        if (resourceType.getResourceLabel() != null && !resourceType.getResourceLabel().trim().isEmpty()) {
            type.setResourceLabelTemplate(resourceType.getResourceLabel());
        }
        if ((strategy = resourceType.getStorageStrategy().getClazz()).endsWith(".SiblingColumnStorageStrategy")) {
            for (Parameter parameter : resourceType.getStorageStrategy().getParameters()) {
                String name;
                if (!"sibling-column-name".equals(parameter.getKey()) || (name = parameter.getValue()) == null || name.trim().isEmpty()) continue;
                type.setResourceNameTemplate("${" + name + "}");
                break;
            }
        } else if (strategy.endsWith(".IndexStorageStrategy")) {
            type.setResourceNameTemplate("${index}");
            if (type.getResourceLabelExpression() == null || type.getResourceLabelExpression().getTemplate() == null) {
                type.setResourceLabelTemplate("${index}");
            }
        }
        TreeSet<String> parameters = new TreeSet<String>();
        parameters.addAll(DataCollectionConfigConverter.getParameters(type.getResourceKindExpression()));
        parameters.addAll(DataCollectionConfigConverter.getParameters(type.getResourceLabelExpression()));
        parameters.addAll(DataCollectionConfigConverter.getParameters(type.getResourceNameExpression()));
        for (String parameter : parameters) {
            if (this.m_columns.containsKey(parameter)) {
                ColumnImpl column = this.m_columns.get(parameter);
                type.addColumn(column);
                continue;
            }
            if (this.m_mibs.containsKey(parameter)) {
                MibObjectImpl mib = this.m_mibs.get(parameter);
                type.addColumn(new ColumnImpl(mib));
                continue;
            }
            if ("index".equals(parameter)) continue;
            LOG.warn("Unable to locate column/mibObject for parameter: {}", (Object)parameter);
        }
        this.m_currentDataCollectionGroup.addResourceType(type);
    }

    static Collection<String> getParameters(IExpression expression) {
        if (expression == null) {
            return Collections.emptySet();
        }
        String template = expression.getTemplate();
        if (template == null) {
            return Collections.emptySet();
        }
        Pattern p = Pattern.compile("\\$\\{([^\\}]*)\\}");
        Matcher m = p.matcher(template);
        TreeSet<String> matches = new TreeSet<String>();
        while (m.find()) {
            for (int i = 0; i < m.groupCount(); ++i) {
                matches.add(m.group(i + 1));
            }
        }
        return matches;
    }
}

