/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.vmware;

import com.vmware.vim25.CustomFieldDef;
import com.vmware.vim25.CustomFieldStringValue;
import com.vmware.vim25.CustomFieldValue;
import com.vmware.vim25.mo.Datastore;
import com.vmware.vim25.mo.DistributedVirtualPortgroup;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.Network;
import com.vmware.vim25.mo.VirtualMachine;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.http.conn.util.InetAddressUtils;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionAsset;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategory;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredService;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.opennms.netmgt.provision.service.vmware.VmwareImportRequest;
import org.opennms.protocols.vmware.VmwareViJavaAccess;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmwareImporter {
    private static final Logger logger = LoggerFactory.getLogger(VmwareImporter.class);
    private final VmwareImportRequest request;
    private Map<String, String> m_hostSystemMap = new HashMap<String, String>();
    private Requisition m_requisition = null;

    public VmwareImporter(VmwareImportRequest request) {
        this.request = Objects.requireNonNull(request);
    }

    public Requisition getRequisition() {
        logger.debug("Getting existing requisition (if any) for VMware management server {}", (Object)this.request.getHostname());
        Requisition curReq = this.request.getExistingRequisition();
        logger.debug("Building new requisition for VMware management server {}", (Object)this.request.getHostname());
        Requisition newReq = this.buildVMwareRequisition();
        logger.debug("Finished building new requisition for VMware management server {}", (Object)this.request.getHostname());
        if (curReq == null) {
            if (newReq == null) {
                newReq = new Requisition(this.request.getForeignSource());
            }
        } else if (newReq == null) {
            newReq = curReq;
        } else {
            for (RequisitionNode newNode : newReq.getNodes()) {
                for (RequisitionNode curNode : curReq.getNodes()) {
                    if (!newNode.getForeignId().equals(curNode.getForeignId())) continue;
                    for (RequisitionAsset asset : curNode.getAssets()) {
                        if (asset.getName().startsWith("vmware")) continue;
                        newNode.putAsset(asset);
                    }
                    for (RequisitionCategory cat : curNode.getCategories()) {
                        if (cat.getName().startsWith("VMWare")) continue;
                        newNode.putCategory(cat);
                    }
                    for (RequisitionInterface intf : curNode.getInterfaces()) {
                        RequisitionInterface newIntf;
                        List<RequisitionMonitoredService> services = this.getManualyConfiguredServices(intf);
                        if (services.isEmpty() || (newIntf = this.getRequisitionInterface(newNode, intf.getIpAddr())) == null) continue;
                        newIntf.getMonitoredServices().addAll(services);
                    }
                }
            }
        }
        return newReq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Requisition buildVMwareRequisition() {
        VmwareViJavaAccess vmwareViJavaAccess = null;
        this.m_requisition = new Requisition(this.request.getForeignSource());
        logger.debug("Creating new VIJava access object for host {} ...", (Object)this.request.getHostname());
        if (this.request.getHostname() == null || "".equals(this.request.getHostname()) || this.request.getPassword() == null || "".equals(this.request.getPassword())) {
            logger.info("No credentials found for connecting to host {}, trying anonymously...", (Object)this.request.getHostname());
            try {
                vmwareViJavaAccess = new VmwareViJavaAccess(this.request.getHostname());
            }
            catch (IOException e) {
                logger.warn("Error initialising VMware connection to '{}': '{}'", (Object)this.request.getHostname(), (Object)e.getMessage());
                return null;
            }
        } else {
            vmwareViJavaAccess = new VmwareViJavaAccess(this.request.getHostname(), this.request.getUsername(), this.request.getPassword());
        }
        logger.debug("Successfully created new VIJava access object for host {}", (Object)this.request.getHostname());
        logger.debug("Connecting VIJava access for host {} ...", (Object)this.request.getHostname());
        try {
            vmwareViJavaAccess.connect();
        }
        catch (MalformedURLException e) {
            logger.warn("Error connecting VMware management server '{}': '{}'", (Object)this.request.getHostname(), (Object)e.getMessage());
            return null;
        }
        catch (RemoteException e) {
            logger.warn("Error connecting VMware management server '{}': '{}'", (Object)this.request.getHostname(), (Object)e.getMessage());
            return null;
        }
        logger.debug("Successfully connected VIJava access for host {}", (Object)this.request.getHostname());
        logger.debug("Starting to enumerate VMware managed objects from host {} ...", (Object)this.request.getHostname());
        try {
            int apiVersion = vmwareViJavaAccess.getMajorApiVersion();
            logger.debug("Starting to iterate host system managed objects from host {} ...", (Object)this.request.getHostname());
            this.iterateHostSystems(vmwareViJavaAccess, apiVersion);
            logger.debug("Done iterating host system managed objects from host {}", (Object)this.request.getHostname());
            logger.debug("Starting to iterate VM managed objects from host {} ...", (Object)this.request.getHostname());
            this.iterateVirtualMachines(vmwareViJavaAccess, apiVersion);
            logger.debug("Done iterating VM managed objects from host {}", (Object)this.request.getHostname());
        }
        catch (RemoteException e) {
            logger.warn("Error retrieving managed objects from VMware management server '{}': '{}'", (Object)this.request.getHostname(), (Object)e.getMessage());
            Requisition requisition = null;
            return requisition;
        }
        finally {
            vmwareViJavaAccess.disconnect();
        }
        return this.m_requisition;
    }

    /*
     * Unable to fully structure code
     */
    private RequisitionNode createRequisitionNode(Set<String> ipAddresses, ManagedEntity managedEntity, int apiVersion, VmwareViJavaAccess vmwareViJavaAccess) {
        block69: {
            requisitionNode = new RequisitionNode();
            requisitionNode.setNodeLabel(managedEntity.getName());
            requisitionNode.setForeignId(managedEntity.getMOR().getVal());
            if (managedEntity instanceof VirtualMachine) {
                firstInterface = true;
                for (String ipAddress : ipAddresses) {
                    try {
                        if ((!this.request.isPersistIPv4() || !InetAddressUtils.isIPv4Address((String)ipAddress)) && (!this.request.isPersistIPv6() || !InetAddressUtils.isIPv6Address((String)ipAddress)) || (inetAddress = InetAddress.getByName(ipAddress)).isLoopbackAddress()) continue;
                        requisitionInterface = new RequisitionInterface();
                        requisitionInterface.setIpAddr(ipAddress);
                        if (firstInterface) {
                            requisitionInterface.setSnmpPrimary(PrimaryType.PRIMARY);
                            for (String service : this.request.getVirtualMachineServices()) {
                                requisitionInterface.insertMonitoredService(new RequisitionMonitoredService(service.trim()));
                            }
                            firstInterface = false;
                        } else {
                            requisitionInterface.setSnmpPrimary(PrimaryType.SECONDARY);
                        }
                        requisitionInterface.setManaged(Boolean.TRUE);
                        requisitionInterface.setStatus(1);
                        requisitionNode.putInterface(requisitionInterface);
                    }
                    catch (UnknownHostException unknownHostException) {
                        VmwareImporter.logger.warn("Invalid IP address '{}'", (Object)unknownHostException.getMessage());
                    }
                }
            } else if (managedEntity instanceof HostSystem) {
                reachableInterfaceFound = false;
                firstInterface = true;
                requisitionInterfaceList = new ArrayList<RequisitionInterface>();
                primaryInterfaceCandidate = null;
                for (String ipAddress : ipAddresses) {
                    try {
                        if ((!this.request.isPersistIPv4() || !InetAddressUtils.isIPv4Address((String)ipAddress)) && (!this.request.isPersistIPv6() || !InetAddressUtils.isIPv6Address((String)ipAddress)) || (inetAddress = InetAddress.getByName(ipAddress)).isLoopbackAddress()) continue;
                        requisitionInterface = new RequisitionInterface();
                        requisitionInterface.setIpAddr(ipAddress);
                        if (firstInterface) {
                            primaryInterfaceCandidate = requisitionInterface;
                            firstInterface = false;
                        }
                        if (!reachableInterfaceFound && this.reachableCimService(vmwareViJavaAccess, (HostSystem)managedEntity, ipAddress)) {
                            primaryInterfaceCandidate = requisitionInterface;
                            reachableInterfaceFound = true;
                        }
                        requisitionInterface.setManaged(Boolean.TRUE);
                        requisitionInterface.setStatus(Integer.valueOf(1));
                        requisitionInterface.setSnmpPrimary(PrimaryType.SECONDARY);
                        requisitionInterfaceList.add(requisitionInterface);
                    }
                    catch (UnknownHostException unknownHostException) {
                        VmwareImporter.logger.warn("Invalid IP address '{}'", (Object)unknownHostException.getMessage());
                    }
                }
                if (primaryInterfaceCandidate != null) {
                    if (reachableInterfaceFound) {
                        VmwareImporter.logger.warn("Found reachable primary interface '{}'", (Object)primaryInterfaceCandidate.getIpAddr());
                    } else {
                        VmwareImporter.logger.warn("Only non-reachable interfaces found, using first one for primary interface '{}'", (Object)primaryInterfaceCandidate.getIpAddr());
                    }
                    primaryInterfaceCandidate.setSnmpPrimary(PrimaryType.PRIMARY);
                    for (String service : this.request.getHostSystemServices()) {
                        if (!reachableInterfaceFound && "VMwareCim-HostSystem".equals(service)) continue;
                        primaryInterfaceCandidate.insertMonitoredService(new RequisitionMonitoredService(service.trim()));
                    }
                } else {
                    VmwareImporter.logger.warn("No primary interface found");
                }
                for (RequisitionInterface requisitionInterface : requisitionInterfaceList) {
                    requisitionNode.putInterface(requisitionInterface);
                }
            } else {
                VmwareImporter.logger.error("Undefined type of managedEntity '{}'", (Object)managedEntity.getMOR().getType());
                return null;
            }
            powerState = "unknown";
            vmwareTopologyInfo = new StringBuffer();
            parentEntity = managedEntity.getParent();
            do {
                if (vmwareTopologyInfo.length() > 0) {
                    vmwareTopologyInfo.append(", ");
                }
                try {
                    if (parentEntity != null && parentEntity.getMOR() != null) {
                        vmwareTopologyInfo.append(parentEntity.getMOR().getVal() + "/" + URLEncoder.encode(parentEntity.getName(), StandardCharsets.UTF_8.name()));
                        continue;
                    }
                    VmwareImporter.logger.warn("Can't add topologyInformation because either the parentEntity or the MOR is null for " + managedEntity.getName());
                }
                catch (UnsupportedEncodingException e) {
                    VmwareImporter.logger.warn("Unsupported encoding '{}'", (Object)e.getMessage());
                }
            } while ((parentEntity = parentEntity == null ? null : parentEntity.getParent()) != null);
            if (managedEntity instanceof HostSystem) {
                hostSystem = (HostSystem)managedEntity;
                hostRuntimeInfo = hostSystem.getRuntime();
                if (hostRuntimeInfo == null) {
                    VmwareImporter.logger.debug("hostRuntimeInfo=null");
                } else {
                    hostSystemPowerState = hostRuntimeInfo.getPowerState();
                    if (hostSystemPowerState == null) {
                        VmwareImporter.logger.debug("hostSystemPowerState=null");
                    } else {
                        powerState = hostSystemPowerState.toString();
                    }
                }
                try {
                    if (this.request.isTopologyDatastores()) {
                        for (Datastore datastore : hostSystem.getDatastores()) {
                            if (vmwareTopologyInfo.length() > 0) {
                                vmwareTopologyInfo.append(", ");
                            }
                            try {
                                vmwareTopologyInfo.append(datastore.getMOR().getVal() + "/" + URLEncoder.encode(datastore.getSummary().getName(), StandardCharsets.UTF_8.name()));
                            }
                            catch (UnsupportedEncodingException e) {
                                VmwareImporter.logger.warn("Unsupported encoding '{}'", (Object)e.getMessage());
                            }
                        }
                    }
                }
                catch (RemoteException e) {
                    VmwareImporter.logger.warn("Cannot retrieve datastores for managedEntity '{}': '{}'", (Object)managedEntity.getMOR().getVal(), (Object)e.getMessage());
                }
                try {
                    if (!this.request.isTopologyNetworks()) ** GOTO lbl191
                    for (Network network : hostSystem.getNetworks()) {
                        if (vmwareTopologyInfo.length() > 0) {
                            vmwareTopologyInfo.append(", ");
                        }
                        try {
                            if (network instanceof DistributedVirtualPortgroup && !this.request.isTopologyPortGroups()) continue;
                            vmwareTopologyInfo.append(network.getMOR().getVal() + "/" + URLEncoder.encode(network.getSummary().getName(), StandardCharsets.UTF_8.name()));
                        }
                        catch (UnsupportedEncodingException e) {
                            VmwareImporter.logger.warn("Unsupported encoding '{}'", (Object)e.getMessage());
                        }
                    }
                }
                catch (RemoteException e) {
                    VmwareImporter.logger.warn("Cannot retrieve networks for managedEntity '{}': '{}'", (Object)managedEntity.getMOR().getVal(), (Object)e.getMessage());
                }
            } else if (managedEntity instanceof VirtualMachine) {
                virtualMachine = (VirtualMachine)managedEntity;
                virtualMachineRuntimeInfo = virtualMachine.getRuntime();
                if (virtualMachineRuntimeInfo == null) {
                    VmwareImporter.logger.debug("virtualMachineRuntimeInfo=null");
                } else {
                    virtualMachinePowerState = virtualMachineRuntimeInfo.getPowerState();
                    if (virtualMachinePowerState == null) {
                        VmwareImporter.logger.debug("virtualMachinePowerState=null");
                    } else {
                        powerState = virtualMachinePowerState.toString();
                    }
                }
                try {
                    if (this.request.isTopologyDatastores()) {
                        for (Datastore datastore : virtualMachine.getDatastores()) {
                            if (vmwareTopologyInfo.length() > 0) {
                                vmwareTopologyInfo.append(", ");
                            }
                            try {
                                vmwareTopologyInfo.append(datastore.getMOR().getVal() + "/" + URLEncoder.encode(datastore.getSummary().getName(), StandardCharsets.UTF_8.name()));
                            }
                            catch (UnsupportedEncodingException e) {
                                VmwareImporter.logger.warn("Unsupported encoding '{}'", (Object)e.getMessage());
                            }
                        }
                    }
                }
                catch (RemoteException e) {
                    VmwareImporter.logger.warn("Cannot retrieve datastores for managedEntity '{}': '{}'", (Object)managedEntity.getMOR().getVal(), (Object)e.getMessage());
                }
                try {
                    if (this.request.isTopologyNetworks()) {
                        for (Network network : virtualMachine.getNetworks()) {
                            if (vmwareTopologyInfo.length() > 0) {
                                vmwareTopologyInfo.append(", ");
                            }
                            try {
                                if (network instanceof DistributedVirtualPortgroup && !this.request.isTopologyPortGroups()) continue;
                                vmwareTopologyInfo.append(network.getMOR().getVal() + "/" + URLEncoder.encode(network.getSummary().getName(), StandardCharsets.UTF_8.name()));
                            }
                            catch (UnsupportedEncodingException e) {
                                VmwareImporter.logger.warn("Unsupported encoding '{}'", (Object)e.getMessage());
                            }
                        }
                    }
                }
                catch (RemoteException e) {
                    VmwareImporter.logger.warn("Cannot retrieve networks for managedEntity '{}': '{}'", (Object)managedEntity.getMOR().getVal(), (Object)e.getMessage());
                }
                if (vmwareTopologyInfo.length() > 0) {
                    vmwareTopologyInfo.append(", ");
                }
                try {
                    if (this.m_hostSystemMap.get(virtualMachine.getRuntime().getHost().getVal()) != null) {
                        vmwareTopologyInfo.append(virtualMachine.getRuntime().getHost().getVal() + "/" + URLEncoder.encode(this.m_hostSystemMap.get(virtualMachine.getRuntime().getHost().getVal()), StandardCharsets.UTF_8.name()));
                        break block69;
                    }
                    VmwareImporter.logger.warn("Problem building topology information for virtual machine '{}' with power state '{}' running on host system '{}'", new Object[]{virtualMachine.getMOR().getVal(), powerState, virtualMachine.getRuntime().getHost().getVal()});
                }
                catch (UnsupportedEncodingException e) {
                    VmwareImporter.logger.warn("Unsupported encoding '{}'", (Object)e.getMessage());
                }
            } else {
                VmwareImporter.logger.error("Undefined type of managedEntity '{}'", (Object)managedEntity.getMOR().getType());
                return null;
            }
        }
        requisitionAssetHostname = new RequisitionAsset("vmwareManagementServer", this.request.getHostname());
        requisitionNode.putAsset(requisitionAssetHostname);
        requisitionAssetType = new RequisitionAsset("vmwareManagedEntityType", managedEntity instanceof HostSystem != false ? "HostSystem" : "VirtualMachine");
        requisitionNode.putAsset(requisitionAssetType);
        requisitionAssetId = new RequisitionAsset("vmwareManagedObjectId", managedEntity.getMOR().getVal());
        requisitionNode.putAsset(requisitionAssetId);
        requisitionAssetTopologyInfo = new RequisitionAsset("vmwareTopologyInfo", vmwareTopologyInfo.toString());
        requisitionNode.putAsset(requisitionAssetTopologyInfo);
        requisitionAssetState = new RequisitionAsset("vmwareState", powerState);
        requisitionNode.putAsset(requisitionAssetState);
        requisitionNode.putCategory(new RequisitionCategory("VMware" + apiVersion));
        return requisitionNode;
    }

    private boolean reachableCimService(VmwareViJavaAccess vmwareViJavaAccess, HostSystem hostSystem, String ipAddress) {
        if (!vmwareViJavaAccess.setTimeout(3000)) {
            logger.warn("Error setting connection timeout");
        }
        List<CIMObject> cimObjects = null;
        try {
            cimObjects = vmwareViJavaAccess.queryCimObjects(hostSystem, "CIM_NumericSensor", ipAddress);
        }
        catch (ConnectException e) {
            return false;
        }
        catch (RemoteException e) {
            return false;
        }
        catch (CIMException e) {
            return false;
        }
        return cimObjects != null;
    }

    private boolean checkHostPowerState(HostSystem hostSystem) {
        logger.debug("Checking power state for host system {} (ID {})", (Object)hostSystem.getName(), (Object)hostSystem.getMOR().getVal());
        String powerState = hostSystem.getRuntime().getPowerState().toString();
        if ("poweredOn".equals(powerState) && this.request.isImportHostPoweredOn()) {
            return true;
        }
        if ("poweredOff".equals(powerState) && this.request.isImportHostPoweredOff()) {
            return true;
        }
        if ("standBy".equals(powerState) && this.request.isImportHostStandBy()) {
            return true;
        }
        return "unknown".equals(powerState) && this.request.isImportHostUnknown();
    }

    private boolean checkVMPowerState(VirtualMachine virtualMachine) {
        logger.debug("Checking power state for VM {} (ID: {})", (Object)virtualMachine.getName(), (Object)virtualMachine.getMOR().getVal());
        String powerState = virtualMachine.getRuntime().getPowerState().toString();
        if ("poweredOn".equals(powerState) && this.request.isImportVMPoweredOn()) {
            return true;
        }
        if ("poweredOff".equals(powerState) && this.request.isImportVMPoweredOff()) {
            return true;
        }
        return "suspended".equals(powerState) && this.request.isImportVMSuspended();
    }

    private void iterateHostSystems(VmwareViJavaAccess vmwareViJavaAccess, int apiVersion) throws RemoteException {
        logger.debug("Starting to iterate host systems on VMware host {} ...", (Object)this.request.getHostname());
        ManagedEntity[] hostSystems = vmwareViJavaAccess.searchManagedEntities("HostSystem");
        if (hostSystems != null) {
            for (ManagedEntity managedEntity : hostSystems) {
                HostSystem hostSystem = (HostSystem)managedEntity;
                logger.debug("Iterating host systems on VMware management server {} : {} (ID: {})", new Object[]{this.request.getHostname(), hostSystem.getName(), hostSystem.getMOR().getVal()});
                this.m_hostSystemMap.put(hostSystem.getMOR().getVal(), hostSystem.getName());
                if (!this.checkHostPowerState(hostSystem) || !this.checkForAttribute((ManagedEntity)hostSystem)) continue;
                logger.debug("Adding Host System '{}' (ID: {})", (Object)hostSystem.getName(), (Object)hostSystem.getMOR().getVal());
                TreeSet<String> ipAddresses = vmwareViJavaAccess.getHostSystemIpAddresses(hostSystem);
                RequisitionNode node = this.createRequisitionNode(ipAddresses, (ManagedEntity)hostSystem, apiVersion, vmwareViJavaAccess);
                try {
                    node.putAsset(new RequisitionAsset("cpu", hostSystem.getHardware().getCpuInfo().getNumCpuCores() + " cores"));
                }
                catch (Exception e) {
                    logger.debug("Can't find CPU information for {} (ID: {})", (Object)hostSystem.getName(), (Object)hostSystem.getMOR().getVal());
                }
                try {
                    node.putAsset(new RequisitionAsset("ram", Math.round((float)hostSystem.getHardware().getMemorySize() / 1000000.0f) + " MB"));
                }
                catch (Exception e) {
                    logger.debug("Can't find Memory information for {} (ID: {})", (Object)hostSystem.getName(), (Object)hostSystem.getMOR().getVal());
                }
                node.setLocation(this.request.getLocation());
                if (node == null || !this.request.isPersistHosts()) continue;
                this.m_requisition.insertNode(node);
            }
        }
    }

    private void iterateVirtualMachines(VmwareViJavaAccess vmwareViJavaAccess, int apiVersion) throws RemoteException {
        ManagedEntity[] virtualMachines = vmwareViJavaAccess.searchManagedEntities("VirtualMachine");
        if (virtualMachines != null) {
            for (ManagedEntity managedEntity : virtualMachines) {
                VirtualMachine virtualMachine = (VirtualMachine)managedEntity;
                logger.debug("Iterating host systems on VMware management server {} : {} (ID: {})", new Object[]{this.request.getHostname(), virtualMachine.getName(), virtualMachine.getMOR().getVal()});
                if (!this.checkVMPowerState(virtualMachine) || !this.checkForAttribute((ManagedEntity)virtualMachine)) continue;
                logger.debug("Adding Virtual Machine '{}' (ID: {})", (Object)virtualMachine.getName(), (Object)virtualMachine.getMOR().getVal());
                TreeSet<String> ipAddresses = vmwareViJavaAccess.getVirtualMachineIpAddresses(virtualMachine);
                RequisitionNode node = this.createRequisitionNode(ipAddresses, (ManagedEntity)virtualMachine, apiVersion, vmwareViJavaAccess);
                if (virtualMachine.getGuest().getGuestFullName() != null) {
                    node.putAsset(new RequisitionAsset("operatingSystem", virtualMachine.getGuest().getGuestFullName()));
                }
                try {
                    node.putAsset(new RequisitionAsset("cpu", virtualMachine.getConfig().getHardware().getNumCPU() + " vCPU"));
                }
                catch (Exception e) {
                    logger.debug("Can't find CPU information for {} (ID: {})", (Object)virtualMachine.getName(), (Object)virtualMachine.getMOR().getVal());
                }
                try {
                    node.putAsset(new RequisitionAsset("ram", virtualMachine.getConfig().getHardware().getMemoryMB() + " MB"));
                }
                catch (Exception e) {
                    logger.debug("Can't find Memory information for {} (ID: {})", (Object)virtualMachine.getName(), (Object)virtualMachine.getMOR().getVal());
                }
                node.setLocation(this.request.getLocation());
                if (node == null || !this.request.isPersistVMs()) continue;
                this.m_requisition.insertNode(node);
            }
        }
    }

    private boolean checkForAttribute(ManagedEntity managedEntity) throws RemoteException {
        logger.debug("Getting Managed entity custom attributes from VMware management server {} : ManagedEntity {} (ID: {})", new Object[]{this.request.getHostname(), managedEntity.getName(), managedEntity.getMOR().getVal()});
        Map<String, String> attribMap = this.getCustomAttributes(managedEntity);
        if (!this.request.getCustomAttributes().isEmpty()) {
            logger.debug("_[customAttributeName] provisioning attributes specified. Making sure Managed Entity {} has the requested custom attributes", (Object)managedEntity.getName());
            boolean ok = true;
            Map<String, String> customAttributes = this.request.getCustomAttributesMap();
            for (String keyName : customAttributes.keySet()) {
                logger.debug("Looking up for custom attribute {} with value {}", (Object)keyName, (Object)customAttributes.get(keyName));
                String attribValue = attribMap.get(StringUtils.removeStart((String)keyName, (String)"_"));
                if (attribValue == null) {
                    logger.debug("No custom attribute named {} found for Managed Entity {}", (Object)keyName, (Object)managedEntity.getName());
                    ok = false;
                    continue;
                }
                String keyValue = customAttributes.get(keyName);
                if (keyValue.startsWith("~")) {
                    ok = ok && attribValue.matches(StringUtils.removeStart((String)keyValue, (String)"~"));
                    continue;
                }
                ok = ok && attribValue.equals(keyValue);
            }
            return ok;
        }
        String key = this.request.getOldKey();
        String value = this.request.getOldValue();
        if (key == null && value == null) {
            logger.debug("No custom attributes required for provisioning Managed Entity {}.", (Object)managedEntity.getName());
            return true;
        }
        if (key == null || value == null) {
            logger.error("Not provisioning Manged Entiry {}: Using old key/value parameters, but either 'key' or 'value' parameter isn't set.", (Object)managedEntity.getName());
            return false;
        }
        String attribValue = attribMap.get(key);
        if (attribValue != null) {
            if (value.startsWith("~")) {
                return attribValue.matches(StringUtils.removeStart((String)value, (String)"~"));
            }
            return attribValue.equals(value);
        }
        logger.debug("No custom attributes named {} found for Managed Entity {}", (Object)key, (Object)managedEntity.getName());
        return false;
    }

    private Map<String, String> getCustomAttributes(ManagedEntity entity) throws RemoteException {
        TreeMap<String, String> attributes = new TreeMap<String, String>();
        logger.debug("Getting custom attributes from VMware management server {} : ManagedEntity {} (ID: {})", new Object[]{this.request.getHostname(), entity.getName(), entity.getMOR().getVal()});
        CustomFieldDef[] defs = entity.getAvailableField();
        CustomFieldValue[] values = entity.getCustomValue();
        for (int i = 0; defs != null && i < defs.length; ++i) {
            String key = defs[i].getName();
            int targetIndex = defs[i].getKey();
            for (int j = 0; values != null && j < values.length; ++j) {
                if (targetIndex != values[j].getKey()) continue;
                attributes.put(key, ((CustomFieldStringValue)values[j]).getValue());
            }
        }
        return attributes;
    }

    private RequisitionInterface getRequisitionInterface(RequisitionNode node, String ipAddr) {
        for (RequisitionInterface intf : node.getInterfaces()) {
            if (!ipAddr.equals(intf.getIpAddr())) continue;
            return intf;
        }
        return null;
    }

    private List<RequisitionMonitoredService> getManualyConfiguredServices(RequisitionInterface intf) {
        ArrayList<RequisitionMonitoredService> services = new ArrayList<RequisitionMonitoredService>();
        for (RequisitionMonitoredService svc : intf.getMonitoredServices()) {
            boolean found = false;
            for (String svcName : this.request.getHostSystemServices()) {
                if (!svcName.trim().equals(svc.getServiceName())) continue;
                found = true;
            }
            for (String svcName : this.request.getVirtualMachineServices()) {
                if (!svcName.trim().equals(svc.getServiceName())) continue;
                found = true;
            }
            if (found) continue;
            services.add(svc);
        }
        return services;
    }
}

