/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.ws;

import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.mo.util.MorUtil;
import com.vmware.vim25.ws.SoapConsts;
import com.vmware.vim25.ws.SoapFaultException;
import com.vmware.vim25.ws.XmlGen;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.doublecloud.ws.util.ReflectUtil;
import org.doublecloud.ws.util.TypeUtil;

class XmlGenDom
extends XmlGen {
    private static Logger log = Logger.getLogger(XmlGenDom.class);

    XmlGenDom() {
    }

    protected static int getNumberOfSameTags(List<Element> subNodes, int sizeOfSubNodes, int from, String tagName) {
        int numOfTags = 1;
        for (int j = from + 1; j < sizeOfSubNodes && subNodes.get(j).getName().equals(tagName); ++j) {
            ++numOfTags;
        }
        return numOfTags;
    }

    @Override
    public Object fromXML(String returnType, InputStream is) throws RemoteException {
        log.debug((Object)("Parsing XML payload from server. " + returnType));
        Element root = null;
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(is);
            log.trace((Object)("XML Document: " + doc.asXML()));
            root = doc.getRootElement();
        }
        catch (DocumentException e) {
            Throwable throwThis = e.getNestedException() != null ? e.getNestedException() : e;
            throw new RemoteException("An error occurred parsing XML with return type: " + returnType, throwThis);
        }
        catch (Exception e1) {
            throw new RemoteException("VI SDK invoke exception:" + e1);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ignore) {}
            }
        }
        Element body = (Element)root.elements().get(0);
        Element resp = (Element)body.elements().get(0);
        if (resp.getName().contains("Fault")) {
            SoapFaultException sfe;
            try {
                sfe = this.parseSoapFault(resp);
            }
            catch (Exception e) {
                throw new RemoteException("Exception in SoapClient.invoke:", e);
            }
            if (sfe != null && sfe.detail != null) {
                throw (RemoteException)sfe.detail;
            }
            throw sfe;
        }
        if (returnType != null) {
            try {
                return this.fromXML(returnType, resp);
            }
            catch (Exception e) {
                throw new RemoteException("Exception in SoapClient.invoke:", e);
            }
        }
        return null;
    }

    protected SoapFaultException parseSoapFault(Element root) throws Exception {
        try {
            Element faultE;
            String faultTypeName;
            List subElems;
            SoapFaultException sfe = new SoapFaultException();
            sfe.setFaultCode(root.elementText("faultcode"));
            sfe.setFaultString(root.elementText("faultstring"));
            sfe.setFaultActor(root.elementText("faultactor"));
            Element detailE = root.element("detail");
            if (detailE != null && (subElems = detailE.elements()).size() != 0 && (faultTypeName = (faultE = (Element)subElems.get(0)).attributeValue(SoapConsts.XSI_TYPE)) != null) {
                sfe.detail = (Throwable)this.fromXml(TypeUtil.getVimClass(faultTypeName), faultE);
            }
            return sfe;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Could not map the soap fault from:\n" + XmlGenDom.getContent(root), e);
        }
    }

    private static String getContent(Element element) {
        StringBuilder builder = new StringBuilder();
        Iterator i = element.elementIterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            builder.append(e.asXML());
        }
        return builder.toString();
    }

    private Object fromXML(String type, Element root) throws Exception {
        List subNodes = root.elements();
        if (subNodes.size() == 0) {
            return null;
        }
        if (type.startsWith("ManagedObjectReference")) {
            if (!type.endsWith("[]")) {
                Element e = (Element)subNodes.get(0);
                return MorUtil.createMOR(e.attributeValue("type"), e.getText());
            }
            ManagedObjectReference[] mos = new ManagedObjectReference[subNodes.size()];
            for (int i = 0; i < subNodes.size(); ++i) {
                Element elem = (Element)subNodes.get(i);
                mos[i] = MorUtil.createMOR(elem.attributeValue("type"), elem.getText());
            }
            return mos;
        }
        if (TypeUtil.isBasicType(type)) {
            ArrayList<String> vals = new ArrayList<String>();
            for (Element subNode : subNodes) {
                vals.add(subNode.getText());
            }
            return ReflectUtil.parseToObject(type, vals);
        }
        if (type.endsWith("[]")) {
            String arrayItemTypeName = type.substring(0, type.length() - 2);
            Class<?> clazz = TypeUtil.getVimClass(arrayItemTypeName);
            Object ao = Array.newInstance(clazz, subNodes.size());
            for (int i = 0; i < subNodes.size(); ++i) {
                Element e = (Element)subNodes.get(i);
                String xsiType = e.attributeValue(SoapConsts.XSI_TYPE);
                Object o = this.fromXml(TypeUtil.getVimClass(xsiType == null ? arrayItemTypeName : xsiType), (Element)subNodes.get(i));
                Array.set(ao, i, o);
            }
            return ao;
        }
        return this.fromXml(TypeUtil.getVimClass(type), (Element)subNodes.get(0));
    }

    private Object fromXml(Class<?> clazz, Element node) throws Exception {
        Object obj = clazz.newInstance();
        List subNodes = node.elements();
        int sizeOfSubNodes = subNodes.size();
        for (int i = 0; i < sizeOfSubNodes; ++i) {
            Object ao;
            Element e = (Element)subNodes.get(i);
            String tagName = e.getName();
            Field field = null;
            field = TypeUtil.isPrimitiveType(tagName) ? clazz.getField("_" + tagName) : clazz.getField(tagName);
            Class<?> fType = field.getType();
            boolean isFieldArray = fType.isArray();
            if (isFieldArray) {
                fType = fType.getComponentType();
            }
            Class<?> fRealType = fType;
            String xsiType = e.attributeValue(SoapConsts.XSI_TYPE);
            if (xsiType != null && !xsiType.startsWith("xsd:")) {
                fRealType = TypeUtil.getVimClass(xsiType);
            }
            if (fRealType == ManagedObjectReference.class) {
                if (isFieldArray) {
                    int sizeOfFieldArray = XmlGenDom.getNumberOfSameTags(subNodes, sizeOfSubNodes, i, tagName);
                    ManagedObjectReference[] mos = new ManagedObjectReference[sizeOfFieldArray];
                    for (int j = 0; j < sizeOfFieldArray; ++j) {
                        Element elem = (Element)subNodes.get(j + i);
                        mos[j] = MorUtil.createMOR(elem.attributeValue("type"), elem.getText());
                    }
                    field.set(obj, mos);
                    i = i + sizeOfFieldArray - 1;
                    continue;
                }
                field.set(obj, MorUtil.createMOR(e.attributeValue("type"), e.getText()));
                continue;
            }
            if (fRealType.isEnum()) {
                if (!isFieldArray) {
                    Object fo = Enum.valueOf(fRealType, e.getText());
                    field.set(obj, fo);
                    continue;
                }
                int sizeOfFieldArray = XmlGenDom.getNumberOfSameTags(subNodes, sizeOfSubNodes, i, tagName);
                ao = Array.newInstance(fRealType, sizeOfFieldArray);
                for (int j = 0; j < sizeOfFieldArray; ++j) {
                    String enumStr = ((Element)subNodes.get(j + i)).getText();
                    Array.set(ao, j, Enum.valueOf(fRealType, enumStr));
                }
                field.set(obj, ao);
                i = i + sizeOfFieldArray - 1;
                continue;
            }
            if (TypeUtil.isBasicType(fRealType)) {
                if (isFieldArray) {
                    String fTrueType;
                    int sizeOfFieldArray = XmlGenDom.getNumberOfSameTags(subNodes, sizeOfSubNodes, i, tagName);
                    ArrayList<String> values = new ArrayList<String>();
                    for (int j = 0; j < sizeOfFieldArray; ++j) {
                        values.add(((Element)subNodes.get(j + i)).getText());
                    }
                    if (xsiType != null) {
                        fTrueType = xsiType.substring("xsd:".length()) + "[]";
                    } else {
                        fTrueType = fRealType.getSimpleName();
                        if (!fTrueType.endsWith("[]")) {
                            fTrueType = fTrueType + "[]";
                        }
                    }
                    ReflectUtil.setObjectArrayField(obj, field, fTrueType, values);
                    i = i + sizeOfFieldArray - 1;
                    continue;
                }
                if (xsiType != null) {
                    xsiType = xsiType.substring("xsd:".length());
                    ReflectUtil.setObjectField(obj, field, xsiType, e.getText());
                    continue;
                }
                ReflectUtil.setObjectField(obj, field, fRealType.getSimpleName(), e.getText());
                continue;
            }
            if (isFieldArray) {
                int sizeOfFieldArray = XmlGenDom.getNumberOfSameTags(subNodes, sizeOfSubNodes, i, tagName);
                ao = Array.newInstance(fType, sizeOfFieldArray);
                String fGenericType = fType.getSimpleName();
                for (int j = 0; j < sizeOfFieldArray; ++j) {
                    Element elem = (Element)subNodes.get(j + i);
                    String elemXsiType = elem.attributeValue(SoapConsts.XSI_TYPE);
                    String elemType = elemXsiType != null ? elemXsiType : fGenericType;
                    Object o = this.fromXml(TypeUtil.getVimClass(elemType), elem);
                    Array.set(ao, j, o);
                }
                field.set(obj, ao);
                i = i + sizeOfFieldArray - 1;
                continue;
            }
            Object o = this.fromXml(fRealType, e);
            field.set(obj, o);
        }
        return obj;
    }
}

