/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.multipart.support.RequestPartServletServerHttpRequest;
import org.springframework.web.servlet.mvc.method.annotation.AbstractMessageConverterMethodArgumentResolver;
import org.springframework.web.util.WebUtils;

public class RequestPartMethodArgumentResolver
extends AbstractMessageConverterMethodArgumentResolver {
    public RequestPartMethodArgumentResolver(List<HttpMessageConverter<?>> messageConverters) {
        super(messageConverters);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        if (parameter.hasParameterAnnotation(RequestPart.class)) {
            return true;
        }
        if (parameter.hasParameterAnnotation(RequestParam.class)) {
            return false;
        }
        if (MultipartFile.class.equals((Object)parameter.getParameterType())) {
            return true;
        }
        return "javax.servlet.http.Part".equals(parameter.getParameterType().getName());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest request, WebDataBinderFactory binderFactory) throws Exception {
        boolean isRequired;
        Object arg;
        HttpServletRequest servletRequest = (HttpServletRequest)request.getNativeRequest(HttpServletRequest.class);
        RequestPartMethodArgumentResolver.assertIsMultipartRequest(servletRequest);
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)WebUtils.getNativeRequest((ServletRequest)servletRequest, MultipartHttpServletRequest.class);
        String partName = this.getPartName(parameter);
        if (MultipartFile.class.equals((Object)parameter.getParameterType())) {
            Assert.notNull((Object)multipartRequest, (String)"Expected MultipartHttpServletRequest: is a MultipartResolver configured?");
            arg = multipartRequest.getFile(partName);
        } else if (this.isMultipartFileCollection(parameter)) {
            Assert.notNull((Object)multipartRequest, (String)"Expected MultipartHttpServletRequest: is a MultipartResolver configured?");
            arg = multipartRequest.getFiles(partName);
        } else if (this.isMultipartFileArray(parameter)) {
            Assert.notNull((Object)multipartRequest, (String)"Expected MultipartHttpServletRequest: is a MultipartResolver configured?");
            List files = multipartRequest.getFiles(partName);
            arg = files.toArray(new MultipartFile[files.size()]);
        } else if ("javax.servlet.http.Part".equals(parameter.getParameterType().getName())) {
            RequestPartMethodArgumentResolver.assertIsMultipartRequest(servletRequest);
            arg = servletRequest.getPart(partName);
        } else if (this.isPartCollection(parameter)) {
            RequestPartMethodArgumentResolver.assertIsMultipartRequest(servletRequest);
            arg = new ArrayList(servletRequest.getParts());
        } else if (this.isPartArray(parameter)) {
            RequestPartMethodArgumentResolver.assertIsMultipartRequest(servletRequest);
            arg = RequestPartResolver.resolvePart(servletRequest);
        } else {
            try {
                RequestPartServletServerHttpRequest inputMessage = new RequestPartServletServerHttpRequest(servletRequest, partName);
                arg = this.readWithMessageConverters((HttpInputMessage)inputMessage, parameter, (Type)parameter.getParameterType());
                WebDataBinder binder = binderFactory.createBinder(request, arg, partName);
                if (arg != null) {
                    this.validateIfApplicable(binder, parameter);
                    if (binder.getBindingResult().hasErrors() && this.isBindExceptionRequired(binder, parameter)) {
                        throw new MethodArgumentNotValidException(parameter, binder.getBindingResult());
                    }
                }
                mavContainer.addAttribute(BindingResult.MODEL_KEY_PREFIX + partName, (Object)binder.getBindingResult());
            }
            catch (MissingServletRequestPartException ex) {
                arg = null;
            }
        }
        RequestPart ann = (RequestPart)parameter.getParameterAnnotation(RequestPart.class);
        boolean bl = isRequired = ann == null || ann.required();
        if (arg == null && isRequired) {
            throw new MissingServletRequestPartException(partName);
        }
        return arg;
    }

    private static void assertIsMultipartRequest(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (contentType == null || !contentType.toLowerCase().startsWith("multipart/")) {
            throw new MultipartException("The current request is not a multipart request");
        }
    }

    private String getPartName(MethodParameter methodParam) {
        String partName;
        RequestPart ann = (RequestPart)methodParam.getParameterAnnotation(RequestPart.class);
        String string = partName = ann != null ? ann.value() : "";
        if (partName.length() == 0 && (partName = methodParam.getParameterName()) == null) {
            throw new IllegalArgumentException("Request part name for argument type [" + methodParam.getNestedParameterType().getName() + "] not specified, and parameter name information not found in class file either.");
        }
        return partName;
    }

    private boolean isMultipartFileCollection(MethodParameter methodParam) {
        Class<?> collectionType = this.getCollectionParameterType(methodParam);
        return MultipartFile.class.equals(collectionType);
    }

    private boolean isMultipartFileArray(MethodParameter methodParam) {
        Class<?> paramType = methodParam.getNestedParameterType().getComponentType();
        return MultipartFile.class.equals(paramType);
    }

    private boolean isPartCollection(MethodParameter methodParam) {
        Class<?> collectionType = this.getCollectionParameterType(methodParam);
        return collectionType != null && "javax.servlet.http.Part".equals(collectionType.getName());
    }

    private boolean isPartArray(MethodParameter methodParam) {
        Class<?> paramType = methodParam.getNestedParameterType().getComponentType();
        return paramType != null && "javax.servlet.http.Part".equals(paramType.getName());
    }

    private Class<?> getCollectionParameterType(MethodParameter methodParam) {
        Class valueType;
        Class paramType = methodParam.getNestedParameterType();
        if ((Collection.class.equals((Object)paramType) || List.class.isAssignableFrom(paramType)) && (valueType = GenericCollectionTypeResolver.getCollectionParameterType((MethodParameter)methodParam)) != null) {
            return valueType;
        }
        return null;
    }

    private static class RequestPartResolver {
        private RequestPartResolver() {
        }

        public static Object resolvePart(HttpServletRequest servletRequest) throws Exception {
            Collection parts = servletRequest.getParts();
            return parts.toArray(new Part[parts.size()]);
        }
    }
}

