/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.support.builder;

import java.util.Objects;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.netmgt.collection.adapters.InterfaceLevelResourceAdapter;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.support.builder.AbstractResource;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.model.ResourcePath;

@XmlJavaTypeAdapter(value=InterfaceLevelResourceAdapter.class)
public class InterfaceLevelResource
extends AbstractResource {
    private NodeLevelResource m_node;
    private String m_ifName;

    public InterfaceLevelResource(NodeLevelResource node, String ifName) {
        this.m_node = node;
        this.m_ifName = ifName;
    }

    public String getIfName() {
        return this.m_ifName;
    }

    @Override
    public NodeLevelResource getParent() {
        return this.m_node;
    }

    @Override
    public String getInstance() {
        return this.m_ifName;
    }

    @Override
    public String getLabel() {
        return this.m_ifName;
    }

    @Override
    public ResourcePath getPath(CollectionResource resource) {
        return ResourcePath.get((String[])new String[]{this.getIfName()});
    }

    @Override
    public String getTypeName() {
        return "if";
    }

    public String toString() {
        return String.format("InterfaceLevelResource[node=%s, ifName=%s]", this.m_node, this.m_ifName);
    }

    public int hashCode() {
        return Objects.hash(this.m_node, this.m_ifName, this.getTimestamp());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InterfaceLevelResource)) {
            return false;
        }
        InterfaceLevelResource other = (InterfaceLevelResource)obj;
        return Objects.equals(this.m_node, other.m_node) && Objects.equals(this.m_ifName, other.m_ifName) && Objects.equals(this.getTimestamp(), other.getTimestamp());
    }
}

