/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.client.rpc;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.PollerRequestBuilder;
import org.opennms.netmgt.poller.PollerResponse;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.ServiceMonitorAdaptor;
import org.opennms.netmgt.poller.client.rpc.LocationAwarePollerClientImpl;
import org.opennms.netmgt.poller.client.rpc.PollerRequestDTO;

public class PollerRequestBuilderImpl
implements PollerRequestBuilder {
    private MonitoredService service;
    private ServiceMonitor serviceMonitor;
    private LocationAwarePollerClientImpl client;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final List<ServiceMonitorAdaptor> adaptors = new LinkedList<ServiceMonitorAdaptor>();
    private Long ttlInMs;

    public PollerRequestBuilderImpl(LocationAwarePollerClientImpl client) {
        this.client = client;
    }

    public PollerRequestBuilder withService(MonitoredService service) {
        this.service = service;
        return this;
    }

    public PollerRequestBuilder withMonitor(ServiceMonitor serviceMonitor) {
        this.serviceMonitor = serviceMonitor;
        return this;
    }

    public PollerRequestBuilder withMonitorClassName(String className) {
        this.serviceMonitor = this.client.getRegistry().getMonitorByClassName(className);
        return this;
    }

    public PollerRequestBuilder withTimeToLive(Long ttlInMs) {
        this.ttlInMs = ttlInMs;
        return this;
    }

    public PollerRequestBuilder withAttribute(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    public PollerRequestBuilder withAttributes(Map<String, Object> attributes) {
        this.attributes.putAll(attributes);
        return this;
    }

    public PollerRequestBuilder withAdaptor(ServiceMonitorAdaptor adaptor) {
        this.adaptors.add(adaptor);
        return this;
    }

    public CompletableFuture<PollerResponse> execute() {
        if (this.serviceMonitor == null) {
            throw new IllegalArgumentException("Monitor or monitor class name is required.");
        }
        if (this.service == null) {
            throw new IllegalArgumentException("Monitored service is required.");
        }
        PollerRequestDTO request = new PollerRequestDTO();
        request.setLocation(this.serviceMonitor.getEffectiveLocation(this.service.getNodeLocation()));
        request.setClassName(this.serviceMonitor.getClass().getCanonicalName());
        request.setServiceName(this.service.getSvcName());
        request.setAddress(this.service.getAddress());
        request.setNodeId(this.service.getNodeId());
        request.setNodeLabel(this.service.getNodeLabel());
        request.setNodeLocation(this.service.getNodeLocation());
        request.setTimeToLiveMs(this.ttlInMs);
        request.addAttributes(this.attributes);
        Map<String, Object> parameters = request.getMonitorParameters();
        request.addAttributes(this.serviceMonitor.getRuntimeAttributes((MonitoredService)request, parameters));
        return this.client.getDelegate().execute((RpcRequest)request).thenApply(results -> {
            PollStatus pollStatus = results.getPollStatus();
            for (ServiceMonitorAdaptor adaptor : this.adaptors) {
                pollStatus = adaptor.handlePollResult(this.service, this.attributes, pollStatus);
            }
            results.setPollStatus(pollStatus);
            return results;
        });
    }
}

