/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.vacuumd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;
import org.opennms.netmgt.config.vacuumd.Assignment;

@XmlRootElement(name="action-event")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="vacuumd-configuration.xsd")
public class ActionEvent
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Boolean DEFAULT_FOR_EACH_RESULT_FLAG = Boolean.FALSE;
    private static final Boolean DEFAULT_ADD_ALL_PARMS_FLAG = Boolean.FALSE;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlAttribute(name="for-each-result")
    private Boolean m_forEachResult;
    @XmlAttribute(name="add-all-parms")
    private Boolean m_addAllParms;
    @XmlElement(name="assignment")
    private List<Assignment> m_assignments = new ArrayList<Assignment>();

    public ActionEvent() {
    }

    public ActionEvent(String name, Boolean forEachResult, Boolean addAllParms, List<Assignment> assignments) {
        this.setName(name);
        this.setForEachResult(forEachResult);
        this.setAddAllParms(addAllParms);
        this.setAssignments(assignments);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public Boolean getForEachResult() {
        return this.m_forEachResult == null ? DEFAULT_FOR_EACH_RESULT_FLAG : this.m_forEachResult;
    }

    public void setForEachResult(Boolean forEachResult) {
        this.m_forEachResult = forEachResult;
    }

    public boolean getAddAllParms() {
        return this.m_addAllParms == null ? DEFAULT_ADD_ALL_PARMS_FLAG : this.m_addAllParms;
    }

    public void setAddAllParms(Boolean addAllParms) {
        this.m_addAllParms = addAllParms;
    }

    public List<Assignment> getAssignments() {
        return this.m_assignments;
    }

    public void setAssignments(List<Assignment> assignments) {
        ConfigUtils.assertMinimumSize(assignments, 1L, "assignment");
        if (assignments == this.m_assignments) {
            return;
        }
        this.m_assignments.clear();
        if (assignments != null) {
            this.m_assignments.addAll(assignments);
        }
    }

    public void addAssignment(Assignment assignment) {
        this.m_assignments.add(assignment);
    }

    public Boolean removeAssignment(Assignment assignment) {
        return this.m_assignments.remove(assignment);
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_forEachResult, this.m_addAllParms, this.m_assignments);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ActionEvent) {
            ActionEvent that = (ActionEvent)obj;
            return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_forEachResult, that.m_forEachResult) && Objects.equals(this.m_addAllParms, that.m_addAllParms) && Objects.equals(this.m_assignments, that.m_assignments);
        }
        return false;
    }
}

