/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.hardware;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.xml.OptionalStringAdapter;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.hardware.SnmpObjIdAdapter;
import org.opennms.netmgt.config.utils.ConfigUtils;
import org.opennms.netmgt.snmp.SnmpObjId;

@XmlRootElement(name="MibObj")
@XmlType(propOrder={"oid", "type", "alias", "replace"})
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="snmp-hardware-inventory-adapter-configuration.xsd")
public class MibObj
implements Serializable {
    private static final long serialVersionUID = 2L;
    private SnmpObjId m_oid;
    private String m_type;
    private String m_alias;
    private String m_replace;

    public MibObj() {
    }

    public MibObj(SnmpObjId oid, String type, String alias) {
        this.setOid(oid);
        this.setType(type);
        this.setAlias(alias);
    }

    public MibObj(SnmpObjId oid, String type, String alias, String replace) {
        this(oid, type, alias);
        this.setReplace(replace);
    }

    @XmlAttribute(name="oid", required=true)
    @XmlJavaTypeAdapter(value=SnmpObjIdAdapter.class)
    public SnmpObjId getOid() {
        return this.m_oid;
    }

    public void setOid(SnmpObjId oid) {
        this.m_oid = ConfigUtils.assertNotNull(oid, "OID");
    }

    @XmlAttribute(name="type", required=false)
    public String getType() {
        return this.m_type == null ? "string" : this.m_type;
    }

    public void setType(String type) {
        this.m_type = ConfigUtils.normalizeString(type);
    }

    @XmlAttribute(name="alias", required=true)
    public String getAlias() {
        return this.m_alias;
    }

    public void setAlias(String alias) {
        this.m_alias = ConfigUtils.assertNotEmpty(alias, "alias");
    }

    @XmlAttribute(name="replace", required=false)
    @XmlJavaTypeAdapter(value=OptionalStringAdapter.class)
    public Optional<String> getReplace() {
        return Optional.ofNullable(this.m_replace);
    }

    public void setReplace(Optional<String> replace) {
        this.setReplace((String)replace.orElse(null));
    }

    public void setReplace(String replace) {
        if (replace != null && !replace.startsWith("entPhysical")) {
            throw new IllegalArgumentException("Invalid replace field " + replace);
        }
        this.m_replace = ConfigUtils.normalizeString(replace);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MibObj) {
            MibObj that = (MibObj)obj;
            return Objects.equals(this.m_oid, that.m_oid) && Objects.equals(this.m_type, that.m_type) && Objects.equals(this.m_alias, that.m_alias) && Objects.equals(this.m_replace, that.m_replace);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.m_oid, this.m_type, this.m_alias, this.m_replace);
    }

    public String toString() {
        return "MibObj [oid=" + this.m_oid + ", type=" + this.m_type + ", alias=" + this.m_alias + ", replace=" + this.m_replace + "]";
    }
}

