/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.netmgt.config.TrapdConfig;
import org.opennms.netmgt.config.trapd.Snmpv3User;
import org.opennms.netmgt.config.trapd.TrapdConfiguration;
import org.opennms.netmgt.snmp.SnmpV3User;
import org.slf4j.LoggerFactory;

public class TrapdConfigBean
implements TrapdConfig,
Serializable {
    private static final long serialVersionUID = -4406324301602556539L;
    private String snmpTrapAddress;
    private int snmpTrapPort;
    private boolean newSuspectOnTrap;
    private List<SnmpV3User> snmpV3Users = new ArrayList<SnmpV3User>();
    private boolean includeRawMessage;
    private int batchIntervalInMs;
    private int batchSize;
    private int queueSize;
    private int numThreads;

    public TrapdConfigBean() {
    }

    public TrapdConfigBean(TrapdConfig configToClone) {
        this.update(configToClone);
    }

    public TrapdConfigBean(TrapdConfiguration trapdConfiguration) {
        this.setSnmpTrapAddress(trapdConfiguration.getSnmpTrapAddress());
        this.setSnmpTrapPort(trapdConfiguration.getSnmpTrapPort());
        this.setNewSuspectOnTrap(trapdConfiguration.isNewSuspectOnTrap());
        this.setIncludeRawMessage(trapdConfiguration.isIncludeRawMessage());
        this.setBatchIntervalMs(trapdConfiguration.getBatchInterval());
        this.setBatchSize(trapdConfiguration.getBatchSize());
        this.setQueueSize(trapdConfiguration.getQueueSize());
        this.setNumThreads(trapdConfiguration.getThreads());
        if (trapdConfiguration.getSnmpv3UserCollection() != null) {
            this.setSnmpV3Users(trapdConfiguration.getSnmpv3UserCollection().stream().map(TrapdConfigBean::toSnmpV3User).collect(Collectors.toList()));
        }
    }

    public void setSnmpTrapAddress(String snmpTrapAddress) {
        this.snmpTrapAddress = snmpTrapAddress;
    }

    public void setSnmpTrapPort(int snmpTrapPort) {
        this.snmpTrapPort = snmpTrapPort;
    }

    public void setNewSuspectOnTrap(boolean newSuspectOnTrap) {
        this.newSuspectOnTrap = newSuspectOnTrap;
    }

    public String getSnmpTrapAddress() {
        return this.snmpTrapAddress;
    }

    public int getSnmpTrapPort() {
        return this.snmpTrapPort;
    }

    public void setSnmpV3Users(List<SnmpV3User> snmpV3Users) {
        Objects.requireNonNull(snmpV3Users);
        Map collect = snmpV3Users.stream().collect(Collectors.toMap(SnmpV3User::getSecurityName, Function.identity(), (a, b) -> {
            LoggerFactory.getLogger(this.getClass()).warn("Multiple SNMPv3 user entries found for security name \"{}\", using entry {}", (Object)a.getSecurityName(), a);
            return a;
        }));
        this.snmpV3Users = new ArrayList(collect.values());
    }

    public boolean getNewSuspectOnTrap() {
        return this.newSuspectOnTrap;
    }

    public List<SnmpV3User> getSnmpV3Users() {
        return Collections.unmodifiableList(this.snmpV3Users);
    }

    public boolean isIncludeRawMessage() {
        return this.includeRawMessage;
    }

    public void setIncludeRawMessage(boolean includeRawMessage) {
        this.includeRawMessage = includeRawMessage;
    }

    public int getNumThreads() {
        if (this.numThreads <= 0) {
            return Runtime.getRuntime().availableProcessors() * 2;
        }
        return this.numThreads;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getBatchIntervalMs() {
        return this.batchIntervalInMs;
    }

    public void update(TrapdConfig config) {
        this.setSnmpTrapAddress(config.getSnmpTrapAddress());
        this.setSnmpTrapPort(config.getSnmpTrapPort());
        this.setNewSuspectOnTrap(config.getNewSuspectOnTrap());
        this.setIncludeRawMessage(config.isIncludeRawMessage());
        this.setBatchIntervalMs(config.getBatchIntervalMs());
        this.setBatchSize(config.getBatchSize());
        this.setQueueSize(config.getQueueSize());
        this.setNumThreads(config.getNumThreads());
        this.setSnmpV3Users(config.getSnmpV3Users());
    }

    public void setBatchIntervalMs(int batchIntervalInMs) {
        this.batchIntervalInMs = batchIntervalInMs;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    private static SnmpV3User toSnmpV3User(Snmpv3User snmpv3User) {
        SnmpV3User snmpV3User = new SnmpV3User();
        snmpV3User.setAuthPassPhrase(snmpv3User.getAuthPassphrase());
        snmpV3User.setAuthProtocol(snmpv3User.getAuthProtocol());
        snmpV3User.setEngineId(snmpv3User.getEngineId());
        snmpV3User.setPrivPassPhrase(snmpv3User.getPrivacyPassphrase());
        snmpV3User.setPrivProtocol(snmpv3User.getPrivacyProtocol());
        snmpV3User.setSecurityName(snmpv3User.getSecurityName());
        return snmpV3User;
    }
}

