/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.topology;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opennms.netmgt.model.BridgeBridgeLink;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.topology.BridgePort;
import org.opennms.netmgt.model.topology.BroadcastDomain;

public class SharedSegment {
    BridgePort m_designatedBridge;
    Set<String> m_macsOnSegment = new HashSet<String>();
    Set<BridgePort> m_portsOnSegment = new HashSet<BridgePort>();
    BroadcastDomain m_domain;

    private BridgePort getBridgeFromBridgeMacLink(BridgeMacLink link) {
        BridgePort bp = new BridgePort();
        bp.setNode(link.getNode());
        bp.setBridgePort(link.getBridgePort());
        bp.setBridgePortIfIndex(link.getBridgePortIfIndex());
        bp.setBridgePortIfName(link.getBridgePortIfName());
        bp.setVlan(link.getVlan());
        bp.setCreateTime(link.getBridgeMacLinkCreateTime());
        bp.setPollTime(link.getBridgeMacLinkLastPollTime());
        return bp;
    }

    private BridgePort getFromBridgeBridgeLink(BridgeBridgeLink link) {
        BridgePort bp = new BridgePort();
        bp.setNode(link.getNode());
        bp.setBridgePort(link.getBridgePort());
        bp.setBridgePortIfIndex(link.getBridgePortIfIndex());
        bp.setBridgePortIfName(link.getBridgePortIfName());
        bp.setVlan(link.getVlan());
        bp.setCreateTime(link.getBridgeBridgeLinkCreateTime());
        bp.setPollTime(link.getBridgeBridgeLinkLastPollTime());
        return bp;
    }

    private BridgePort getFromDesignatedBridgeBridgeLink(BridgeBridgeLink link) {
        BridgePort bp = new BridgePort();
        bp.setNode(link.getDesignatedNode());
        bp.setBridgePort(link.getDesignatedPort());
        bp.setBridgePortIfIndex(link.getDesignatedPortIfIndex());
        bp.setBridgePortIfName(link.getDesignatedPortIfName());
        bp.setVlan(link.getDesignatedVlan());
        bp.setCreateTime(link.getBridgeBridgeLinkCreateTime());
        bp.setPollTime(link.getBridgeBridgeLinkLastPollTime());
        return bp;
    }

    private BridgeMacLink getBridgeMacLink(BridgePort bp, String mac) {
        BridgeMacLink maclink = new BridgeMacLink();
        maclink.setNode(bp.getNode());
        maclink.setBridgePort(bp.getBridgePort());
        maclink.setBridgePortIfIndex(bp.getBridgePortIfIndex());
        maclink.setBridgePortIfName(bp.getBridgePortIfName());
        maclink.setMacAddress(mac);
        maclink.setBridgeDot1qTpFdbStatus(BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED);
        maclink.setVlan(bp.getVlan());
        maclink.setBridgeMacLinkCreateTime(bp.getCreateTime());
        maclink.setBridgeMacLinkLastPollTime(bp.getPollTime());
        return maclink;
    }

    private BridgeBridgeLink getBridgeBridgeLink(BridgePort bp) {
        BridgeBridgeLink link = new BridgeBridgeLink();
        link.setNode(bp.getNode());
        link.setBridgePort(bp.getBridgePort());
        link.setBridgePortIfIndex(bp.getBridgePortIfIndex());
        link.setBridgePortIfName(bp.getBridgePortIfName());
        link.setVlan(bp.getVlan());
        link.setDesignatedNode(this.m_designatedBridge.getNode());
        link.setDesignatedPort(this.m_designatedBridge.getBridgePort());
        link.setDesignatedPortIfIndex(this.m_designatedBridge.getBridgePortIfIndex());
        link.setDesignatedPortIfName(this.m_designatedBridge.getBridgePortIfName());
        link.setDesignatedVlan(this.m_designatedBridge.getVlan());
        link.setBridgeBridgeLinkCreateTime(this.m_designatedBridge.getCreateTime());
        link.setBridgeBridgeLinkLastPollTime(this.m_designatedBridge.getPollTime());
        return link;
    }

    public SharedSegment() {
    }

    public SharedSegment(BroadcastDomain domain) {
        this.m_domain = domain;
    }

    public BroadcastDomain getBroadcastDomain() {
        return this.m_domain;
    }

    public void setBroadcastDomain(BroadcastDomain domain) {
        this.m_domain = domain;
    }

    public SharedSegment(BroadcastDomain domain, BridgeMacLink link) {
        this.m_domain = domain;
        this.m_designatedBridge = this.getBridgeFromBridgeMacLink(link);
        this.m_macsOnSegment.add(link.getMacAddress());
        this.m_portsOnSegment.add(this.m_designatedBridge);
    }

    public SharedSegment(BroadcastDomain domain, List<BridgeMacLink> links) {
        this.m_domain = domain;
        for (BridgeMacLink link : links) {
            this.m_portsOnSegment.add(this.getBridgeFromBridgeMacLink(link));
            this.m_macsOnSegment.add(link.getMacAddress());
        }
    }

    public SharedSegment(BroadcastDomain domain, BridgeBridgeLink link, Set<String> macs) {
        this.m_domain = domain;
        this.m_portsOnSegment.add(this.getFromDesignatedBridgeBridgeLink(link));
        this.m_portsOnSegment.add(this.getFromBridgeBridgeLink(link));
        this.m_macsOnSegment = macs;
    }

    public void setDesignatedBridge(Integer designatedBridge) {
        if (designatedBridge == null) {
            return;
        }
        if (this.m_designatedBridge != null && designatedBridge != null && this.m_designatedBridge.getNode().getId().intValue() == designatedBridge.intValue()) {
            return;
        }
        for (BridgePort port : this.m_portsOnSegment) {
            if (port.getNode().getId().intValue() != designatedBridge.intValue()) continue;
            this.m_designatedBridge = port;
            break;
        }
    }

    public Integer getDesignatedBridge() {
        return this.m_designatedBridge.getNode().getId();
    }

    public Integer getDesignatedPort() {
        return this.m_designatedBridge.getBridgePort();
    }

    public boolean isEmpty() {
        return this.m_portsOnSegment.isEmpty();
    }

    public Set<BridgePort> getBridgePortsOnSegment() {
        return this.m_portsOnSegment;
    }

    public List<BridgeBridgeLink> getBridgeBridgeLinks() {
        ArrayList<BridgeBridgeLink> links = new ArrayList<BridgeBridgeLink>();
        for (BridgePort port : this.m_portsOnSegment) {
            if (port.equals(this.m_designatedBridge)) continue;
            links.add(this.getBridgeBridgeLink(port));
        }
        return links;
    }

    public List<BridgeMacLink> getBridgeMacLinks() {
        ArrayList<BridgeMacLink> maclinks = new ArrayList<BridgeMacLink>();
        for (String mac : this.m_macsOnSegment) {
            for (BridgePort bp : this.m_portsOnSegment) {
                maclinks.add(this.getBridgeMacLink(bp, mac));
            }
        }
        return maclinks;
    }

    public boolean noMacsOnSegment() {
        return this.m_macsOnSegment.isEmpty();
    }

    public void add(BridgeMacLink link) {
        this.m_macsOnSegment.add(link.getMacAddress());
        this.m_portsOnSegment.add(this.getBridgeFromBridgeMacLink(link));
    }

    public void add(BridgeBridgeLink dlink) {
        BridgePort designated = this.getFromDesignatedBridgeBridgeLink(dlink);
        BridgePort bridge = this.getFromBridgeBridgeLink(dlink);
        this.m_portsOnSegment.add(designated);
        this.m_portsOnSegment.add(bridge);
    }

    public void mergeBridge(SharedSegment shared, Integer bridgeId) {
        HashSet<BridgePort> portsOnSegment = new HashSet<BridgePort>();
        for (BridgePort bp : this.m_portsOnSegment) {
            if (bp.getNode().getId().intValue() == bridgeId.intValue()) continue;
            portsOnSegment.add(bp);
        }
        for (BridgePort port : shared.getBridgePortsOnSegment()) {
            if (port.getNode().getId().intValue() == bridgeId.intValue()) continue;
            portsOnSegment.add(port);
        }
        this.m_portsOnSegment = portsOnSegment;
        this.m_macsOnSegment.addAll(shared.getMacsOnSegment());
    }

    public void assign(Set<String> macs, BridgeBridgeLink dlink) {
        if (this.isEmpty()) {
            this.add(dlink);
            this.m_macsOnSegment = macs;
            return;
        }
        this.add(dlink);
        this.m_macsOnSegment.retainAll(macs);
    }

    public void removeBridge(int bridgeId) {
        if (this.m_portsOnSegment.isEmpty()) {
            return;
        }
        HashSet<BridgePort> updateportsonsegment = new HashSet<BridgePort>();
        for (BridgePort port : this.m_portsOnSegment) {
            if (port.getNode().getId() == bridgeId) continue;
            updateportsonsegment.add(port);
        }
        this.m_portsOnSegment = updateportsonsegment;
    }

    public void removeMacs(Set<String> mactoberemoved) {
        this.m_macsOnSegment.removeAll(mactoberemoved);
    }

    public Integer getFirstNoDesignatedBridge() {
        for (Integer bridgeId : this.getBridgeIdsOnSegment()) {
            if (this.m_designatedBridge != null && bridgeId == this.m_designatedBridge.getNode().getId()) continue;
            return bridgeId;
        }
        return null;
    }

    public Set<String> getMacsOnSegment() {
        return this.m_macsOnSegment;
    }

    public Set<Integer> getBridgeIdsOnSegment() {
        HashSet<Integer> nodes = new HashSet<Integer>();
        for (BridgePort link : this.m_portsOnSegment) {
            nodes.add(link.getNode().getId());
        }
        return nodes;
    }

    public boolean containsMac(String mac) {
        if (mac == null) {
            return false;
        }
        return this.m_macsOnSegment.contains(mac);
    }

    public boolean containsPort(Integer nodeid, Integer bridgeport) {
        if (nodeid == null || bridgeport == null) {
            return false;
        }
        for (BridgePort port : this.m_portsOnSegment) {
            if (port.getNode().getId() != nodeid || port.getBridgePort() != bridgeport) continue;
            return true;
        }
        return false;
    }

    public Integer getPortForBridge(Integer nodeid) {
        if (nodeid == null) {
            return null;
        }
        if (this.m_macsOnSegment.isEmpty()) {
            for (BridgePort link : this.m_portsOnSegment) {
                if (link.getNode().getId().intValue() != nodeid.intValue()) continue;
                return link.getBridgePort();
            }
            return null;
        }
        return null;
    }

    public String printTopology() {
        StringBuffer strbfr = new StringBuffer();
        strbfr.append("segment:[bridges:");
        strbfr.append(this.getBridgeIdsOnSegment());
        strbfr.append(", designated bridge:[");
        strbfr.append(this.getDesignatedBridge());
        strbfr.append("], designated port:");
        strbfr.append(this.getDesignatedPort());
        strbfr.append(", macs:");
        strbfr.append(this.getMacsOnSegment());
        strbfr.append("]\n");
        for (BridgeBridgeLink blink : this.getBridgeBridgeLinks()) {
            strbfr.append(blink.printTopology());
        }
        for (BridgeMacLink mlink : this.getBridgeMacLinks()) {
            strbfr.append(mlink.printTopology());
        }
        return strbfr.toString();
    }
}

