/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Producer;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpMethods;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.http.common.HttpCommonEndpoint;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.http.common.HttpOperationFailedException;
import org.apache.camel.http.common.HttpProtocolHeaderFilterStrategy;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.GZIPHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(HttpProducer.class);
    private HttpClient httpClient;
    private boolean throwException;
    private boolean transferException;
    private HeaderFilterStrategy httpProtocolHeaderFilterStrategy = new HttpProtocolHeaderFilterStrategy();

    public HttpProducer(HttpEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.httpClient = endpoint.createHttpClient();
        this.throwException = endpoint.isThrowExceptionOnFailure();
        this.transferException = endpoint.isTransferException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        block11: {
            Map skipRequestHeaders = null;
            if (this.getEndpoint().isBridgeEndpoint()) {
                exchange.setProperty("CamelSkipGzipEncoding", (Object)Boolean.TRUE);
                String queryString = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
                if (queryString != null) {
                    skipRequestHeaders = URISupport.parseQuery((String)queryString, (boolean)false, (boolean)true);
                }
                exchange.getIn().getHeaders().remove("host");
            }
            HttpMethod method = this.createMethod(exchange);
            Message in = exchange.getIn();
            String httpProtocolVersion = (String)in.getHeader("CamelHttpProtocolVersion", String.class);
            if (httpProtocolVersion != null) {
                HttpMethodParams params = method.getParams();
                params.setVersion(HttpVersion.parse((String)httpProtocolVersion));
            }
            HeaderFilterStrategy strategy = this.getEndpoint().getHeaderFilterStrategy();
            for (Map.Entry entry : in.getHeaders().entrySet()) {
                String key = (String)entry.getKey();
                Object headerValue = in.getHeader(key);
                if (headerValue == null) continue;
                Iterator it = ObjectHelper.createIterator((Object)headerValue, null, (boolean)true);
                ArrayList<String> values = new ArrayList<String>();
                while (it.hasNext()) {
                    String value = (String)exchange.getContext().getTypeConverter().convertTo(String.class, it.next());
                    if (skipRequestHeaders != null && skipRequestHeaders.containsKey(key) || value == null || strategy == null || strategy.applyFilterToCamelHeaders(key, (Object)value, exchange)) continue;
                    values.add(value);
                }
                if (values.size() <= 0) continue;
                String s = values.size() > 1 ? ((Object)values).toString() : (String)values.get(0);
                method.addRequestHeader(key, s);
            }
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Executing http {} method: {}", (Object)method.getName(), (Object)method.getURI().toString());
                }
                int responseCode = this.executeMethod(method);
                LOG.debug("Http responseCode: {}", (Object)responseCode);
                if (!this.throwException) {
                    this.populateResponse(exchange, method, in, strategy, responseCode);
                    break block11;
                }
                boolean ok = HttpHelper.isStatusCodeOk((int)responseCode, (String)this.getEndpoint().getOkStatusCodeRange());
                if (ok) {
                    this.populateResponse(exchange, method, in, strategy, responseCode);
                    break block11;
                }
                throw this.populateHttpOperationFailedException(exchange, method, responseCode);
            }
            finally {
                method.releaseConnection();
            }
        }
    }

    public HttpEndpoint getEndpoint() {
        return (HttpEndpoint)super.getEndpoint();
    }

    protected void populateResponse(Exchange exchange, HttpMethod method, Message in, HeaderFilterStrategy strategy, int responseCode) throws IOException, ClassNotFoundException {
        Header[] headers;
        Object response = this.extractResponseBody(method, exchange, this.getEndpoint().isIgnoreResponseBody());
        Message answer = exchange.getOut();
        answer.setHeader("CamelHttpResponseCode", (Object)responseCode);
        answer.setHeader("CamelHttpResponseText", (Object)method.getStatusText());
        answer.setBody(response);
        for (Header header : headers = method.getResponseHeaders()) {
            String name = header.getName();
            String value = header.getValue();
            if (name.toLowerCase().equals("content-type")) {
                name = "Content-Type";
                exchange.setProperty("CamelCharsetName", (Object)IOHelper.getCharsetNameFromContentType((String)value));
            }
            Object extracted = HttpHelper.extractHttpParameterValue((String)value);
            if (strategy == null || strategy.applyFilterToExternalHeaders(name, extracted, exchange)) continue;
            HttpHelper.appendHeader((Map)answer.getHeaders(), (String)name, (Object)extracted);
        }
        if (this.getEndpoint().isCopyHeaders()) {
            MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)answer, (HeaderFilterStrategy)this.httpProtocolHeaderFilterStrategy, (boolean)false);
        }
    }

    protected Exception populateHttpOperationFailedException(Exchange exchange, HttpMethod method, int responseCode) throws IOException, ClassNotFoundException {
        HttpOperationFailedException answer;
        String uri = method.getURI().toString();
        String statusText = method.getStatusLine() != null ? method.getStatusLine().getReasonPhrase() : null;
        Map<String, String> headers = HttpProducer.extractResponseHeaders(method.getResponseHeaders());
        Object responseBody = this.extractResponseBody(method, exchange, this.getEndpoint().isIgnoreResponseBody());
        if (this.transferException && responseBody != null && responseBody instanceof Exception) {
            return (Exception)responseBody;
        }
        String copy = null;
        if (responseBody != null) {
            copy = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, responseBody);
        }
        if (responseCode >= 300 && responseCode < 400) {
            Header locationHeader = method.getResponseHeader("location");
            if (locationHeader != null) {
                String redirectLocation = locationHeader.getValue();
                answer = new HttpOperationFailedException(uri, responseCode, statusText, redirectLocation, headers, copy);
            } else {
                answer = new HttpOperationFailedException(uri, responseCode, statusText, null, headers, copy);
            }
        } else {
            answer = new HttpOperationFailedException(uri, responseCode, statusText, null, headers, copy);
        }
        return answer;
    }

    protected int executeMethod(HttpMethod method) throws IOException {
        return this.httpClient.executeMethod(method);
    }

    protected static Map<String, String> extractResponseHeaders(Header[] responseHeaders) {
        if (responseHeaders == null || responseHeaders.length == 0) {
            return null;
        }
        HashMap<String, String> answer = new HashMap<String, String>();
        for (Header header : responseHeaders) {
            answer.put(header.getName(), header.getValue());
        }
        return answer;
    }

    protected Object extractResponseBody(HttpMethod method, Exchange exchange, boolean ignoreResponseBody) throws IOException, ClassNotFoundException {
        String contentEncoding;
        InputStream is = method.getResponseBodyAsStream();
        if (is == null) {
            return null;
        }
        Header header = method.getResponseHeader("Content-Encoding");
        String string = contentEncoding = header != null ? header.getValue() : null;
        if (!((Boolean)exchange.getProperty("CamelSkipGzipEncoding", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
            is = GZIPHelper.uncompressGzip((String)contentEncoding, (InputStream)is);
        }
        String contentType = null;
        header = method.getResponseHeader("content-type");
        if (header != null) {
            contentType = header.getValue();
            HttpHelper.setCharsetFromContentType((String)contentType, (Exchange)exchange);
        }
        if (contentType != null && contentType.equals("application/x-java-serialized-object")) {
            if (this.getEndpoint().getComponent().isAllowJavaSerializedObject() || this.getEndpoint().isTransferException()) {
                return HttpHelper.deserializeJavaObjectFromStream((InputStream)is, (CamelContext)exchange.getContext());
            }
            return null;
        }
        InputStream response = null;
        if (!ignoreResponseBody) {
            response = HttpProducer.doExtractResponseBodyAsStream(is, exchange);
        }
        return response;
    }

    private static InputStream doExtractResponseBodyAsStream(InputStream is, Exchange exchange) throws IOException {
        CachedOutputStream cos = null;
        try {
            cos = new CachedOutputStream(exchange, false);
            IOHelper.copy((InputStream)is, (OutputStream)cos);
            InputStream inputStream = cos.getWrappedInputStream();
            return inputStream;
        }
        catch (IOException ex) {
            try {
                cos.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw ex;
        }
        finally {
            IOHelper.close((Closeable)is, (String)"Extracting response body", (Logger)LOG);
        }
    }

    protected HttpMethod createMethod(Exchange exchange) throws Exception {
        String url = HttpHelper.createURL((Exchange)exchange, (HttpCommonEndpoint)this.getEndpoint());
        URI uri = HttpHelper.createURI((Exchange)exchange, (String)url, (HttpCommonEndpoint)this.getEndpoint());
        url = uri.toASCIIString();
        String queryString = uri.getRawQuery();
        String rewriteUrl = HttpHelper.urlRewrite((Exchange)exchange, (String)url, (HttpCommonEndpoint)this.getEndpoint(), (Producer)this);
        if (rewriteUrl != null) {
            url = rewriteUrl;
            uri = new URI(url);
            queryString = uri.getRawQuery();
        }
        if (url.indexOf(63) != -1) {
            url = url.substring(0, url.indexOf(63));
        }
        RequestEntity requestEntity = this.createRequestEntity(exchange);
        String methodName = HttpHelper.createMethod((Exchange)exchange, (HttpCommonEndpoint)this.getEndpoint(), (requestEntity != null ? 1 : 0) != 0).name();
        HttpMethods methodsToUse = HttpMethods.valueOf(methodName);
        HttpMethod method = methodsToUse.createMethod(url);
        if (queryString != null) {
            queryString = UnsafeUriCharactersEncoder.encode((String)queryString);
            method.setQueryString(queryString);
        }
        LOG.trace("Using URL: {} with method: {}", (Object)url, (Object)method);
        if (methodsToUse.isEntityEnclosing()) {
            ((EntityEnclosingMethod)method).setRequestEntity(requestEntity);
            if (requestEntity != null && requestEntity.getContentType() == null) {
                LOG.debug("No Content-Type provided for URL: {} with exchange: {}", (Object)url, (Object)exchange);
            }
        }
        if (method.getHostConfiguration().getHost() == null) {
            throw new IllegalArgumentException("Invalid uri: " + url + ". If you are forwarding/bridging http endpoints, then enable the bridgeEndpoint option on the endpoint: " + (Object)((Object)this.getEndpoint()));
        }
        return method;
    }

    protected RequestEntity createRequestEntity(Exchange exchange) throws CamelExchangeException {
        Message in = exchange.getIn();
        if (in.getBody() == null) {
            return null;
        }
        RequestEntity answer = (RequestEntity)in.getBody(RequestEntity.class);
        if (answer == null) {
            try {
                Object data = in.getBody();
                if (data != null) {
                    String contentType = ExchangeHelper.getContentType((Exchange)exchange);
                    if (contentType != null && "application/x-java-serialized-object".equals(contentType)) {
                        if (!this.getEndpoint().getComponent().isAllowJavaSerializedObject()) {
                            throw new CamelExchangeException("Content-type application/x-java-serialized-object is not allowed", exchange);
                        }
                        Serializable obj = (Serializable)in.getMandatoryBody(Serializable.class);
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        HttpHelper.writeObjectToStream((OutputStream)bos, (Object)obj);
                        answer = new ByteArrayRequestEntity(bos.toByteArray(), "application/x-java-serialized-object");
                        IOHelper.close((Closeable)bos);
                    } else if (data instanceof File || data instanceof GenericFile) {
                        File file = (File)in.getBody(File.class);
                        if (file != null) {
                            answer = new FileRequestEntity(file, contentType);
                        }
                    } else if (data instanceof String) {
                        String charset = IOHelper.getCharsetName((Exchange)exchange, (boolean)false);
                        answer = new StringRequestEntity((String)data, contentType, charset);
                    }
                    if (answer == null) {
                        InputStream is = (InputStream)in.getMandatoryBody(InputStream.class);
                        answer = new InputStreamRequestEntity(is, contentType);
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new CamelExchangeException("Error creating RequestEntity from message body", exchange, (Throwable)e);
            }
            catch (IOException e) {
                throw new CamelExchangeException("Error serializing message body", exchange, (Throwable)e);
            }
        }
        return answer;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

