/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.dns.client.rpc;

import java.net.InetAddress;
import java.util.concurrent.CompletableFuture;
import org.opennms.core.rpc.xml.AbstractXmlRpcModule;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.dns.client.rpc.DnsLookupRequestDTO;
import org.opennms.netmgt.provision.dns.client.rpc.DnsLookupResponseDTO;
import org.opennms.netmgt.provision.dns.client.rpc.QueryType;

public class DnsLookupClientRpcModule
extends AbstractXmlRpcModule<DnsLookupRequestDTO, DnsLookupResponseDTO> {
    public static final String RPC_MODULE_ID = "DNS";

    public DnsLookupClientRpcModule() {
        super(DnsLookupRequestDTO.class, DnsLookupResponseDTO.class);
    }

    public DnsLookupResponseDTO createResponseWithException(Throwable ex) {
        return new DnsLookupResponseDTO(ex);
    }

    public String getId() {
        return RPC_MODULE_ID;
    }

    public CompletableFuture<DnsLookupResponseDTO> execute(DnsLookupRequestDTO request) {
        CompletableFuture<DnsLookupResponseDTO> future = new CompletableFuture<DnsLookupResponseDTO>();
        try {
            InetAddress addr = InetAddressUtils.addr((String)request.getHostRequest());
            DnsLookupResponseDTO dto = new DnsLookupResponseDTO();
            QueryType queryType = request.getQueryType();
            if (queryType.equals((Object)QueryType.LOOKUP)) {
                dto.setHostResponse(addr.getHostAddress());
            } else if (queryType.equals((Object)QueryType.REVERSE_LOOKUP)) {
                dto.setHostResponse(addr.getCanonicalHostName());
            }
            future.complete(dto);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }
}

